/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.util.proxy;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.util.proxy.SecurityActions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.List;

public class DefineClassHelper {
    private static final SecuredPrivileged privileged = ClassFile.MAJOR_VERSION > 54 ? SecuredPrivileged.JAVA_OTHER : (ClassFile.MAJOR_VERSION >= 53 ? SecuredPrivileged.JAVA_9 : (ClassFile.MAJOR_VERSION >= 51 ? SecuredPrivileged.JAVA_7 : SecuredPrivileged.JAVA_OTHER));

    public static Class<?> toClass(String className, ClassLoader loader, ProtectionDomain domain, byte[] bcode) throws CannotCompileException {
        try {
            return privileged.defineClass(className, bcode, 0, bcode.length, loader, domain);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ClassFormatError e) {
            throw new CannotCompileException(e.getCause());
        }
        catch (Exception e) {
            throw new CannotCompileException(e);
        }
    }

    static Class<?> toPublicClass(String className, byte[] bcode) throws CannotCompileException {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            lookup = lookup.dropLookupMode(2);
            return lookup.defineClass(bcode);
        }
        catch (Throwable t) {
            throw new CannotCompileException(t);
        }
    }

    private DefineClassHelper() {
    }

    private static enum SecuredPrivileged {
        JAVA_9{
            private final Object stack;
            private final Method getCallerClass;
            private final ReferencedUnsafe sunMiscUnsafe;
            {
                Class<?> stackWalkerClass = null;
                try {
                    stackWalkerClass = Class.forName("java.lang.StackWalker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (stackWalkerClass != null) {
                    try {
                        Class<?> optionClass = Class.forName("java.lang.StackWalker$Option");
                        this.stack = stackWalkerClass.getMethod("getInstance", optionClass).invoke(null, optionClass.getEnumConstants()[0]);
                        this.getCallerClass = stackWalkerClass.getMethod("getCallerClass", new Class[0]);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("cannot initialize", e);
                    }
                } else {
                    this.stack = null;
                    this.getCallerClass = null;
                }
                this.sunMiscUnsafe = this.getReferencedUnsafe();
            }

            private final ReferencedUnsafe getReferencedUnsafe() {
                try {
                    if (null != JAVA_9 && this.getCallerClass.invoke(this.stack, new Object[0]) != ((Object)((Object)this)).getClass()) {
                        throw new IllegalAccessError("Access denied for caller.");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot initialize", e);
                }
                try {
                    SecurityActions.TheUnsafe usf = SecurityActions.getSunMiscUnsafeAnonymously();
                    List<Method> defineClassMethod = usf.methods.get("defineClass");
                    if (null == defineClassMethod) {
                        return null;
                    }
                    MethodHandle meth = MethodHandles.lookup().unreflect(defineClassMethod.get(0));
                    return new ReferencedUnsafe(usf, meth);
                }
                catch (Throwable e) {
                    throw new RuntimeException("cannot initialize", e);
                }
            }

            @Override
            public Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError {
                try {
                    if (this.getCallerClass.invoke(this.stack, new Object[0]) != DefineClassHelper.class) {
                        throw new IllegalAccessError("Access denied for caller.");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot initialize", e);
                }
                return this.sunMiscUnsafe.defineClass(name, b, off, len, loader, protectionDomain);
            }

            final class ReferencedUnsafe {
                private final SecurityActions.TheUnsafe sunMiscUnsafeTheUnsafe;
                private final MethodHandle defineClass;

                ReferencedUnsafe(SecurityActions.TheUnsafe usf, MethodHandle meth) {
                    this.sunMiscUnsafeTheUnsafe = usf;
                    this.defineClass = meth;
                }

                Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError {
                    try {
                        if (getCallerClass.invoke(stack, new Object[0]) != ((Object)((Object)JAVA_9)).getClass()) {
                            throw new IllegalAccessError("Access denied for caller.");
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("cannot initialize", e);
                    }
                    try {
                        return (Class)this.defineClass.invokeWithArguments(this.sunMiscUnsafeTheUnsafe.theUnsafe, name, b, off, len, loader, protectionDomain);
                    }
                    catch (Throwable e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (e instanceof ClassFormatError) {
                            throw (ClassFormatError)e;
                        }
                        throw new ClassFormatError(e.getMessage());
                    }
                }
            }
        }
        ,
        JAVA_7{
            private final SecurityActions stack = SecurityActions.stack;
            private final MethodHandle defineClass = this.getDefineClassMethodHandle();

            private final MethodHandle getDefineClassMethodHandle() {
                if (null != JAVA_7 && this.stack.getCallerClass() != ((Object)((Object)this)).getClass()) {
                    throw new IllegalAccessError("Access denied for caller.");
                }
                try {
                    return SecurityActions.getMethodHandle(ClassLoader.class, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class});
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("cannot initialize", e);
                }
            }

            @Override
            protected Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError {
                if (this.stack.getCallerClass() != DefineClassHelper.class) {
                    throw new IllegalAccessError("Access denied for caller.");
                }
                try {
                    return (Class)this.defineClass.invokeWithArguments(loader, name, b, off, len, protectionDomain);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof ClassFormatError) {
                        throw (ClassFormatError)e;
                    }
                    throw new ClassFormatError(e.getMessage());
                }
            }
        }
        ,
        JAVA_OTHER{
            private final Method defineClass = this.getDefineClassMethod();
            private final SecurityActions stack = SecurityActions.stack;

            private final Method getDefineClassMethod() {
                if (null != JAVA_OTHER && this.stack.getCallerClass() != ((Object)((Object)this)).getClass()) {
                    throw new IllegalAccessError("Access denied for caller.");
                }
                try {
                    return SecurityActions.getDeclaredMethod(ClassLoader.class, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class});
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("cannot initialize", e);
                }
            }

            @Override
            protected Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) throws ClassFormatError {
                if (this.stack.getCallerClass() != DefineClassHelper.class) {
                    throw new IllegalAccessError("Access denied for caller.");
                }
                try {
                    SecurityActions.setAccessible(this.defineClass, true);
                    Class clazz = (Class)this.defineClass.invoke((Object)loader, name, b, off, len, protectionDomain);
                    return clazz;
                }
                catch (Throwable e) {
                    if (e instanceof ClassFormatError) {
                        throw (ClassFormatError)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new ClassFormatError(e.getMessage());
                }
                finally {
                    SecurityActions.setAccessible(this.defineClass, false);
                }
            }
        };


        protected abstract Class<?> defineClass(String var1, byte[] var2, int var3, int var4, ClassLoader var5, ProtectionDomain var6) throws ClassFormatError;
    }
}

