/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker.jmx;

import com.alibaba.securitysdk.logging.circuitbreaker.exception.MBeanLaunchException;
import com.alibaba.securitysdk.logging.circuitbreaker.jmx.DiskspaceUsage;
import com.alibaba.securitysdk.logging.circuitbreaker.jmx.InitiableDiskspaceMXBean;
import com.alibaba.securitysdk.logging.utils.OsUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DiskspaceImpl
implements InitiableDiskspaceMXBean {
    private static final String DOMAIN = "com.alibaba.securitysdk";
    private static final String OBJECT_NAME = "com.alibaba.securitysdk:type=Diskspace";
    private static final List<DiskspaceUsage> DISKSPACE_USAGES = new ArrayList<DiskspaceUsage>();
    private static volatile boolean INITIATED = false;
    private DiskspaceUsage workingDiskspaceUsage;

    @Override
    public List<DiskspaceUsage> getRootDiskspaceUsages() {
        return DISKSPACE_USAGES;
    }

    @Override
    public DiskspaceUsage getWorkingDiskspaceUsage() {
        return this.workingDiskspaceUsage;
    }

    @Override
    public ObjectName getObjectName() {
        return DiskspaceImpl.getName();
    }

    public static ObjectName getName() {
        try {
            return new ObjectName(OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanLaunchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initiate() {
        this.workingDiskspaceUsage = this.createDiskspaceUsage(new File(OsUtils.getUserHome()));
        DiskspaceImpl diskspaceImpl = this;
        synchronized (diskspaceImpl) {
            if (!INITIATED) {
                File mtabFile;
                for (File root : File.listRoots()) {
                    DISKSPACE_USAGES.add(this.createDiskspaceUsage(root));
                }
                if (OsUtils.isUnix() && (mtabFile = new File("/etc/mtab")).exists() && mtabFile.canRead()) {
                    this.processMtabFile(mtabFile);
                }
                INITIATED = true;
            }
        }
    }

    private void processMtabFile(File mtabFile) {
        List<File> files = Arrays.asList(File.listRoots());
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(mtabFile));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String[] fields = line.split(" ");
                File mountPoint = new File(fields[1]);
                if (files.contains(mountPoint) || !mountPoint.exists() || !mountPoint.isDirectory()) continue;
                DISKSPACE_USAGES.add(this.createDiskspaceUsage(mountPoint));
            }
        }
        catch (Exception ex) {
            throw new MBeanLaunchException(String.format("Cannot read \"%s\"", mtabFile), ex);
        }
    }

    private DiskspaceUsage createDiskspaceUsage(File root) {
        return new DiskspaceUsage(root.getAbsolutePath(), root.getTotalSpace(), root.getFreeSpace(), root.getUsableSpace());
    }
}

