/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker;

import com.alibaba.securitysdk.logging.circuitbreaker.CircuitBreakerEvent;
import com.alibaba.securitysdk.logging.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.circuitbreaker.breaker.CompositeCircuitBreaker;
import com.alibaba.securitysdk.logging.circuitbreaker.breaker.ThresholdEventCountCircuitBreaker;
import com.alibaba.securitysdk.logging.circuitbreaker.event.MemoryThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.circuitbreaker.event.OsThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.circuitbreaker.event.SpaceThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.circuitbreaker.jmx.MBeanLauncher;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public enum CircuitBreakerMonitor {
    INSTANCE;

    private static final double DEFAULT_CPU_LOAD_THRESSHOD = 0.7;
    private static final double DEFAULT_OS_MEMORY_RATIO = 0.8;
    private static final double DEFAULT_HEAP_MEMORY_RATIO = 1.0;
    private static final double DEFAULT_NON_HEAP_MEMORY_RATIO = 0.8;
    private static final double DEFAULT_WORKING_SPACE_RATIO = 0.8;
    private static final int DEFAULT_OPENING_TIMES = 8;
    private static final int DEFAULT_CLOSING_TIMES = 3;
    private static final int DEFAULT_INTERVAL_SECONDS = 3;
    private static final long DEFAULT_SCHEDULE_DELAY_MS = 10000L;
    private static final long DEFAULT_SCHEDULE_PERIOD_MS = 3000L;
    private Long scheduleDelayMs;
    private Long schedulePeriodMs;
    private final TimeUnit DEFAULT_INTERVAL_TIME_UNIT = TimeUnit.SECONDS;
    private final CompositeCircuitBreaker COMPOSITE_CIRCUIT_BREAKER;
    private OsThresholdCircuitBreakerEvent osThresholdCircuitBreakerEvent;
    private MemoryThresholdCircuitBreakerEvent memoryThresholdCircuitBreakerEvent;
    private SpaceThresholdCircuitBreakerEvent spaceThresholdCircuitBreakerEvent;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    private CircuitBreakerMonitor() {
        this.lauchJMXBeans();
        this.COMPOSITE_CIRCUIT_BREAKER = new CompositeCircuitBreaker();
        this.osThresholdCircuitBreakerEvent = new OsThresholdCircuitBreakerEvent(0.7, 0.8);
        this.memoryThresholdCircuitBreakerEvent = new MemoryThresholdCircuitBreakerEvent(1.0, 0.8);
        this.spaceThresholdCircuitBreakerEvent = new SpaceThresholdCircuitBreakerEvent(0.8);
        this.registerThresholdEventCountCircuitBreakers();
    }

    private void lauchJMXBeans() {
        MBeanLauncher.launch();
    }

    private void registerThresholdEventCountCircuitBreakers() {
        this.registerThresholdEventCountCircuitBreaker(OsThresholdCircuitBreakerEvent.class);
        this.registerThresholdEventCountCircuitBreaker(MemoryThresholdCircuitBreakerEvent.class);
        this.registerThresholdEventCountCircuitBreaker(SpaceThresholdCircuitBreakerEvent.class);
    }

    private void registerThresholdEventCountCircuitBreaker(Class<? extends ThresholdCircuitBreakerEvent> eventClass) {
        this.COMPOSITE_CIRCUIT_BREAKER.registerCircuitBreaker(this.buildThresholdEventCountCircuitBreaker(eventClass));
    }

    private ThresholdEventCountCircuitBreaker buildThresholdEventCountCircuitBreaker(Class<? extends ThresholdCircuitBreakerEvent> eventClass) {
        return ThresholdEventCountCircuitBreaker.builder().setValueType(eventClass).setOpeningEventTimes(8).setOpeningInterval(3L).setOpeningUnit(this.DEFAULT_INTERVAL_TIME_UNIT).setClosingEventTimes(3).setClosingInterval(3L).setClosingUnit(this.DEFAULT_INTERVAL_TIME_UNIT).build();
    }

    private void fireEvent(CircuitBreakerEvent event) {
        this.COMPOSITE_CIRCUIT_BREAKER.incrementAndCheckState(event);
    }

    private void scheduleEventFiring() {
        new Timer("Circuit-Breaker", true).schedule(new TimerTask(){

            @Override
            public void run() {
                CircuitBreakerMonitor.this.fireEvent(CircuitBreakerMonitor.this.osThresholdCircuitBreakerEvent);
                CircuitBreakerMonitor.this.fireEvent(CircuitBreakerMonitor.this.memoryThresholdCircuitBreakerEvent);
                CircuitBreakerMonitor.this.fireEvent(CircuitBreakerMonitor.this.spaceThresholdCircuitBreakerEvent);
            }
        }, this.scheduleDelayMs, (long)this.schedulePeriodMs);
    }

    public void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.scheduleDelayMs = this.scheduleDelayMs == null ? 10000L : this.scheduleDelayMs;
            this.schedulePeriodMs = this.schedulePeriodMs == null ? 3000L : this.schedulePeriodMs;
            this.scheduleEventFiring();
        }
    }

    public void tryStart() throws TimeoutException {
        this.tryStart(10000L);
    }

    @Deprecated
    public void tryStart(long waitMs) throws TimeoutException {
        AssertUtil.notNull((Object)waitMs);
        long endTime = waitMs + System.currentTimeMillis();
        do {
            if (endTime > System.currentTimeMillis()) {
                throw new TimeoutException();
            }
            this.start();
        } while (!this.COMPOSITE_CIRCUIT_BREAKER.isOpen());
    }

    public CompositeCircuitBreaker getCircuitBreaker() {
        return this.COMPOSITE_CIRCUIT_BREAKER;
    }

    public long getScheduleDelayMs() {
        return this.scheduleDelayMs;
    }

    public void setScheduleDelayMs(long scheduleDelayMs) {
        this.scheduleDelayMs = scheduleDelayMs;
    }

    public long getSchedulePeriodMs() {
        return this.schedulePeriodMs;
    }

    public void setSchedulePeriodMs(long schedulePeriodMs) {
        this.schedulePeriodMs = schedulePeriodMs;
    }
}

