/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.merge.diff.common;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PackageDiffCommonTools {
    public static void buildMap(WorkflowProjectPackage pkg, Map<String, Workflow> workflowMap, Map<String, WorkflowNode> workflowNodeMap, Map<String, RelationPackage> relationMap) {
        if (pkg.getWorkflowList() != null && !pkg.getWorkflowList().isEmpty()) {
            for (Workflow workflow : pkg.getWorkflowList()) {
                workflowMap.put(workflow.getWorkflowId(), workflow);
                if (workflow.getWorkflowNodes() != null && !workflow.getWorkflowNodes().isEmpty()) {
                    for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
                        workflowNodeMap.put(workflowNode.getNodeId(), workflowNode);
                    }
                }
                if (workflow.getNodeRelations() == null || workflow.getNodeRelations().isEmpty()) continue;
                for (RelationPackage relation : workflow.getNodeRelations()) {
                    relationMap.put(relation.getFrom() + " -> " + relation.getTo(), relation);
                }
            }
        }
    }

    public static void RefreshIdInPackage(WorkflowProjectPackage workflowProjectPackage) {
        HashMap idMap = new HashMap();
        if (workflowProjectPackage.getWorkflowList() != null && !workflowProjectPackage.getWorkflowList().isEmpty()) {
            workflowProjectPackage.getWorkflowList().forEach(wf -> {
                if (wf.getCustomProperties() != null && wf.getCustomProperties().containsKey("MigrationOriginalId")) {
                    wf.setTWorkflowId(wf.getWorkflowId());
                    wf.setWorkflowId(wf.getCustomProperties().get("MigrationOriginalId").toString());
                    idMap.put(wf.getTWorkflowId(), wf.getWorkflowId());
                }
                if (wf.getWorkflowNodes() != null && !wf.getWorkflowNodes().isEmpty()) {
                    wf.getWorkflowNodes().forEach(node -> {
                        if (node.getCustomProperties() != null && node.getCustomProperties().containsKey("MigrationOriginalId")) {
                            node.setWorkflowId(wf.getWorkflowId());
                            node.setTNodeId(node.getNodeId());
                            node.setNodeId(node.getCustomProperties().get("MigrationOriginalId").toString());
                            idMap.put(node.getTNodeId(), node.getNodeId());
                        }
                    });
                }
            });
        }
        if (workflowProjectPackage.getWorkflowList() != null && !workflowProjectPackage.getWorkflowList().isEmpty()) {
            workflowProjectPackage.getWorkflowList().forEach(wf -> {
                if (wf.getNodeRelations() != null && !wf.getNodeRelations().isEmpty()) {
                    wf.getNodeRelations().forEach(relationPackage -> {
                        if (!StringUtils.isEmpty((CharSequence)relationPackage.getFrom()) && idMap.containsKey(relationPackage.getFrom())) {
                            relationPackage.setFrom((String)idMap.get(relationPackage.getFrom()));
                        }
                        if (!StringUtils.isEmpty((CharSequence)relationPackage.getTo()) && idMap.containsKey(relationPackage.getTo())) {
                            relationPackage.setTo((String)idMap.get(relationPackage.getTo()));
                        }
                    });
                }
            });
        }
    }
}

