/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.merge.diff;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffElement;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffCommonTools;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PackageDiffCompareTool {
    DiffIdGenerator diffIdGenerator = new DiffIdGenerator();

    public List<DiffElement> compare(WorkflowProjectPackage basePkg, WorkflowProjectPackage novelPkg, PackageDiffConstant.SourceOrTarget sourceOrTarget) {
        String workflowId;
        if (basePkg == null || novelPkg == null) {
            return null;
        }
        HashMap<String, Workflow> baseWorkflowMap = new HashMap<String, Workflow>();
        HashMap<String, WorkflowNode> baseWorkflowNodeMap = new HashMap<String, WorkflowNode>();
        HashMap<String, RelationPackage> baseRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap(basePkg, baseWorkflowMap, baseWorkflowNodeMap, baseRelationMap);
        HashMap<String, Workflow> novelWorkflowMap = new HashMap<String, Workflow>();
        HashMap<String, WorkflowNode> novelWorkflowNodeMap = new HashMap<String, WorkflowNode>();
        HashMap<String, RelationPackage> novelRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap(novelPkg, novelWorkflowMap, novelWorkflowNodeMap, novelRelationMap);
        List<DiffElement> diffWorkflowElements = this.compareWorkflow(baseWorkflowMap, novelWorkflowMap, sourceOrTarget, this.diffIdGenerator);
        List<DiffElement> diffNodeElements = this.compareWorkflowNode(baseWorkflowNodeMap, novelWorkflowNodeMap, sourceOrTarget, this.diffIdGenerator);
        List<DiffElement> diffRelationElements = this.compareRelation(baseRelationMap, novelRelationMap, sourceOrTarget, this.diffIdGenerator);
        for (DiffElement diffNode2 : diffNodeElements) {
            if (!diffNode2.getDiffType().getElementType().equals((Object)PackageDiffConstant.ElementType.NODE) || !diffNode2.getDiffType().getOperationType().equals((Object)PackageDiffConstant.OperationType.CREATE) && !diffNode2.getDiffType().getOperationType().equals((Object)PackageDiffConstant.OperationType.DELETE)) continue;
            String nodeId = diffNode2.getWorkflowNode().getNodeId();
            for (DiffElement diffRelation2 : diffRelationElements) {
                if (!StringUtils.equals((CharSequence)diffRelation2.getRelation().getFrom(), (CharSequence)nodeId) && !StringUtils.equals((CharSequence)diffRelation2.getRelation().getTo(), (CharSequence)nodeId)) continue;
                if (diffNode2.getChildDiffId() == null) {
                    diffNode2.setChildDiffId(new ArrayList<String>());
                }
                diffNode2.getChildDiffId().add(diffRelation2.getDiffId());
            }
        }
        for (DiffElement diffWorkflow2 : diffWorkflowElements) {
            if (!diffWorkflow2.getDiffType().getElementType().equals((Object)PackageDiffConstant.ElementType.WORKFLOW) || !diffWorkflow2.getDiffType().getOperationType().equals((Object)PackageDiffConstant.OperationType.CREATE) && !diffWorkflow2.getDiffType().getOperationType().equals((Object)PackageDiffConstant.OperationType.DELETE)) continue;
            workflowId = diffWorkflow2.getWorkflow().getWorkflowId();
            for (DiffElement diffRelation2 : diffRelationElements) {
                if (!StringUtils.equals((CharSequence)diffRelation2.getRelation().getFrom(), (CharSequence)workflowId) && !StringUtils.equals((CharSequence)diffRelation2.getRelation().getTo(), (CharSequence)workflowId)) continue;
                if (diffWorkflow2.getChildDiffId() == null) {
                    diffWorkflow2.setChildDiffId(new ArrayList<String>());
                }
                diffWorkflow2.getChildDiffId().add(diffRelation2.getDiffId());
            }
        }
        for (DiffElement diffWorkflow2 : diffWorkflowElements) {
            if (!diffWorkflow2.getDiffType().getElementType().equals((Object)PackageDiffConstant.ElementType.WORKFLOW) || !diffWorkflow2.getDiffType().getOperationType().equals((Object)PackageDiffConstant.OperationType.CREATE) && !diffWorkflow2.getDiffType().getOperationType().equals((Object)PackageDiffConstant.OperationType.DELETE)) continue;
            workflowId = diffWorkflow2.getWorkflow().getWorkflowId();
            for (DiffElement diffNode3 : diffNodeElements) {
                if (!diffNode3.getDiffType().getElementType().equals((Object)PackageDiffConstant.ElementType.NODE) || !StringUtils.equals((CharSequence)diffNode3.getWorkflowNode().getWorkflowId(), (CharSequence)workflowId)) continue;
                if (diffWorkflow2.getChildDiffId() == null) {
                    diffWorkflow2.setChildDiffId(new ArrayList<String>());
                }
                diffWorkflow2.getChildDiffId().add(diffNode3.getDiffId());
            }
        }
        if (!CollectionUtils.isEmpty(diffWorkflowElements)) {
            diffWorkflowElements.forEach(diffWorkflow -> diffWorkflow.setProject(basePkg.getWorkflowProject()));
        }
        if (!CollectionUtils.isEmpty(diffNodeElements)) {
            diffNodeElements.forEach(diffNode -> diffNode.setProject(basePkg.getWorkflowProject()));
        }
        if (!CollectionUtils.isEmpty(diffRelationElements)) {
            diffRelationElements.forEach(diffRelation -> diffRelation.setProject(basePkg.getWorkflowProject()));
        }
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        diffElements.addAll(diffWorkflowElements);
        diffElements.addAll(diffNodeElements);
        diffElements.addAll(diffRelationElements);
        return diffElements;
    }

    public List<DiffElement> compareWorkflow(Map<String, Workflow> baseWorkflowMap, Map<String, Workflow> novelWorkflowMap, PackageDiffConstant.SourceOrTarget sourceOrTarget, DiffIdGenerator diffIdGenerator) {
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        HashSet<String> workflows = new HashSet<String>();
        workflows.addAll(baseWorkflowMap.keySet());
        workflows.addAll(novelWorkflowMap.keySet());
        for (String workflowId : workflows) {
            PackageDiffConstant.DiffType diffType;
            Workflow baseWorkflow;
            if (baseWorkflowMap.containsKey(workflowId) && novelWorkflowMap.containsKey(workflowId)) {
                baseWorkflow = baseWorkflowMap.get(workflowId);
                Workflow novelWorkflow = novelWorkflowMap.get(workflowId);
                diffElements.addAll(this.compareSingleWorkflowProperties(baseWorkflow, novelWorkflow, sourceOrTarget, diffIdGenerator));
                continue;
            }
            if (baseWorkflowMap.containsKey(workflowId) && !novelWorkflowMap.containsKey(workflowId)) {
                baseWorkflow = baseWorkflowMap.get(workflowId);
                diffType = PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.DELETE, sourceOrTarget);
                diffElements.add(DiffElement.builder().diffType(diffType).workflow(baseWorkflow).diffId(diffIdGenerator.getDiffId()).build());
                continue;
            }
            if (baseWorkflowMap.containsKey(workflowId) || !novelWorkflowMap.containsKey(workflowId)) continue;
            Workflow novelWorkflow = novelWorkflowMap.get(workflowId);
            diffType = PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.CREATE, sourceOrTarget);
            diffElements.add(DiffElement.builder().diffType(diffType).workflow(novelWorkflow).diffId(diffIdGenerator.getDiffId()).build());
        }
        return diffElements;
    }

    public List<DiffElement> compareSingleWorkflowProperties(Workflow baseWorkflow, Workflow novelWorkflow, PackageDiffConstant.SourceOrTarget sourceOrTarget, DiffIdGenerator diffIdGenerator) {
        String novelInstanceMode;
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        if (!StringUtils.equals((CharSequence)baseWorkflow.getOwner(), (CharSequence)novelWorkflow.getOwner())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflow(novelWorkflow).propertyPath(PackageDiffConstant.WorkflowPropertyType.Owner.getDescription()).propertyValue(novelWorkflow.getOwner()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (!StringUtils.equals((CharSequence)baseWorkflow.getDescription(), (CharSequence)novelWorkflow.getDescription())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflow(novelWorkflow).propertyPath(PackageDiffConstant.WorkflowPropertyType.Description.getDescription()).propertyValue(novelWorkflow.getDescription()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (baseWorkflow.getParamMap() != null && novelWorkflow.getParamMap() != null) {
            AtomicReference<Boolean> isEqual = new AtomicReference<Boolean>(true);
            baseWorkflow.getParamMap().forEach((key, value) -> {
                if (!((Boolean)isEqual.get()).booleanValue()) {
                    return;
                }
                if (!novelWorkflow.getParamMap().containsKey(key) || !ObjectUtils.equals((Object)value, novelWorkflow.getParamMap().get(key))) {
                    isEqual.set(false);
                }
            });
            novelWorkflow.getParamMap().forEach((key, value) -> {
                if (!((Boolean)isEqual.get()).booleanValue()) {
                    return;
                }
                if (!baseWorkflow.getParamMap().containsKey(key) || !ObjectUtils.equals((Object)value, baseWorkflow.getParamMap().get(key))) {
                    isEqual.set(false);
                }
            });
            if (!isEqual.get().booleanValue()) {
                JSONObject paramJsonObject = new JSONObject();
                paramJsonObject.putAll(novelWorkflow.getParamMap());
                diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflow(novelWorkflow).propertyPath(PackageDiffConstant.WorkflowPropertyType.ParamMap.getDescription()).propertyValue(paramJsonObject.toJSONString(new JSONWriter.Feature[0])).diffId(diffIdGenerator.getDiffId()).build());
            }
        } else if ((baseWorkflow.getParamMap() == null || baseWorkflow.getParamMap().isEmpty()) ^ (novelWorkflow.getParamMap() == null || novelWorkflow.getParamMap().isEmpty())) {
            JSONObject paramJsonObject = new JSONObject();
            if (novelWorkflow.getParamMap() != null) {
                paramJsonObject.putAll(baseWorkflow.getParamMap());
            }
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflow(novelWorkflow).propertyPath(PackageDiffConstant.WorkflowPropertyType.ParamMap.getDescription()).propertyValue(paramJsonObject.toJSONString(new JSONWriter.Feature[0])).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (baseWorkflow.getTriggers() != null && !baseWorkflow.getTriggers().isEmpty() && novelWorkflow.getTriggers() != null && !novelWorkflow.getTriggers().isEmpty()) {
            if (!StringUtils.equals((CharSequence)((WorkflowTrigger)baseWorkflow.getTriggers().get(0)).getCron(), (CharSequence)((WorkflowTrigger)novelWorkflow.getTriggers().get(0)).getCron())) {
                diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflow(novelWorkflow).propertyPath(PackageDiffConstant.WorkflowPropertyType.Cron.getDescription()).propertyValue(((WorkflowTrigger)novelWorkflow.getTriggers().get(0)).getCron()).diffId(diffIdGenerator.getDiffId()).build());
            }
        } else if ((baseWorkflow.getTriggers() == null || baseWorkflow.getTriggers().isEmpty()) ^ (novelWorkflow.getTriggers() == null || novelWorkflow.getTriggers().isEmpty())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflow(novelWorkflow).propertyPath(PackageDiffConstant.WorkflowPropertyType.Cron.getDescription()).propertyValue(novelWorkflow.getTriggers() == null || novelWorkflow.getTriggers().isEmpty() ? null : ((WorkflowTrigger)novelWorkflow.getTriggers().get(0)).getCron()).diffId(diffIdGenerator.getDiffId()).build());
        }
        String baseInstanceMode = baseWorkflow.getCustomProperties() != null && baseWorkflow.getCustomProperties().containsKey("instance.mode") ? (String)baseWorkflow.getCustomProperties().get("instance.mode") : null;
        String string = novelInstanceMode = novelWorkflow.getCustomProperties() != null && novelWorkflow.getCustomProperties().containsKey("instance.mode") ? (String)novelWorkflow.getCustomProperties().get("instance.mode") : null;
        if (!StringUtils.equals((CharSequence)baseInstanceMode, novelInstanceMode)) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.WORKFLOW, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflow(novelWorkflow).propertyPath(PackageDiffConstant.WorkflowPropertyType.InstanceMode.getDescription()).propertyValue(novelInstanceMode).diffId(diffIdGenerator.getDiffId()).build());
        }
        return diffElements;
    }

    public List<DiffElement> compareWorkflowNode(Map<String, WorkflowNode> baseWorkflowNodeMap, Map<String, WorkflowNode> novelWorkflowNodeMap, PackageDiffConstant.SourceOrTarget sourceOrTarget, DiffIdGenerator diffIdGenerator) {
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        HashSet<String> workflowNodes = new HashSet<String>();
        workflowNodes.addAll(baseWorkflowNodeMap.keySet());
        workflowNodes.addAll(novelWorkflowNodeMap.keySet());
        for (String workflowNodeId : workflowNodes) {
            WorkflowNode baseWorkflowNode;
            if (baseWorkflowNodeMap.containsKey(workflowNodeId) && novelWorkflowNodeMap.containsKey(workflowNodeId)) {
                baseWorkflowNode = baseWorkflowNodeMap.get(workflowNodeId);
                WorkflowNode novelWorkflowNode = novelWorkflowNodeMap.get(workflowNodeId);
                diffElements.addAll(this.compareSingleWorkflowNodeProperties(baseWorkflowNode, novelWorkflowNode, sourceOrTarget, diffIdGenerator));
                continue;
            }
            if (baseWorkflowNodeMap.containsKey(workflowNodeId) && !novelWorkflowNodeMap.containsKey(workflowNodeId)) {
                baseWorkflowNode = baseWorkflowNodeMap.get(workflowNodeId);
                diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.DELETE, sourceOrTarget)).workflowNode(baseWorkflowNode).diffId(diffIdGenerator.getDiffId()).build());
                continue;
            }
            if (baseWorkflowNodeMap.containsKey(workflowNodeId) || !novelWorkflowNodeMap.containsKey(workflowNodeId)) continue;
            WorkflowNode novelWorkflowNode = novelWorkflowNodeMap.get(workflowNodeId);
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.CREATE, sourceOrTarget)).workflowNode(novelWorkflowNode).diffId(diffIdGenerator.getDiffId()).build());
        }
        return diffElements;
    }

    public List<DiffElement> compareSingleWorkflowNodeProperties(WorkflowNode baseWorkflowNode, WorkflowNode novelWorkflowNode, PackageDiffConstant.SourceOrTarget sourceOrTarget, DiffIdGenerator diffIdGenerator) {
        String novelWorkflowDiCu;
        String novelDiResourceGroupIdentifier;
        String novelImage;
        String novelWorkflowCu;
        String novelResourceGroupIdentifier;
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        if (!StringUtils.equals((CharSequence)baseWorkflowNode.getScript(), (CharSequence)novelWorkflowNode.getScript())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.Script.getDescription()).propertyValue(novelWorkflowNode.getScript()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (!StringUtils.equals((CharSequence)baseWorkflowNode.getOwner(), (CharSequence)novelWorkflowNode.getOwner())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.Owner.getDescription()).propertyValue(novelWorkflowNode.getOwner()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (!StringUtils.equals((CharSequence)baseWorkflowNode.getDescription(), (CharSequence)novelWorkflowNode.getDescription())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.Description.getDescription()).propertyValue(novelWorkflowNode.getDescription()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (baseWorkflowNode.getParamMap() != null && novelWorkflowNode.getParamMap() != null) {
            AtomicReference<Boolean> isEqual = new AtomicReference<Boolean>(true);
            baseWorkflowNode.getParamMap().forEach((key, value) -> {
                if (!((Boolean)isEqual.get()).booleanValue()) {
                    return;
                }
                if (!novelWorkflowNode.getParamMap().containsKey(key) || !ObjectUtils.equals((Object)value, novelWorkflowNode.getParamMap().get(key))) {
                    isEqual.set(false);
                }
            });
            novelWorkflowNode.getParamMap().forEach((key, value) -> {
                if (!((Boolean)isEqual.get()).booleanValue()) {
                    return;
                }
                if (!baseWorkflowNode.getParamMap().containsKey(key) || !ObjectUtils.equals((Object)value, baseWorkflowNode.getParamMap().get(key))) {
                    isEqual.set(false);
                }
            });
            if (!isEqual.get().booleanValue()) {
                JSONObject paramJsonObject = new JSONObject();
                paramJsonObject.putAll(novelWorkflowNode.getParamMap());
                diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.ParamMap.getDescription()).propertyValue(paramJsonObject.toJSONString(new JSONWriter.Feature[0])).diffId(diffIdGenerator.getDiffId()).build());
            }
        } else if ((baseWorkflowNode.getParamMap() == null || baseWorkflowNode.getParamMap().isEmpty()) ^ (novelWorkflowNode.getParamMap() == null || novelWorkflowNode.getParamMap().isEmpty())) {
            JSONObject paramJsonObject = new JSONObject();
            if (novelWorkflowNode.getParamMap() != null) {
                paramJsonObject.putAll(baseWorkflowNode.getParamMap());
            }
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.ParamMap.getDescription()).propertyValue(paramJsonObject.toJSONString(new JSONWriter.Feature[0])).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (baseWorkflowNode.getTrigger() != null && novelWorkflowNode.getTrigger() != null) {
            if (!StringUtils.equals((CharSequence)baseWorkflowNode.getTrigger().getCron(), (CharSequence)novelWorkflowNode.getTrigger().getCron())) {
                diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.Cron.getDescription()).propertyValue(novelWorkflowNode.getTrigger().getCron()).diffId(diffIdGenerator.getDiffId()).build());
            }
            return diffElements;
        }
        if (baseWorkflowNode.getTrigger() == null ^ novelWorkflowNode.getTrigger() == null) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.Cron.getDescription()).propertyValue(novelWorkflowNode.getTrigger() == null ? null : novelWorkflowNode.getTrigger().getCron()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (!ObjectUtils.equals((Object)baseWorkflowNode.getInstanceMode(), (Object)novelWorkflowNode.getInstanceMode())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.InstanceMode.getDescription()).propertyValue(novelWorkflowNode.getInstanceMode() == null ? null : novelWorkflowNode.getInstanceMode().name()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (!ObjectUtils.equals((Object)baseWorkflowNode.getState(), (Object)novelWorkflowNode.getState())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.State.getDescription()).propertyValue(novelWorkflowNode.getState() == null ? null : novelWorkflowNode.getState().name()).diffId(diffIdGenerator.getDiffId()).build());
        }
        if (!ObjectUtils.equals((Object)baseWorkflowNode.getRerunMode(), (Object)novelWorkflowNode.getRerunMode())) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.RerunMode.getDescription()).propertyValue(novelWorkflowNode.getRerunMode() == null ? null : novelWorkflowNode.getRerunMode().name()).diffId(diffIdGenerator.getDiffId()).build());
        }
        String baseResourceGroupIdentifier = baseWorkflowNode.getRuntimeResource() != null && baseWorkflowNode.getRuntimeResource().containsKey("resource.group.identifier") && !StringUtils.isEmpty((CharSequence)((String)baseWorkflowNode.getRuntimeResource().get("resource.group.identifier"))) ? (String)baseWorkflowNode.getRuntimeResource().get("resource.group.identifier") : null;
        String string = novelResourceGroupIdentifier = novelWorkflowNode.getRuntimeResource() != null && novelWorkflowNode.getRuntimeResource().containsKey("resource.group.identifier") && !StringUtils.isEmpty((CharSequence)((String)novelWorkflowNode.getRuntimeResource().get("resource.group.identifier"))) ? (String)novelWorkflowNode.getRuntimeResource().get("resource.group.identifier") : null;
        if (!StringUtils.equals(baseResourceGroupIdentifier, novelResourceGroupIdentifier)) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.ResourceGroupIdentifier.getDescription()).propertyValue(novelResourceGroupIdentifier).diffId(diffIdGenerator.getDiffId()).build());
        }
        String baseWorkflowCu = baseWorkflowNode.getRuntimeResource() != null && baseWorkflowNode.getRuntimeResource().containsKey("workflow.schedule.cu") && !StringUtils.isEmpty((CharSequence)((String)baseWorkflowNode.getRuntimeResource().get("workflow.schedule.cu"))) ? (String)baseWorkflowNode.getRuntimeResource().get("workflow.schedule.cu") : null;
        String string2 = novelWorkflowCu = novelWorkflowNode.getRuntimeResource() != null && novelWorkflowNode.getRuntimeResource().containsKey("workflow.schedule.cu") && !StringUtils.isEmpty((CharSequence)((String)novelWorkflowNode.getRuntimeResource().get("workflow.schedule.cu"))) ? (String)novelWorkflowNode.getRuntimeResource().get("workflow.schedule.cu") : null;
        if (!StringUtils.equals(baseWorkflowCu, novelWorkflowCu)) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.WorkflowCu.getDescription()).propertyValue(novelWorkflowCu).diffId(diffIdGenerator.getDiffId()).build());
        }
        String baseImage = baseWorkflowNode.getRuntimeResource() != null && baseWorkflowNode.getRuntimeResource().containsKey("resource.group.image.id") && !StringUtils.isEmpty((CharSequence)((String)baseWorkflowNode.getRuntimeResource().get("resource.group.image.id"))) ? (String)baseWorkflowNode.getRuntimeResource().get("resource.group.image.id") : null;
        String string3 = novelImage = novelWorkflowNode.getRuntimeResource() != null && novelWorkflowNode.getRuntimeResource().containsKey("resource.group.image.id") && !StringUtils.isEmpty((CharSequence)((String)novelWorkflowNode.getRuntimeResource().get("resource.group.image.id"))) ? (String)novelWorkflowNode.getRuntimeResource().get("resource.group.image.id") : null;
        if (!StringUtils.equals(baseImage, novelImage)) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.Image.getDescription()).propertyValue(novelImage).diffId(diffIdGenerator.getDiffId()).build());
        }
        String baseDiResourceGroupIdentifier = baseWorkflowNode.getRuntimeResource() != null && baseWorkflowNode.getRuntimeResource().containsKey("di.resource.group.identifier") && !StringUtils.isEmpty((CharSequence)((String)baseWorkflowNode.getRuntimeResource().get("di.resource.group.identifier"))) ? (String)baseWorkflowNode.getRuntimeResource().get("di.resource.group.identifier") : null;
        String string4 = novelDiResourceGroupIdentifier = novelWorkflowNode.getRuntimeResource() != null && novelWorkflowNode.getRuntimeResource().containsKey("di.resource.group.identifier") && !StringUtils.isEmpty((CharSequence)((String)novelWorkflowNode.getRuntimeResource().get("di.resource.group.identifier"))) ? (String)novelWorkflowNode.getRuntimeResource().get("di.resource.group.identifier") : null;
        if (!StringUtils.equals(baseDiResourceGroupIdentifier, novelDiResourceGroupIdentifier)) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.DiResourceGroupIdentifier.getDescription()).propertyValue(novelDiResourceGroupIdentifier).diffId(diffIdGenerator.getDiffId()).build());
        }
        String baseWorkflowDiCu = baseWorkflowNode.getRuntimeResource() != null && baseWorkflowNode.getRuntimeResource().containsKey("workflow.di.cu") && !StringUtils.isEmpty((CharSequence)((String)baseWorkflowNode.getRuntimeResource().get("workflow.di.cu"))) ? (String)baseWorkflowNode.getRuntimeResource().get("workflow.di.cu") : null;
        String string5 = novelWorkflowDiCu = novelWorkflowNode.getRuntimeResource() != null && novelWorkflowNode.getRuntimeResource().containsKey("workflow.di.cu") && !StringUtils.isEmpty((CharSequence)((String)novelWorkflowNode.getRuntimeResource().get("workflow.di.cu"))) ? (String)novelWorkflowNode.getRuntimeResource().get("workflow.di.cu") : null;
        if (!StringUtils.equals(baseWorkflowDiCu, novelWorkflowDiCu)) {
            diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.NODE, PackageDiffConstant.OperationType.PROPERTY_UPDATE, sourceOrTarget)).workflowNode(novelWorkflowNode).propertyPath(PackageDiffConstant.WorkflowNodePropertyType.DiWorkflowCu.getDescription()).propertyValue(novelWorkflowDiCu).diffId(diffIdGenerator.getDiffId()).build());
        }
        return diffElements;
    }

    public List<DiffElement> compareRelation(Map<String, RelationPackage> baseRelationMap, Map<String, RelationPackage> novelRelationMap, PackageDiffConstant.SourceOrTarget sourceOrTarget, DiffIdGenerator diffIdGenerator) {
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        baseRelationMap.forEach((key, baseRelation) -> {
            if (!novelRelationMap.containsKey(key)) {
                diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.RELATION, PackageDiffConstant.OperationType.DELETE, sourceOrTarget)).relation((RelationPackage)baseRelation).diffId(diffIdGenerator.getDiffId()).build());
            }
        });
        novelRelationMap.forEach((key, novelRelation) -> {
            if (!baseRelationMap.containsKey(key)) {
                diffElements.add(DiffElement.builder().diffType(PackageDiffConstant.DiffType.getDiffType(PackageDiffConstant.ElementType.RELATION, PackageDiffConstant.OperationType.CREATE, sourceOrTarget)).relation((RelationPackage)novelRelation).diffId(diffIdGenerator.getDiffId()).build());
            }
        });
        return diffElements;
    }

    public class DiffIdGenerator {
        public String getDiffId() {
            return UUID.randomUUID().toString();
        }
    }
}

