/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.event.jms;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.oozie.client.event.jms.MessageDeserializer;

public class JSONMessageDeserializer
extends MessageDeserializer {
    static ObjectMapper mapper = new ObjectMapper();

    @Override
    public <T> T getDeserializedObject(String messageBody, Class<T> clazz) {
        try {
            return (T)mapper.readValue(messageBody, clazz);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not deserialize the JMS message using " + clazz.getCanonicalName(), exception);
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

