/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.cli;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLIParser {
    private static final String LEFT_PADDING = "      ";
    private String cliName;
    private String[] cliHelp;
    private Map<String, Options> commands = new LinkedHashMap<String, Options>();
    private Map<String, Boolean> commandWithArgs = new LinkedHashMap<String, Boolean>();
    private Map<String, String> commandsHelp = new LinkedHashMap<String, String>();

    public CLIParser(String cliName, String[] cliHelp) {
        this.cliName = cliName;
        this.cliHelp = cliHelp;
    }

    public void addCommand(String command, String argsHelp, String commandHelp, Options commandOptions, boolean hasArguments) {
        String helpMsg = argsHelp + (hasArguments ? "<ARGS> " : "") + ": " + commandHelp;
        this.commandsHelp.put(command, helpMsg);
        this.commands.put(command, commandOptions);
        this.commandWithArgs.put(command, hasArguments);
    }

    public Command parse(String[] args) throws ParseException {
        if (args.length == 0) {
            throw new ParseException("missing sub-command");
        }
        if (this.commands.containsKey(args[0])) {
            OozieGnuParser parser;
            String[] minusCommand = new String[args.length - 1];
            System.arraycopy(args, 1, minusCommand, 0, minusCommand.length);
            if (args[0].equals("job")) {
                this.validdateArgs(args, minusCommand);
                parser = new OozieGnuParser(true);
            } else {
                parser = new OozieGnuParser(false);
            }
            return new Command(args[0], parser.parse(this.commands.get(args[0]), minusCommand, this.commandWithArgs.get(args[0])));
        }
        throw new ParseException(MessageFormat.format("invalid sub-command [{0}]", args[0]));
    }

    public void validdateArgs(String[] args, String[] minusCommand) throws ParseException {
        block2: {
            try {
                OozieGnuParser parser = new OozieGnuParser(false);
                parser.parse(this.commands.get(args[0]), minusCommand, this.commandWithArgs.get(args[0]));
            }
            catch (MissingOptionException e) {
                if (Arrays.toString(args).contains("-dryrun")) break block2;
                throw e;
            }
        }
    }

    public String shortHelp() {
        return "use 'help [sub-command]' for help details";
    }

    public void showHelp(CommandLine commandLine) {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
        PrintWriter pw = new PrintWriter(writer);
        pw.println("usage: ");
        for (String s : this.cliHelp) {
            pw.println(LEFT_PADDING + s);
        }
        pw.println();
        HelpFormatter formatter = new HelpFormatter();
        Set<String> commandsToPrint = this.commands.keySet();
        String[] args = commandLine.getArgs();
        if (args.length > 0 && commandsToPrint.contains(args[0])) {
            commandsToPrint = new HashSet<String>();
            commandsToPrint.add(args[0]);
        }
        for (String comm : commandsToPrint) {
            Options opts = this.commands.get(comm);
            String s = LEFT_PADDING + this.cliName + " " + comm + " ";
            if (opts.getOptions().size() > 0) {
                pw.println(s + "<OPTIONS> " + this.commandsHelp.get(comm));
                formatter.printOptions(pw, 100, opts, s.length(), 3);
            } else {
                pw.println(s + this.commandsHelp.get(comm));
            }
            pw.println();
        }
        pw.flush();
    }

    static class OozieGnuParser
    extends GnuParser {
        private boolean ignoreMissingOption;

        public OozieGnuParser(boolean ignoreMissingOption) {
            this.ignoreMissingOption = ignoreMissingOption;
        }

        protected void checkRequiredOptions() throws MissingOptionException {
            if (!this.ignoreMissingOption) {
                super.checkRequiredOptions();
            }
        }
    }

    public class Command {
        private String name;
        private CommandLine commandLine;

        private Command(String name, CommandLine commandLine) {
            this.name = name;
            this.commandLine = commandLine;
        }

        public String getName() {
            return this.name;
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }
}

