/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.autoreload.config;

import com.alibaba.securitysdk.com.typesafe.config.Config;
import com.alibaba.securitysdk.com.typesafe.config.ConfigBeanFactory;
import com.aliyun.rapt.commons.autoreload.config.AutoReloadConfig;
import com.aliyun.rapt.commons.autoreload.config.Configs;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;

public class ConfigLoader {
    private static final Logger logger = SecurityLogManager.getLogger((String)"reload");
    private static AutoReloadConfig autoReloadConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoReloadConfig loadAutoReloadConfig() {
        if (autoReloadConfig != null) return autoReloadConfig;
        Class<ConfigLoader> clazz = ConfigLoader.class;
        synchronized (ConfigLoader.class) {
            if (autoReloadConfig != null) return autoReloadConfig;
            try {
                Config config = Configs.newBuilder(true).withResource(System.getProperty("auto-reload-resources", "reload")).build().getConfig("reload");
                autoReloadConfig = (AutoReloadConfig)ConfigBeanFactory.create((Config)config, AutoReloadConfig.class);
                logger.info("Loaded rasp configs:" + autoReloadConfig);
                // ** MonitorExit[var0] (shouldn't be in output)
                return autoReloadConfig;
            }
            catch (Exception ex) {
                autoReloadConfig = new AutoReloadConfig();
                logger.warn("Failed to load config from {} file, msg:{}", (Object)"reload", (Object)ex.getMessage());
            }
            return autoReloadConfig;
        }
    }

    public static void clear() {
        autoReloadConfig = null;
    }
}

