/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.autoreload.adaptor;

import com.aliyun.rapt.commons.autoreload.AbstractPolicyResourceReloadMonitor;
import com.aliyun.rapt.commons.autoreload.PolicyReloadedListener;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.IOUtils;
import com.aliyun.rapt.commons.utils.watchers.FileWatchEventListener;
import com.aliyun.rapt.commons.utils.watchers.FileWatchEventListenerAdapter;
import com.aliyun.rapt.commons.utils.watchers.FileWatcher;
import com.aliyun.rapt.commons.utils.watchers.FileWatcherHelper;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;

public class FilePolicyReloadMonitor
extends AbstractPolicyResourceReloadMonitor {
    private static final Logger logger = SecurityLogManager.getLogger((String)"reload");
    private final Path watchedPolicyFilePath;
    private final String dynamicPolicyWatchDirectoryPath;
    private FileWatcher watcher;

    public FilePolicyReloadMonitor(PolicyReloadedListener listener, Path watchedPolicyFilePath) {
        super(listener);
        this.watchedPolicyFilePath = watchedPolicyFilePath;
        this.dynamicPolicyWatchDirectoryPath = watchedPolicyFilePath.getParent().toString();
    }

    @Override
    protected void start0() throws Exception {
        this.watcher = new FileWatcher(Paths.get(this.dynamicPolicyWatchDirectoryPath, new String[0]), false, false, true, this.newThreadFactory("file"));
        this.watcher.registerListener((FileWatchEventListener)new DummyFileEventListener(this.listener, this.watchedPolicyFilePath));
        this.watcher.start();
    }

    @Override
    protected void destroy0() throws Exception {
        this.listener = null;
        this.watcher.stop();
    }

    static class DummyFileEventListener
    extends FileWatchEventListenerAdapter {
        private Path watchedPolicyFilePath;
        private PolicyReloadedListener listener;

        DummyFileEventListener(PolicyReloadedListener listener, Path watchedPolicyFilePath) {
            this.listener = listener;
            this.watchedPolicyFilePath = watchedPolicyFilePath;
        }

        public void onModifyEvent(WatchKey watchKey, WatchEvent event) {
            this.handler(watchKey, event);
        }

        public void onCreateEvent(WatchKey watchKey, WatchEvent event) {
            this.handler(watchKey, event);
        }

        private void handler(WatchKey watchKey, WatchEvent event) {
            try {
                Path path = FileWatcherHelper.resolvePath((WatchKey)watchKey, (WatchEvent)event);
                if (!Files.exists(this.watchedPolicyFilePath, new LinkOption[0]) || !Files.isSameFile(this.watchedPolicyFilePath, path)) {
                    return;
                }
            }
            catch (Exception ex) {
                logger.warn("Cannot resolve event to path.");
                logger.debug((Object)ex);
                return;
            }
            try {
                InputStream inputStream = Files.newInputStream(this.watchedPolicyFilePath, new OpenOption[0]);
                this.listener.reload(IOUtils.toString((InputStream)inputStream));
            }
            catch (IOException e) {
                logger.warn("Failed when loading resource from path: {}", (Object)this.watchedPolicyFilePath, (Object)e);
            }
        }
    }
}

