/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action;

import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action.AbstractPathAction;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action.DeletingVisitor;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action.PathSortByModificationTime;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.rolling.action.SortingVisitor;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.Configuration;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.StrSubstitutor;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

@Plugin(name="Delete", category="Core", printObject=true)
public class DeleteAction
extends AbstractPathAction {
    private final PathSorter pathSorter;
    private final boolean testMode;

    DeleteAction(String basePath, boolean followSymbolicLinks, int maxDepth, boolean testMode, PathSorter sorter, PathCondition[] pathConditions, StrSubstitutor subst) {
        super(basePath, followSymbolicLinks, maxDepth, pathConditions, subst);
        this.testMode = testMode;
        this.pathSorter = Objects.requireNonNull(sorter, "sorter");
        if (pathConditions == null || pathConditions.length == 0) {
            LOGGER.error("Missing Delete conditions: unconditional Delete not supported");
            throw new IllegalArgumentException("Unconditional Delete not supported");
        }
    }

    @Override
    public boolean execute() throws IOException {
        return super.execute();
    }

    private void deleteSelectedFiles(List<PathWithAttributes> selectedForDeletion) throws IOException {
        this.trace("Paths the script selected for deletion:", selectedForDeletion);
        for (PathWithAttributes pathWithAttributes : selectedForDeletion) {
            Path path;
            Path path2 = path = pathWithAttributes == null ? null : pathWithAttributes.getPath();
            if (this.isTestMode()) {
                LOGGER.info("Deleting {} (TEST MODE: file not actually deleted)", (Object)path);
                continue;
            }
            this.delete(path);
        }
    }

    protected void delete(Path path) throws IOException {
        LOGGER.trace("Deleting {}", (Object)path);
        Files.deleteIfExists(path);
    }

    @Override
    public boolean execute(FileVisitor<Path> visitor) throws IOException {
        List<PathWithAttributes> sortedPaths = this.getSortedPaths();
        this.trace("Sorted paths:", sortedPaths);
        for (PathWithAttributes element : sortedPaths) {
            try {
                visitor.visitFile(element.getPath(), element.getAttributes());
            }
            catch (IOException ioex) {
                LOGGER.error("Error in post-rollover Delete when visiting {}", (Object)element.getPath(), (Object)ioex);
                visitor.visitFileFailed(element.getPath(), ioex);
            }
        }
        return true;
    }

    private void trace(String label, List<PathWithAttributes> sortedPaths) {
        LOGGER.trace(label);
        for (PathWithAttributes pathWithAttributes : sortedPaths) {
            LOGGER.trace(pathWithAttributes);
        }
    }

    List<PathWithAttributes> getSortedPaths() throws IOException {
        SortingVisitor sort = new SortingVisitor(this.pathSorter);
        super.execute(sort);
        List<PathWithAttributes> sortedPaths = sort.getSortedPaths();
        return sortedPaths;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    @Override
    protected FileVisitor<Path> createFileVisitor(Path visitorBaseDir, List<PathCondition> conditions) {
        return new DeletingVisitor(visitorBaseDir, conditions, this.testMode);
    }

    @PluginFactory
    public static DeleteAction createDeleteAction(@PluginAttribute(value="basePath") String basePath, @PluginAttribute(value="followLinks") boolean followLinks, @PluginAttribute(value="maxDepth", defaultInt=1) int maxDepth, @PluginAttribute(value="testMode") boolean testMode, @PluginElement(value="PathSorter") PathSorter sorterParameter, @PluginElement(value="PathConditions") PathCondition[] pathConditions, @PluginConfiguration Configuration config) {
        PathSorter sorter = sorterParameter == null ? new PathSortByModificationTime(true) : sorterParameter;
        return new DeleteAction(basePath, followLinks, maxDepth, testMode, sorter, pathConditions, config.getStrSubstitutor());
    }
}

