/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.appender;

import com.aliyun.security.shade.org.apache.logging.log4j.core.Layout;
import com.aliyun.security.shade.org.apache.logging.log4j.core.LoggerContext;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.AbstractManager;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.AppenderLoggingException;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.ConfigurationFactoryData;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.aliyun.security.shade.org.apache.logging.log4j.core.appender.OutputStreamManager;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.Configuration;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.FileUtils;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.NullOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class RandomAccessFileManager
extends OutputStreamManager {
    static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RandomAccessFileManagerFactory FACTORY = new RandomAccessFileManagerFactory();
    private final RandomAccessFile randomAccessFile;
    private final ThreadLocal<Boolean> isEndOfBatch = new ThreadLocal();

    protected RandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile file, String fileName, OutputStream os, int bufferSize, Layout<? extends Serializable> layout, boolean writeHeader) {
        super(loggerContext, os, fileName, false, layout, writeHeader, ByteBuffer.wrap(new byte[bufferSize]));
        this.randomAccessFile = file;
        this.isEndOfBatch.set(Boolean.FALSE);
    }

    public static RandomAccessFileManager getFileManager(String fileName, boolean append, boolean immediateFlush, int bufferSize, Layout<? extends Serializable> layout, Configuration configuration) {
        return RandomAccessFileManager.narrow(RandomAccessFileManager.class, RandomAccessFileManager.getManager(fileName, new FactoryData(append, immediateFlush, bufferSize, layout, configuration), FACTORY));
    }

    public Boolean isEndOfBatch() {
        return this.isEndOfBatch.get();
    }

    public void setEndOfBatch(boolean endOfBatch) {
        this.isEndOfBatch.set(endOfBatch);
    }

    @Override
    protected void writeToDestination(byte[] bytes, int offset, int length) {
        try {
            this.randomAccessFile.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException(msg, ex);
        }
    }

    @Override
    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
    }

    @Override
    public synchronized boolean closeOutputStream() {
        this.flush();
        try {
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException ex) {
            this.logError("Unable to close RandomAccessFile", ex);
            return false;
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        return result;
    }

    private static class RandomAccessFileManagerFactory
    implements ManagerFactory<RandomAccessFileManager, FactoryData> {
        private RandomAccessFileManagerFactory() {
        }

        @Override
        public RandomAccessFileManager createManager(String name, FactoryData data) {
            File file = new File(name);
            if (!data.append) {
                file.delete();
            }
            boolean writeHeader = !data.append || !file.exists();
            NullOutputStream os = NullOutputStream.getInstance();
            try {
                FileUtils.makeParentDirs(file);
                RandomAccessFile raf = new RandomAccessFile(name, "rw");
                if (data.append) {
                    raf.seek(raf.length());
                } else {
                    raf.setLength(0L);
                }
                return new RandomAccessFileManager(data.getLoggerContext(), raf, name, os, data.bufferSize, data.layout, writeHeader);
            }
            catch (Exception ex) {
                AbstractManager.LOGGER.error("RandomAccessFileManager (" + name + ") " + ex, (Throwable)ex);
                return null;
            }
        }
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final boolean append;
        private final boolean immediateFlush;
        private final int bufferSize;
        private final Layout<? extends Serializable> layout;

        public FactoryData(boolean append, boolean immediateFlush, int bufferSize, Layout<? extends Serializable> layout, Configuration configuration) {
            super(configuration);
            this.append = append;
            this.immediateFlush = immediateFlush;
            this.bufferSize = bufferSize;
            this.layout = layout;
        }
    }
}

