/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.logger.layouts;

import com.aliyun.security.com.google.gson.Gson;
import com.aliyun.security.com.google.gson.GsonBuilder;
import com.aliyun.security.com.google.gson.JsonArray;
import com.aliyun.security.com.google.gson.JsonObject;
import com.aliyun.security.shade.org.apache.logging.log4j.core.LogEvent;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.Configuration;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.aliyun.security.shade.org.apache.logging.log4j.core.impl.ThrowableProxy;
import com.aliyun.security.shade.org.apache.logging.log4j.core.layout.AbstractStringLayout;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.Interpolator;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.MapLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.NameAbbreviator;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.KeyValuePair;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;

@Plugin(name="GsonLayout", category="Core", elementType="layout", printObject=true)
public class GsonLayout
extends AbstractStringLayout {
    private static final int DEFAULT_MAX_STACK_SIZE = 20;
    private final String stacktraceKey = "stack-trace";
    private final String loggerKey = "logger";
    private final Gson gson;
    private final int maxStackSize;
    private final NameAbbreviator loggerPatternConverter;
    private final boolean stackTraceAsJson;
    private final KeyValuePair[] additionalFields;
    private final Interpolator interpolator;

    @PluginFactory
    public static GsonLayout create(@PluginConfiguration Configuration config, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="pretty", defaultBoolean=false) boolean pretty, @PluginAttribute(value="json-stacktrace", defaultBoolean=false) boolean jsonStacktrace, @PluginAttribute(value="max-stack-size", defaultInt=20) int maxStackSize, @PluginAttribute(value="logger-pattern") String defaultLoggerPattern, @PluginElement(value="AdditionalField") KeyValuePair[] additionalFields) {
        return new GsonLayout(config, charset, pretty, jsonStacktrace, maxStackSize, defaultLoggerPattern, additionalFields);
    }

    protected GsonLayout(Configuration configuration, Charset charset, boolean pretty, boolean stackTraceAsJson, int maxStackSize, String loggerPattern, KeyValuePair[] additionalFields) {
        super(configuration, charset, null, null);
        this.gson = pretty ? new GsonBuilder().setPrettyPrinting().create() : new Gson();
        this.maxStackSize = maxStackSize > 0 ? maxStackSize : 20;
        this.loggerPatternConverter = loggerPattern == null || loggerPattern.isEmpty() ? null : NameAbbreviator.getAbbreviator(loggerPattern);
        this.stackTraceAsJson = stackTraceAsJson;
        this.additionalFields = additionalFields;
        this.interpolator = new Interpolator(new MapLookup(this.getConfiguration().getProperties()), this.getConfiguration().getPluginPackages());
    }

    @Override
    public String toSerializable(LogEvent e) {
        JsonObject root = new JsonObject();
        root.addProperty("@timestamp", e.getTimeMillis());
        root.addProperty("thread", e.getThreadName());
        root.addProperty("level", e.getLevel().toString());
        if (this.loggerPatternConverter == null) {
            root.addProperty("logger", e.getLoggerName());
        } else {
            KeyValuePair[] b = new StringBuilder();
            this.loggerPatternConverter.abbreviate(e.getLoggerName(), (StringBuilder)b);
            root.addProperty("logger", b.toString());
        }
        for (KeyValuePair kv : this.additionalFields) {
            String rendered = this.interpolator.lookup(e, kv.getValue());
            root.addProperty(kv.getKey(), rendered == null ? kv.getValue() : rendered);
        }
        Map<String, String> map = e.getContextData().toMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            root.addProperty(entry.getKey(), entry.getValue());
        }
        root.addProperty("message", e.getMessage().getFormattedMessage());
        ThrowableProxy proxy = e.getThrownProxy();
        if (proxy != null) {
            if (this.stackTraceAsJson) {
                root.add("stack-trace", this.stackTraceAsJson(proxy));
            } else {
                root.addProperty("stack-trace", this.stackTraceAsString(proxy));
            }
        }
        return this.gson.toJson(root) + "\n";
    }

    private String stackTraceAsString(ThrowableProxy proxy) {
        StringWriter sw = new StringWriter();
        proxy.getThrowable().printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private JsonArray stackTraceAsJson(ThrowableProxy proxy) {
        JsonArray stack = new JsonArray();
        for (int count = 0; proxy != null && count < this.maxStackSize; proxy = proxy.getCauseProxy(), ++count) {
            JsonObject element = new JsonObject();
            String head = count > 0 ? "caused by" : "exception";
            element.addProperty(head, proxy.getThrowable().getClass().getName());
            if (proxy.getMessage() != null) {
                element.addProperty("message", proxy.getMessage());
            }
            JsonArray frames = new JsonArray();
            for (StackTraceElement frame : proxy.getStackTrace()) {
                frames.add("at " + frame.toString());
            }
            if (frames.size() != 0) {
                element.add("frames", frames);
            }
            stack.add(element);
        }
        return stack;
    }
}

