/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.pattern;

import com.aliyun.security.shade.org.apache.logging.log4j.core.LogEvent;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.aliyun.security.shade.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.UuidUtil;
import java.util.UUID;

@Plugin(name="UuidPatternConverter", category="Converter")
@ConverterKeys(value={"u", "uuid"})
public final class UuidPatternConverter
extends LogEventPatternConverter {
    private final boolean isRandom;

    private UuidPatternConverter(boolean isRandom) {
        super("u", "uuid");
        this.isRandom = isRandom;
    }

    public static UuidPatternConverter newInstance(String[] options) {
        if (options.length == 0) {
            return new UuidPatternConverter(false);
        }
        if (options.length > 1 || !options[0].equalsIgnoreCase("RANDOM") && !options[0].equalsIgnoreCase("Time")) {
            LOGGER.error("UUID Pattern Converter only accepts a single option with the value \"RANDOM\" or \"TIME\"");
        }
        return new UuidPatternConverter(options[0].equalsIgnoreCase("RANDOM"));
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        UUID uuid = this.isRandom ? UUID.randomUUID() : UuidUtil.getTimeBasedUuid();
        toAppendTo.append(uuid.toString());
    }
}

