/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.com.lmax.disruptor;

import com.aliyun.security.com.lmax.disruptor.AlertException;
import com.aliyun.security.com.lmax.disruptor.Sequence;
import com.aliyun.security.com.lmax.disruptor.SequenceBarrier;
import com.aliyun.security.com.lmax.disruptor.WaitStrategy;

public final class YieldingWaitStrategy
implements WaitStrategy {
    private static final int SPIN_TRIES = 100;

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        int counter = 100;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            counter = this.applyWaitMethod(barrier, counter);
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(SequenceBarrier barrier, int counter) throws AlertException {
        barrier.checkAlert();
        if (0 == counter) {
            Thread.yield();
        } else {
            --counter;
        }
        return counter;
    }
}

