/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.emr.module;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.objects.Package;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksDolphinSchedulerTransformer;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.DataworksMxConverter;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.metrics.enums.CollectorType;
import com.workflow.migration.transform.dw.converter.emr.convert.EmrWorkflowConvertFactory;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMRWorkflow2DwConverter
extends DataworksMxConverter {
    private static final Logger log = LoggerFactory.getLogger(EMRWorkflow2DwConverter.class);

    public AbstractConvertFactory getConvertFactory() {
        return new EmrWorkflowConvertFactory();
    }

    protected WorkflowNode getCustomWorkflowNode(WorkflowNode originNode) {
        String originScript = originNode.getOriginScript();
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setWorkflowName(originNode.getWorkflowName());
        workflowNode.setWorkflowId(originNode.getWorkflowId());
        workflowNode.setNodeName(originNode.getNodeName());
        TaskDefinition taskDefinition = (TaskDefinition)BwmJsonUtil.parseObject((String)originScript, TaskDefinition.class);
        if (Objects.nonNull(taskDefinition)) {
            workflowNode.setNodeType(taskDefinition.getTaskType());
            workflowNode.setScript(taskDefinition.getTaskParams());
            workflowNode.setPriority(Integer.valueOf(taskDefinition.getTaskGroupPriority()));
        }
        return originNode;
    }

    public Converter init(TaskContext taskContext) throws IOException {
        super.init(taskContext);
        TransformerContext.init((CollectorType)CollectorType.DolphinScheduler);
        return this;
    }

    protected DataWorksDolphinSchedulerTransformer createTransformer(File config, Package from, Package to) {
        DolphinSchedulerPackage dolphinSchedulerPackage = (DolphinSchedulerPackage)from;
        DataWorksPackage dataWorksPackage = (DataWorksPackage)to;
        DataWorksTransformerConfig dataWorksTransformerConfig = new DataWorksTransformerConfig();
        try {
            String mxConfigStr = FileUtils.readFileToString((File)config, (String)"UTF-8");
            dataWorksTransformerConfig = (DataWorksTransformerConfig)JSONObject.parseObject((String)mxConfigStr, DataWorksTransformerConfig.class);
        }
        catch (Exception e) {
            log.error("createTransformer error", (Throwable)e);
        }
        return new DataWorksDolphinSchedulerTransformer(dataWorksTransformerConfig, dolphinSchedulerPackage, dataWorksPackage);
    }

    public DataWorksPackage convertUseMxTransform(String mxConfigFilePath, String sourceFilePath, String targetFilePath) {
        if (StringUtils.isBlank((String)sourceFilePath) || StringUtils.isBlank((String)targetFilePath)) {
            log.error("sourceFilePath and targetFilePath can not be null");
            return new DataWorksPackage();
        }
        DolphinSchedulerPackage fromPackage = new DolphinSchedulerPackage();
        fromPackage.setPackageFile(new File(sourceFilePath));
        DataWorksPackage toPackage = new DataWorksPackage();
        toPackage.setPackageFile(new File(targetFilePath));
        DataWorksDolphinSchedulerTransformer transformer = this.createTransformer(new File(mxConfigFilePath), (Package)fromPackage, (Package)toPackage);
        transformer.init();
        transformer.load();
        transformer.transform();
        return (DataWorksPackage)transformer.getTargetPackage();
    }

    public void close() {
        super.close();
        TransformerContext.clear();
    }
}

