/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.oss;

import com.aliyun.migration.teleport.cloud.entity.SinkProperties;
import com.aliyun.migration.teleport.cloud.entity.TeleportOssAccountVO;
import com.aliyun.migration.teleport.cloud.enums.CloudAccessType;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class OssClient {
    private static final Logger log = LoggerFactory.getLogger(OssClient.class);
    private final OSS oss;
    private final String bucket;
    public static final int DEFAULT_UPLOAD_EXPIRE_MINUTES = 5;
    public static final int DEFAULT_DOWNLOAD_EXPIRE_MINUTES = 720;
    public static final int DEFAULT_UPLOAD_MAX_SIZE_MB = 100;
    public static final int DEFAULT_UPLOAD_BUFFER_SIZE = 1000;
    private final SinkProperties properties;

    public OssClient(SinkProperties properties) {
        properties.decrypt();
        if (properties.getLoginType() == null) {
            properties.setLoginType(CloudAccessType.STS);
        }
        this.bucket = properties.getBucket();
        this.properties = properties;
        this.oss = this.init(properties);
    }

    private OSS init(SinkProperties prop) {
        switch (prop.getLoginType()) {
            case AK: {
                return new OSSClientBuilder().build(prop.getEndpoint(), prop.getAccessKeyId(), prop.getAccessKeySecret());
            }
            case STS: {
                return new OSSClientBuilder().build(prop.getEndpoint(), prop.getAccessKeyId(), prop.getAccessKeySecret(), prop.getSecurityToken());
            }
        }
        throw new TeleportException(TeleportStatusCode.OSS_CLIENT_ERROR);
    }

    public void close() {
        if (this.oss != null) {
            this.oss.shutdown();
        }
    }

    private String formatMessageInfo(String action, String objectName, String uid, String message) {
        return String.format("[OSS] - %s %s:%s: %s", uid, action, objectName, message);
    }

    public void simpleUploadObject(String objectName, String content, String uid) {
        this.simpleUploadObject(objectName, content, Map.of(), uid);
    }

    public void simpleUploadObject(String objectName, String content, Map<String, String> userMeta, String uid) {
        log.info(this.formatMessageInfo("PutObject", objectName, uid, "start"));
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, objectName, (InputStream)new ByteArrayInputStream(content.getBytes()));
        if (!CollectionUtils.isEmpty(userMeta)) {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setUserMetadata(userMeta);
            putObjectRequest.setMetadata(metadata);
        }
        PutObjectResult result = this.oss.putObject(putObjectRequest);
        log.info(this.formatMessageInfo("PutObject", objectName, uid, "crc=" + result.getServerCRC()));
    }

    public void simpleUploadList(String objectName, List<String> contents, String uid) {
        log.info(this.formatMessageInfo("AppendObject", objectName, uid, "start"));
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("text/plain");
        long position = 0L;
        AppendObjectRequest appendObjectRequest = new AppendObjectRequest(this.bucket, objectName, (InputStream)new ByteArrayInputStream("".getBytes()), metadata);
        for (String content : contents) {
            appendObjectRequest.setPosition(Long.valueOf(position));
            appendObjectRequest.setInputStream((InputStream)new ByteArrayInputStream(content.getBytes()));
            AppendObjectResult appendObjectResult = this.oss.appendObject(appendObjectRequest);
            position = appendObjectResult.getNextPosition();
        }
        log.info(this.formatMessageInfo("AppendObject", objectName, uid, "success"));
    }

    public void uploadIterator(String objectName, Iterator<String> iterator, String uid) {
        log.info(this.formatMessageInfo("AppendObject", objectName, uid, "start"));
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("text/plain");
        long position = 0L;
        AppendObjectRequest appendObjectRequest = new AppendObjectRequest(this.bucket, objectName, (InputStream)new ByteArrayInputStream("".getBytes()), metadata);
        while (iterator.hasNext()) {
            String content = iterator.next();
            appendObjectRequest.setPosition(Long.valueOf(position));
            appendObjectRequest.setInputStream((InputStream)new ByteArrayInputStream(content.getBytes()));
            AppendObjectResult appendObjectResult = this.oss.appendObject(appendObjectRequest);
            position = appendObjectResult.getNextPosition();
        }
        log.info(this.formatMessageInfo("AppendObject", objectName, uid, "success"));
    }

    public void uploadMultiPartFile(String objectName, String filePath, String uid) {
        log.info(this.formatMessageInfo("MultipartUpload", objectName, uid, "start"));
        File sampleFile = new File(filePath);
        long fileLength = sampleFile.length();
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucket, objectName);
        ObjectMetadata metadata = new ObjectMetadata();
        if (metadata.getContentType() == null) {
            metadata.setContentType(Mimetypes.getInstance().getMimetype(new File(filePath), objectName));
        }
        request.setObjectMetadata(metadata);
        InitiateMultipartUploadResult uploadResult = this.oss.initiateMultipartUpload(request);
        String uploadId = uploadResult.getUploadId();
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        long partSize = 0x6400000L;
        int partCount = (int)(fileLength / 0x6400000L);
        if (fileLength % 0x6400000L != 0L) {
            ++partCount;
        }
        try {
            for (int i = 0; i < partCount; ++i) {
                long startPos = (long)i * 0x6400000L;
                long curPartSize = i + 1 == partCount ? fileLength - startPos : 0x6400000L;
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(this.bucket);
                uploadPartRequest.setKey(objectName);
                uploadPartRequest.setUploadId(uploadId);
                FileInputStream inputStream = new FileInputStream(sampleFile);
                ((InputStream)inputStream).skip(startPos);
                uploadPartRequest.setInputStream((InputStream)inputStream);
                uploadPartRequest.setPartSize(curPartSize);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = this.oss.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException e) {
            throw new TeleportException(TeleportStatusCode.OSS_REQUEST_ERROR, this.formatMessageInfo("MultipartUpload", objectName, uid, "File upload failed"));
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucket, objectName, uploadId, partETags);
        CompleteMultipartUploadResult completeMultipartUploadResult = this.oss.completeMultipartUpload(completeMultipartUploadRequest);
        log.info(this.formatMessageInfo("MultipartUpload", objectName, uid, "success"));
    }

    public void simpleUploadStream(String objectName, InputStream inputStream, String uid) {
        log.info(this.formatMessageInfo("PutObject", objectName, uid, "start stream upload"));
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int len = 0;
            byte[] buf = new byte[2048];
            while ((len = bufferedInputStream.read(buf)) != -1) {
                byteArrayOutputStream.write(buf, 0, len);
            }
            byteArrayOutputStream.flush();
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, objectName, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ObjectMetadata metadata = new ObjectMetadata();
            putObjectRequest.setMetadata(metadata);
            this.oss.putObject(putObjectRequest);
            log.info(this.formatMessageInfo("PutObject", objectName, uid, "success"));
        }
        catch (IOException e) {
            throw new TeleportException(TeleportStatusCode.OSS_REQUEST_ERROR, (Throwable)e);
        }
    }

    public void simpleUploadStream(String objectName, ByteArrayOutputStream byteArrayOutputStream, String uid) {
        log.info(this.formatMessageInfo("PutObject", objectName, uid, "start output stream upload"));
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, objectName, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        ObjectMetadata metadata = new ObjectMetadata();
        putObjectRequest.setMetadata(metadata);
        this.oss.putObject(putObjectRequest);
        log.info(this.formatMessageInfo("PutObject", objectName, uid, "success"));
    }

    public void simpleUploadFile(String objectName, String filepath, String uid) {
        log.info(this.formatMessageInfo("PutObject", objectName, uid, "start file upload"));
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, objectName, new File(filepath));
        ObjectMetadata metadata = new ObjectMetadata();
        putObjectRequest.setMetadata(metadata);
        this.oss.putObject(putObjectRequest);
        log.info(this.formatMessageInfo("PutObject", objectName, uid, "success"));
    }

    public ObjectMetadata simpleDownloadFile(String objectName, String filename, String uid) {
        log.info(this.formatMessageInfo("GetObject", objectName, uid, objectName));
        return this.oss.getObject(new GetObjectRequest(this.bucket, objectName), new File(filename));
    }

    public String simpleReadText(String objectName, String uid) throws IOException {
        log.info(this.formatMessageInfo("GetObject", objectName, uid, "simpleReadText"));
        String content = "";
        if (objectName.endsWith("/")) {
            log.warn("[OSS] object:{} is a directory, skip read", (Object)objectName);
            return content;
        }
        try (OSSObject ossObject = this.oss.getObject(this.bucket, objectName);
             InputStream inputStream = ossObject.getObjectContent();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] readBuffer = new byte[1024];
            while ((bytesRead = inputStream.read(readBuffer)) != -1) {
                byteArrayOutputStream.write(readBuffer, 0, bytesRead);
            }
            content = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
        }
        return content;
    }

    public void simpleReadline(String objectName, Consumer<String> consumer, String uid) {
        if (!this.isFileExists(objectName, uid)) {
            log.warn(this.formatMessageInfo("GetObject", objectName, uid, "\u6587\u4ef6\u4e0d\u5b58\u5728:" + objectName));
            return;
        }
        try (OSSObject ossObject = this.oss.getObject(this.bucket, objectName);
             InputStream inputStream = ossObject.getObjectContent();
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                consumer.accept(line);
            }
        }
        catch (IOException e) {
            throw new TeleportException(TeleportStatusCode.OSS_REQUEST_ERROR, this.formatMessageInfo("GetObject", objectName, uid, "Error consuming file:" + objectName));
        }
    }

    public MultipartFile convertToMultipartFile(String objectName, String filename, String uid) {
        this.simpleDownloadFile(objectName, filename, uid);
        File file = new File(filename);
        try {
            MockMultipartFile cmdFile = new MockMultipartFile(file.getName(), file.getName(), null, (InputStream)new FileInputStream(file));
            file.delete();
            return cmdFile;
        }
        catch (Exception e) {
            throw new TeleportException(TeleportStatusCode.OSS_REQUEST_ERROR, this.formatMessageInfo("ConvertToMultipartFile", objectName, uid, "File conversion error"));
        }
    }

    public void deleteFile(String objectName, String uid) {
        this.oss.deleteObject(this.bucket, objectName);
    }

    public void deleteMultiFiles(List<String> objectList, String uid) throws UnsupportedEncodingException {
        log.info(this.formatMessageInfo("DeleteObjects", String.join((CharSequence)",", objectList), uid, "start delete multi objs"));
        DeleteObjectsResult deleteObjectsResult = this.oss.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(objectList).withEncodingType("url"));
        List deletedObjects = deleteObjectsResult.getDeletedObjects();
        for (String obj : deletedObjects) {
            String deleteObj = URLDecoder.decode(obj, StandardCharsets.UTF_8);
            log.info(this.formatMessageInfo("DeleteObjects", String.join((CharSequence)",", objectList), uid, "result=" + deleteObj));
        }
    }

    public void deleteDirectory(String prefix, String uid) throws UnsupportedEncodingException {
        this.listObjectNames(prefix, list -> {
            List<String> keys = list.stream().map(OSSObjectSummary::getKey).toList();
            try {
                this.deleteMultiFiles(keys, uid);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }, uid);
    }

    public List<String> listObjectNames(String prefix, String uid) throws UnsupportedEncodingException {
        ArrayList<String> objNames = new ArrayList<String>();
        this.listObjectNames(prefix, list -> {
            for (OSSObjectSummary ossObjectSummary : list) {
                objNames.add(ossObjectSummary.getKey());
            }
        }, uid);
        return objNames;
    }

    public void listObjectNames(String prefix, Consumer<List<OSSObjectSummary>> consumer, String uid) throws UnsupportedEncodingException {
        log.info(this.formatMessageInfo("ListObjects", prefix, uid, ""));
        String nextMarker = null;
        ObjectListing objectListing = null;
        do {
            ListObjectsRequest listObjectsRequest;
            if (!(objectListing = this.oss.listObjects(listObjectsRequest = new ListObjectsRequest(this.bucket).withPrefix(prefix).withMarker(nextMarker))).getObjectSummaries().isEmpty()) {
                consumer.accept(objectListing.getObjectSummaries());
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
    }

    public boolean isFileExists(String objectName, String uid) {
        return this.oss.doesObjectExist(this.bucket, objectName);
    }

    public String getDownloadUrl(String objectName, boolean toPublic) {
        Date expiration = new Date(new Date().getTime() + 43200000L);
        URL url = this.oss.generatePresignedUrl(this.bucket, objectName, expiration);
        String urlString = url.toString();
        if (toPublic) {
            return this.toPublicUrl(urlString);
        }
        return this.toPrivateUrl(urlString);
    }

    private String toPublicUrl(String url) {
        if (!url.contains("-internal")) {
            return url;
        }
        return url.replace("-internal", "");
    }

    private String toPrivateUrl(String url) {
        if (url.contains("-internal")) {
            return url;
        }
        String regex = "oss-([a-z0-9\\-]+)\\.aliyuncs\\.com";
        return url.replaceAll(regex, "oss-$1-internal.aliyuncs.com");
    }

    public TeleportOssAccountVO getPostObjectPolicy(String dir) {
        TeleportOssAccountVO vo = new TeleportOssAccountVO();
        try {
            long expireEndTime = System.currentTimeMillis() + 300000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConditions = new PolicyConditions();
            policyConditions.addConditionItem("content-length-range", 0L, 0x6400000L);
            policyConditions.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = this.oss.generatePostPolicy(expiration, policyConditions);
            byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = this.oss.calculatePostSignature(postPolicy);
            vo.setAk(this.properties.getAccessKeyId());
            vo.setEndpoint(this.toPublicUrl(this.properties.getEndpoint()));
            vo.setBucket(this.bucket);
            vo.setPolicy(encodedPolicy);
            vo.setSignature(postSignature);
            vo.setExpire(expireEndTime / 1000L);
            vo.setDir(dir);
        }
        catch (Exception e) {
            log.error("getPostObjectInfo error:", (Throwable)e);
        }
        return vo;
    }

    public void setObjectTagging(String objectName, Map<String, String> tags) {
        log.info(this.formatMessageInfo("PutObjectTagging", objectName, "", "start"));
        try {
            HashMap<String, String> tagsCopy = new HashMap<String, String>(tags);
            this.oss.setObjectTagging(this.bucket, objectName, tagsCopy);
            log.info(this.formatMessageInfo("PutObjectTagging", objectName, "", "success"));
        }
        catch (Exception e) {
            log.error(this.formatMessageInfo("PutObjectTagging", objectName, "", "failed"), (Throwable)e);
            throw new TeleportException(TeleportStatusCode.OSS_REQUEST_ERROR, (Throwable)e);
        }
    }

    public Map<String, String> getObjectTagging(String objectName, String uid) {
        log.info(this.formatMessageInfo("GetObjectTagging", objectName, uid, "start"));
        try {
            TagSet tagSet = this.oss.getObjectTagging(this.bucket, objectName);
            Map tags = tagSet.getAllTags();
            log.info(this.formatMessageInfo("GetObjectTagging", objectName, uid, "success"));
            return tags;
        }
        catch (Exception e) {
            log.error(this.formatMessageInfo("GetObjectTagging", objectName, uid, "failed"), (Throwable)e);
            throw new TeleportException(TeleportStatusCode.OSS_REQUEST_ERROR, (Throwable)e);
        }
    }

    public void setSingleObjectTag(String objectName, String tagKey, String tagValue) {
        this.setObjectTagging(objectName, Map.of(tagKey, tagValue));
    }

    public String getSingleObjectTag(String objectName, String tagKey, String uid) {
        Map<String, String> tags = this.getObjectTagging(objectName, uid);
        return tags.get(tagKey);
    }
}

