/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.dataworks;

import com.aliyun.dataworks_public20240518.Client;
import com.aliyun.dataworks_public20240518.models.CreateDeploymentRequest;
import com.aliyun.dataworks_public20240518.models.CreateDeploymentResponse;
import com.aliyun.dataworks_public20240518.models.CreateDeploymentResponseBody;
import com.aliyun.dataworks_public20240518.models.CreateNodeRequest;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponse;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.DeleteNodeRequest;
import com.aliyun.dataworks_public20240518.models.DeleteNodeResponse;
import com.aliyun.dataworks_public20240518.models.DeleteNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.ExecDeploymentStageRequest;
import com.aliyun.dataworks_public20240518.models.ExecDeploymentStageResponse;
import com.aliyun.dataworks_public20240518.models.ExecDeploymentStageResponseBody;
import com.aliyun.dataworks_public20240518.models.ExecuteAdhocWorkflowInstanceRequest;
import com.aliyun.dataworks_public20240518.models.ExecuteAdhocWorkflowInstanceResponse;
import com.aliyun.dataworks_public20240518.models.ExecuteAdhocWorkflowInstanceResponseBody;
import com.aliyun.dataworks_public20240518.models.GetDeploymentRequest;
import com.aliyun.dataworks_public20240518.models.GetDeploymentResponse;
import com.aliyun.dataworks_public20240518.models.GetDeploymentResponseBody;
import com.aliyun.dataworks_public20240518.models.GetNodeRequest;
import com.aliyun.dataworks_public20240518.models.GetNodeResponse;
import com.aliyun.dataworks_public20240518.models.GetNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.GetProjectRequest;
import com.aliyun.dataworks_public20240518.models.GetProjectResponse;
import com.aliyun.dataworks_public20240518.models.GetProjectResponseBody;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogRequest;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogResponse;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogResponseBody;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceRequest;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceResponse;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceResponseBody;
import com.aliyun.dataworks_public20240518.models.GetTaskRequest;
import com.aliyun.dataworks_public20240518.models.GetTaskResponse;
import com.aliyun.dataworks_public20240518.models.GetTaskResponseBody;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesRequest;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesResponse;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesResponseBody;
import com.aliyun.dataworks_public20240518.models.ListTasksRequest;
import com.aliyun.dataworks_public20240518.models.ListTasksResponse;
import com.aliyun.dataworks_public20240518.models.ListTasksResponseBody;
import com.aliyun.dataworks_public20240518.models.StopWorkflowInstancesRequest;
import com.aliyun.dataworks_public20240518.models.StopWorkflowInstancesResponse;
import com.aliyun.dataworks_public20240518.models.StopWorkflowInstancesResponseBody;
import com.aliyun.dataworks_public20240518.models.SuccessInfoValue;
import com.aliyun.migration.teleport.cloud.entity.BrokerProperties;
import com.aliyun.migration.teleport.cloud.entity.DataWorksAdhocTask;
import com.aliyun.migration.teleport.cloud.enums.CloudAccessType;
import com.aliyun.migration.teleport.cloud.enums.TaskNodeType;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DataWorksClient {
    private static final Logger log = LoggerFactory.getLogger(DataWorksClient.class);
    private final Client client;
    public static final String MANUAL_TASK = "DataworksManualTask";
    public static final String MANUAL_TRIGGER_TYPE = "Manual";
    public static final String DEFAULT_CU = "1";

    public DataWorksClient(BrokerProperties properties) {
        try {
            String endpoint = properties.getEndpoint();
            if (!StringUtils.hasText((String)endpoint)) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_CLIENT_ERROR, "DataWorks endpoint is empty");
            }
            Config config = new Config().setAccessKeyId(properties.getAccessKeyId()).setAccessKeySecret(properties.getAccessKeySecret()).setEndpoint(properties.getEndpoint());
            if (properties.getLoginType() == CloudAccessType.STS) {
                config.setSecurityToken(properties.getSecurityToken());
            }
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_CLIENT_ERROR);
        }
    }

    public Long createNode(Long projectId, String nodeSpec) {
        CreateNodeRequest createNodeRequest = new CreateNodeRequest().setProjectId(projectId).setScene(MANUAL_TASK).setSpec(nodeSpec);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            CreateNodeResponse response = this.client.createNodeWithOptions(createNodeRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "CreateNode");
            }
            CreateNodeResponseBody body = response.getBody();
            log.info("[DataWorks] CreateNodeResponseBody:{}", (Object)body);
            return body.getId();
        }
        catch (Exception error) {
            log.error("[DataWorks] CreateNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public String createDeployment(Long projectId, Long nodeId) {
        CreateDeploymentRequest createDeploymentRequest = new CreateDeploymentRequest().setObjectIds(List.of(String.valueOf(nodeId))).setType("Online").setProjectId(projectId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            CreateDeploymentResponse response = this.client.createDeploymentWithOptions(createDeploymentRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "CreateDeployment");
            }
            CreateDeploymentResponseBody body = response.getBody();
            log.info("[DataWorks] CreateDeployment: deployID={}", (Object)body);
            return body.getId();
        }
        catch (Exception error) {
            log.error("[DataWorks] CreateDeployment", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetDeploymentResponseBody.GetDeploymentResponseBodyPipeline getDeployment(Long projectId, String deployId) {
        GetDeploymentRequest getDeploymentRequest = new GetDeploymentRequest().setProjectId(projectId).setId(deployId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetDeploymentResponse response = this.client.getDeploymentWithOptions(getDeploymentRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "GetDeployment");
            }
            GetDeploymentResponseBody body = response.getBody();
            return body.getPipeline();
        }
        catch (Exception error) {
            log.error("[DataWorks] CreateDeployment", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public Boolean execDeploymentStage(Long projectId, String deployId, String stage) {
        ExecDeploymentStageRequest execDeploymentStageRequest = new ExecDeploymentStageRequest().setProjectId(projectId).setId(deployId).setCode(stage);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ExecDeploymentStageResponse response = this.client.execDeploymentStageWithOptions(execDeploymentStageRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "ExecDeploymentStage");
            }
            ExecDeploymentStageResponseBody body = response.getBody();
            log.info("[DataWorks] ExecDeploymentStage");
            return body.getSuccess();
        }
        catch (Exception error) {
            log.error("[DataWorks] ExecDeploymentStage", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetNodeResponseBody.GetNodeResponseBodyNode getNode(Long projectId, Long nodeId) {
        GetNodeRequest getNodeRequest = new GetNodeRequest().setProjectId(projectId).setId(nodeId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetNodeResponse response = this.client.getNodeWithOptions(getNodeRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "GetNodeRequest");
            }
            GetNodeResponseBody body = response.getBody();
            log.info("[DataWorks] GetNode:{}", (Object)body);
            return body.getNode();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public Boolean deleteNode(Long projectId, Long nodeId) {
        DeleteNodeRequest deleteNodeRequest = new DeleteNodeRequest().setProjectId(projectId).setId(nodeId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            DeleteNodeResponse response = this.client.deleteNodeWithOptions(deleteNodeRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "DeleteNode");
            }
            DeleteNodeResponseBody body = response.getBody();
            log.info("[DataWorks] DeleteNode:{}", (Object)body);
            return body.getSuccess();
        }
        catch (Exception error) {
            log.error("[DataWorks] DeleteNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetTaskResponseBody.GetTaskResponseBodyTask getTask(Long taskId) {
        GetTaskRequest getTaskRequest = new GetTaskRequest().setId(taskId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetTaskResponse response = this.client.getTaskWithOptions(getTaskRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "GetTask");
            }
            GetTaskResponseBody body = response.getBody();
            log.info("[DataWorks] GetTask:{}", (Object)body);
            return body.getTask();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetTask", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public List<ListTasksResponseBody.ListTasksResponseBodyPagingInfoTasks> listTasks(Long projectId, String taskName, String resourceGroupId) {
        ListTasksRequest listTasksRequest = new ListTasksRequest().setProjectId(projectId).setTaskType(TaskNodeType.SHELL.getType()).setTriggerType(MANUAL_TRIGGER_TYPE).setRuntimeResource(resourceGroupId).setName(taskName);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ListTasksResponse response = this.client.listTasksWithOptions(listTasksRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "ListTasks");
            }
            ListTasksResponseBody body = response.getBody();
            return body.getPagingInfo().getTasks();
        }
        catch (Exception error) {
            log.error("[DataWorks] DeleteNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public Long execMultiAdhocTask(Long projectId, String owner, String workflowName, List<DataWorksAdhocTask> adhocTasks, Long bizDate) {
        List<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks> tasks = this.buildTasks(adhocTasks);
        ExecuteAdhocWorkflowInstanceRequest executeAdhocWorkflowInstanceRequest = new ExecuteAdhocWorkflowInstanceRequest().setTasks(tasks).setName(workflowName).setProjectId(projectId).setOwner(owner).setBizDate(bizDate);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ExecuteAdhocWorkflowInstanceResponse response = this.client.executeAdhocWorkflowInstanceWithOptions(executeAdhocWorkflowInstanceRequest, runtime);
            ExecuteAdhocWorkflowInstanceResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "ExecAdhocTask");
            }
            log.info("[DataWorks] ExecAdhocTask: projectId={}, bizDate={}, workflowInstanceId={}", new Object[]{projectId, bizDate, body.getWorkflowInstanceId()});
            for (DataWorksAdhocTask adhocTask : adhocTasks) {
                adhocTask.setWorkflowInstanceId(body.getWorkflowInstanceId());
            }
            return body.getWorkflowInstanceId();
        }
        catch (Exception error) {
            log.error("[DataWorks] ExecAdhocTask", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    private List<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks> buildTasks(List<DataWorksAdhocTask> adhocTasks) {
        ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks> buf = new ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks>();
        for (DataWorksAdhocTask adhocTask : adhocTasks) {
            ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksScript script = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksScript().setContent(adhocTask.getScript());
            ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksRuntimeResource runtimeResource = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksRuntimeResource().setResourceGroupId(adhocTask.getResourceGroupId()).setImage(adhocTask.getImage()).setCu(StringUtils.hasText((String)adhocTask.getCu()) ? adhocTask.getCu() : DEFAULT_CU);
            ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks task = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks().setClientUniqueCode(adhocTask.getTaskUid()).setName(adhocTask.getTaskName()).setType(adhocTask.getNodeType() == null ? TaskNodeType.SHELL.getType() : adhocTask.getNodeType().getType()).setOwner(adhocTask.getOwner()).setRuntimeResource(runtimeResource).setScript(script);
            if (adhocTask.getOutputs() != null && !adhocTask.getOutputs().isEmpty()) {
                ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputs outputs = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputs();
                ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputsTaskOutputs> taskOutputs = new ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputsTaskOutputs>();
                for (String output : adhocTask.getOutputs()) {
                    taskOutputs.add(new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputsTaskOutputs().setOutput(output));
                }
                outputs.setTaskOutputs(taskOutputs);
                task.setOutputs(outputs);
            }
            if (adhocTask.getDependencies() != null && !adhocTask.getDependencies().isEmpty()) {
                ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksDependencies> dependencies = new ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksDependencies>();
                for (String dependency : adhocTask.getDependencies()) {
                    dependencies.add(new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksDependencies().setUpstreamOutput(dependency));
                }
                task.setDependencies(dependencies);
            }
            buf.add(task);
        }
        return buf;
    }

    public Map<String, SuccessInfoValue> stopWorkflowInstance(List<Long> workflowInstanceIdList) {
        StopWorkflowInstancesRequest stopWorkflowInstancesRequest = new StopWorkflowInstancesRequest().setIds(workflowInstanceIdList);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            StopWorkflowInstancesResponse response = this.client.stopWorkflowInstancesWithOptions(stopWorkflowInstancesRequest, runtime);
            StopWorkflowInstancesResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "StopWorkflowInstances");
            }
            return body.getSuccessInfo();
        }
        catch (Exception error) {
            log.error("[DataWorks] StopWorkflowInstances", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public ListTaskInstancesResponseBody.ListTaskInstancesResponseBodyPagingInfoTaskInstances getTaskInstance(Long projectId, Long bizDate, Long workflowInstanceId, String taskName) {
        ListTaskInstancesRequest listTaskInstancesRequest = new ListTaskInstancesRequest().setProjectId(projectId).setBizdate(bizDate).setWorkflowInstanceId(workflowInstanceId);
        if (StringUtils.hasText((String)taskName)) {
            listTaskInstancesRequest.setTaskName(taskName);
        }
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ListTaskInstancesResponse response = this.client.listTaskInstancesWithOptions(listTaskInstancesRequest, runtime);
            ListTaskInstancesResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "ListTaskInstances");
            }
            List taskInstances = body.getPagingInfo().getTaskInstances();
            if (CollectionUtils.isEmpty((Collection)taskInstances)) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "DataWorks task instance is empty");
            }
            log.info("[DataWorks] ListTaskInstances:{}", (Object)body);
            return (ListTaskInstancesResponseBody.ListTaskInstancesResponseBodyPagingInfoTaskInstances)taskInstances.get(0);
        }
        catch (Exception error) {
            log.error("[DataWorks] ListTaskInstances", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetTaskInstanceResponseBody.GetTaskInstanceResponseBodyTaskInstance getTaskInstance(Long taskInstanceId) {
        GetTaskInstanceRequest getTaskInstanceRequest = new GetTaskInstanceRequest().setId(taskInstanceId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetTaskInstanceResponse response = this.client.getTaskInstanceWithOptions(getTaskInstanceRequest, runtime);
            GetTaskInstanceResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "GetTaskInstance");
            }
            log.info("[DataWorks] GetTaskInstance: instanceId={}", (Object)body.getTaskInstance().getId());
            return body.getTaskInstance();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetTaskInstance", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public String getTaskInstanceLog(Long taskInstanceId) {
        log.info("[DataWorks] get task instance log, taskId={}", (Object)taskInstanceId);
        GetTaskInstanceLogRequest getTaskInstanceLogRequest = new GetTaskInstanceLogRequest().setId(taskInstanceId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetTaskInstanceLogResponse response = this.client.getTaskInstanceLogWithOptions(getTaskInstanceLogRequest, runtime);
            GetTaskInstanceLogResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "GetTaskInstanceLog");
            }
            return body.getTaskInstanceLog();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetTaskInstanceLog", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetProjectResponseBody.GetProjectResponseBodyProject getProject(Long projectId) {
        GetProjectRequest getProjectRequest = new GetProjectRequest().setId(projectId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetProjectResponse response = this.client.getProjectWithOptions(getProjectRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "GetProject");
            }
            GetProjectResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "GetProject");
            }
            return body.getProject();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetProject", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }
}

