/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.file;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;

public class QRCodeImageTool {
    public static void saveQRCodeImage(String text, String filePath) {
        QRCodeImageTool.saveQRCodeImage(text, 300, filePath);
    }

    public static void saveQRCodeImage(String text, int size, String filePath) {
        try {
            QRCodeImageTool.generateQRCodeImage(text, size, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void generateQRCodeImage(String text, int size, String filePath) throws Exception {
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix byteMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, size, size, hints);
        Path path = FileSystems.getDefault().getPath(filePath, new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)byteMatrix, (String)"PNG", (Path)path);
    }
}

