/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.module;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Writer;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowSingleSpec;
import com.aliyun.migration.spec.domain.dataworks.NodeMainSpec;
import com.aliyun.migration.spec.domain.dataworks.WorkflowMainSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ElementKind;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.spec.domain.dataworks.node.EndPoint;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.AbstractWriter;
import com.aliyun.migration.workflow.migration.common.config.WriterProjectMappingRuleGroup;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.DwNewideClient;
import com.aliyun.migration.workflow.migration.dw.newide.converter.resource.ResourceFileConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.workflow.WorkflowConverter;
import com.aliyun.migration.workflow.migration.dw.newide.tools.DataWorksTopologicalUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewideWriter
extends AbstractWriter {
    private static final Logger log = LoggerFactory.getLogger(DwNewideWriter.class);
    protected DwNewideClient client;
    protected DataWorksNodeTypeUtils dataWorksNodeTypeUtils;
    protected Boolean crazyMode = false;

    public Writer init(TaskContext taskContext) {
        super.init(taskContext);
        if (StringUtils.isBlank((CharSequence)taskContext.getBwmConfiguration())) {
            taskContext.setBwmConfiguration("{}");
        }
        log.info("\u5f53\u524d\u914d\u7f6e\u63d0\u4ea4\u89c4\u5219\uff1a{}", (Object)JSONObject.toJSONString((Object)taskContext.getBwmConfiguration(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        Datasource scheduleDataSource = taskContext.getWriterDatasource();
        Map properties = scheduleDataSource.getProperties();
        String projectIdStr = (String)properties.get("project_id");
        String projectNameStr = (String)properties.get("project_name");
        if (!NumberUtils.isDigits((String)projectIdStr)) {
            log.error("Project id is not number or not found");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PROJECT_CONF_NOT_FOUND);
        }
        String env_ak = System.getenv("LHM_DW_AK");
        String env_sk = System.getenv("LHM_DW_SK");
        if (StringUtils.isNotBlank((CharSequence)env_ak) && StringUtils.isNotBlank((CharSequence)env_sk)) {
            properties.put("ak", env_ak);
            properties.put("sk", env_sk);
        }
        EndPoint endpoint = EndPoint.getEndPoint((String)((String)properties.get("endpoint")));
        this.client = new DwNewideClient((String)properties.get("ak"), (String)properties.get("sk"), (String)properties.get("endpoint"), endpoint.getName());
        try {
            String qpsLimit = ((JSONObject)JSONObject.parseObject((String)taskContext.getBwmConfiguration()).get("conf")).getString("qps.limit");
            this.client.qpsControl(Integer.valueOf(Integer.parseInt(qpsLimit)));
        }
        catch (Exception e) {
            log.info("\u672a\u627e\u5230\u6709\u6548\u7684qps\u8bbe\u7f6e\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a5");
        }
        try {
            Boolean crazyModeSetting = ((JSONObject)JSONObject.parseObject((String)taskContext.getBwmConfiguration()).get("conf")).getBoolean("crazy.mode");
            if (crazyModeSetting != null) {
                this.crazyMode = crazyModeSetting;
            }
            if (this.crazyMode.booleanValue()) {
                log.info("\n\u75af\u72c2\u6a21\u5f0f\u5f00\u542f\uff01\n\u4e0d\u518d\u7b49\u5f85\u5bfc\u5165\u5b8c\u6210\u3001\u4e0d\u518d\u9a8c\u8bc1\u5bfc\u5165\u7ed3\u679c\uff0c\u8c28\u614e\u4f7f\u7528\u3002\n\u8be5\u6a21\u5f0f\u4e0b\u5de5\u5177\u4e0d\u5bf9\u5bfc\u5165\u7ed3\u679c\u8d1f\u8d23\uff01\n\u5982\u9047\u5230\u95ee\u9898\u8bf7\u56de\u5f52\u5e38\u89c4\u6a21\u5f0f\uff01\n\u5bfc\u5165\u62a5\u544a\u65e0\u6b63\u5e38\u663e\u793a\u3002");
            }
        }
        catch (Exception e) {
            log.info("\u672a\u627e\u5230\u6709\u6548\u7684crazyMode\u8bbe\u7f6e\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3afalse");
        }
        this.workflowProjectPackage = this.getWorkflowPackage();
        this.PackageNormalization(this.workflowProjectPackage);
        this.RefreshIdInPackage(this.workflowProjectPackage);
        this.dataWorksNodeTypeUtils = new DataWorksNodeTypeUtils();
        try {
            String nodeTypeXls = ((JSONObject)JSONObject.parseObject((String)taskContext.getBwmConfiguration()).get("conf")).getString("dataworks.node.type.xls");
            File nodeTypeXlsFile = new File(nodeTypeXls);
            if (nodeTypeXlsFile.exists()) {
                this.dataWorksNodeTypeUtils = new DataWorksNodeTypeUtils(nodeTypeXlsFile);
                log.info("DataWorks\u8282\u70b9\u7c7b\u578b\u914d\u7f6e\u83b7\u53d6\u6210\u529f, nodeTypeXlsFile: {}", (Object)nodeTypeXlsFile.getAbsolutePath());
            } else {
                log.info("DataWorks\u8282\u70b9\u7c7b\u578b\u914d\u7f6e\u83b7\u53d6\u5931\u8d25, nodeTypeXlsFile\u4e0d\u5b58\u5728: {}", (Object)nodeTypeXlsFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.warn("DataWorks\u8282\u70b9\u7c7b\u578b\u914d\u7f6e\u83b7\u53d6\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4CodeProgramType");
        }
        this.dataWorksNodeTypeUtils.setEndPoint(endpoint);
        WriterProjectMappingRuleGroup writerProjectMappingRuleGroup = taskContext.getBwmConfiguration() == null || !taskContext.getBwmConfiguration().contains("project.mapping") ? new WriterProjectMappingRuleGroup(null, projectIdStr, projectNameStr) : new WriterProjectMappingRuleGroup(JSONObject.parseObject((String)taskContext.getBwmConfiguration()).get("project.mapping").toString(), projectIdStr, projectNameStr);
        this.freshProjectInfoInPackage(writerProjectMappingRuleGroup);
        this.checkOwner(this.workflowProjectPackage);
        this.findParentForEachNode();
        this.splitWorkflowByTargetProject();
        this.workflowProjectPackage.getWorkflowList().forEach(wf -> {
            if (wf.getTriggers() != null && wf.getTriggers().size() > 0) {
                wf.getWorkflowNodes().forEach(node -> {
                    if (Objects.isNull(node.getTrigger())) {
                        node.setTrigger((WorkflowTrigger)wf.getTriggers().get(0));
                    }
                });
            }
        });
        this.taskContext.setWorkflowProjectPackage(this.workflowProjectPackage);
        return this;
    }

    private void PackageNormalization(WorkflowProjectPackage workflowProjectPackage) {
        if (workflowProjectPackage.getWorkflowList() != null && !workflowProjectPackage.getWorkflowList().isEmpty()) {
            workflowProjectPackage.getWorkflowList().forEach(wf -> {
                wf.setWorkflowName(WorkflowConverter.nameStandard(wf.getWorkflowName()));
                if (wf.getWorkflowNodes() != null && !wf.getWorkflowNodes().isEmpty()) {
                    HashMap nodeNameCount = new HashMap();
                    wf.getWorkflowNodes().forEach(node -> {
                        if (nodeNameCount.containsKey(node.getNodeName())) {
                            String nodeName = node.getNodeName();
                            Integer index = (Integer)nodeNameCount.get(nodeName) + 1;
                            node.setNodeName(nodeName + "_" + index);
                            nodeNameCount.put(nodeName, index);
                        } else {
                            nodeNameCount.put(node.getNodeName(), 1);
                        }
                    });
                }
            });
        }
    }

    protected void RefreshIdInPackage(WorkflowProjectPackage workflowProjectPackage) {
        HashMap idMap = new HashMap();
        if (workflowProjectPackage.getWorkflowList() != null && !workflowProjectPackage.getWorkflowList().isEmpty()) {
            workflowProjectPackage.getWorkflowList().forEach(wf -> {
                if (wf.getCustomProperties() != null && wf.getCustomProperties().containsKey("MigrationOriginalId")) {
                    wf.setTWorkflowId(wf.getWorkflowId());
                    wf.setWorkflowId(wf.getCustomProperties().get("MigrationOriginalId").toString());
                    idMap.put(wf.getTWorkflowId(), wf.getWorkflowId());
                }
                if (wf.getWorkflowNodes() != null && !wf.getWorkflowNodes().isEmpty()) {
                    wf.getWorkflowNodes().forEach(node -> {
                        if (node.getCustomProperties() != null && node.getCustomProperties().containsKey("MigrationOriginalId")) {
                            node.setWorkflowId(wf.getWorkflowId());
                            node.setTNodeId(node.getNodeId());
                            node.setNodeId(node.getCustomProperties().get("MigrationOriginalId").toString());
                            idMap.put(node.getTNodeId(), node.getNodeId());
                        }
                    });
                }
            });
        }
        if (workflowProjectPackage.getWorkflowList() != null && !workflowProjectPackage.getWorkflowList().isEmpty()) {
            workflowProjectPackage.getWorkflowList().forEach(wf -> {
                if (wf.getNodeRelations() != null && !wf.getNodeRelations().isEmpty()) {
                    wf.getNodeRelations().forEach(relationPackage -> {
                        if (!StringUtils.isEmpty((CharSequence)relationPackage.getFrom()) && idMap.containsKey(relationPackage.getFrom())) {
                            relationPackage.setFrom((String)idMap.get(relationPackage.getFrom()));
                        }
                        if (!StringUtils.isEmpty((CharSequence)relationPackage.getTo()) && idMap.containsKey(relationPackage.getTo())) {
                            relationPackage.setTo((String)idMap.get(relationPackage.getTo()));
                        }
                    });
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
            workflowProjectPackage.getWorkflowList().forEach(wf -> {
                if (CollectionUtils.isNotEmpty((Collection)wf.getWorkflowNodes())) {
                    wf.getWorkflowNodes().forEach(node -> {
                        String subProcessId;
                        if (StringUtils.isNotBlank((CharSequence)node.getNodeType()) && DataWorksNodeTypeUtils.CustomCodeProgramType.getNodeType((String)node.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS) && idMap.containsKey(subProcessId = node.getScript())) {
                            node.setScript((String)idMap.get(subProcessId));
                        }
                    });
                }
            });
        }
    }

    private void checkOwner(WorkflowProjectPackage workflowProjectPackage) {
        List workflowList = workflowProjectPackage.getWorkflowList();
        if (workflowList == null || workflowList.size() == 0) {
            return;
        }
        HashMap<String, List> projectMemberMap = new HashMap<String, List>();
        for (Workflow workflow : workflowList) {
            if (workflow.getProjectId() != null && workflow.getOwner() != null) {
                if (!projectMemberMap.containsKey(workflow.getProjectId())) {
                    try {
                        projectMemberMap.put(workflow.getProjectId(), this.client.listProjectMemberId(workflow.getProjectId()));
                    }
                    catch (Exception e) {
                        projectMemberMap.put(workflow.getProjectId(), new ArrayList());
                    }
                }
                if (!((List)projectMemberMap.get(workflow.getProjectId())).contains(workflow.getOwner())) {
                    workflow.setOwner(null);
                }
            } else {
                workflow.setOwner(null);
            }
            if (workflow.getWorkflowNodes() == null || workflow.getWorkflowNodes().size() == 0) continue;
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                if (node.getProjectId() != null && node.getOwner() != null) {
                    if (!projectMemberMap.containsKey(node.getProjectId())) {
                        try {
                            projectMemberMap.put(node.getProjectId(), this.client.listProjectMemberId(node.getProjectId()));
                        }
                        catch (Exception e) {
                            projectMemberMap.put(node.getProjectId(), new ArrayList());
                        }
                    }
                    if (((List)projectMemberMap.get(node.getProjectId())).contains(node.getOwner())) continue;
                    node.setOwner(null);
                    continue;
                }
                node.setOwner(null);
            }
        }
    }

    private void findParentForEachNode() {
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        if (workflowList == null || workflowList.size() == 0) {
            return;
        }
        HashMap<String, WorkflowNode> nodeMap = new HashMap<String, WorkflowNode>();
        HashMap workflowMap = new HashMap();
        for (Workflow workflow : workflowList) {
            if (workflow.getWorkflowNodes() != null && workflow.getWorkflowNodes().size() > 0) {
                for (WorkflowNode node : workflow.getWorkflowNodes()) {
                    nodeMap.put(node.getNodeId(), node);
                }
            }
            if (!workflowMap.containsKey(workflow.getWorkflowId())) {
                workflowMap.put(workflow.getWorkflowId(), new ArrayList());
            }
            ((List)workflowMap.get(workflow.getWorkflowId())).add(workflow);
        }
        for (Workflow workflow : workflowList) {
            if (workflow.getNodeRelations() == null || workflow.getNodeRelations().size() <= 0) continue;
            for (RelationPackage relation : workflow.getNodeRelations()) {
                List childWorkflows;
                List parentWorkflows;
                WorkflowNode childNode;
                WorkflowNode parentNode;
                if (relation.getReType().equals((Object)RelationPackage.ReType.NODE) && nodeMap.containsKey(relation.getFrom()) && nodeMap.containsKey(relation.getTo())) {
                    parentNode = (WorkflowNode)nodeMap.get(relation.getFrom());
                    childNode = (WorkflowNode)nodeMap.get(relation.getTo());
                    if (childNode.getParentTargetIds() == null) {
                        childNode.setParentTargetIds(new ArrayList());
                    }
                    if (this.dataWorksNodeTypeUtils.getNodeType(parentNode.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.CONTROLLER_BRANCH)) {
                        JSONArray condition = JSONArray.parseArray((String)parentNode.getScript(), (JSONReader.Feature[])new JSONReader.Feature[0]);
                        for (int i = 0; i < condition.size(); ++i) {
                            JSONObject conditionItem = condition.getJSONObject(i);
                            if (!conditionItem.containsKey("nodeoutput") || !conditionItem.getString("nodeoutput").contains("to" + childNode.getNodeId() + "_")) continue;
                            String relationName = parentNode.getProjectName() + "." + parentNode.getNodeId() + "to" + childNode.getNodeId();
                            conditionItem.put((Object)"nodeoutput", (Object)(relationName + "_out"));
                            childNode.getParentTargetIds().add(relationName);
                        }
                        parentNode.setScript(condition.toJSONString(new JSONWriter.Feature[0]));
                        continue;
                    }
                    childNode.getParentTargetIds().add(parentNode.getProjectName() + "." + parentNode.getNodeId());
                    continue;
                }
                if (relation.getReType().equals((Object)RelationPackage.ReType.WORKFLOW_NODE) && workflowMap.containsKey(relation.getFrom()) && nodeMap.containsKey(relation.getTo())) {
                    parentWorkflows = (List)workflowMap.get(relation.getFrom());
                    childNode = (WorkflowNode)nodeMap.get(relation.getTo());
                    if (childNode.getParentTargetIds() == null) {
                        childNode.setParentTargetIds(new ArrayList());
                    }
                    parentWorkflows.forEach(parentWorkflow -> childNode.getParentTargetIds().add(parentWorkflow.getProjectName() + "." + parentWorkflow.getWorkflowId()));
                    continue;
                }
                if (relation.getReType().equals((Object)RelationPackage.ReType.NODE_WORKFLOW) && nodeMap.containsKey(relation.getFrom()) && workflowMap.containsKey(relation.getTo())) {
                    parentNode = (WorkflowNode)nodeMap.get(relation.getFrom());
                    childWorkflows = (List)workflowMap.get(relation.getTo());
                    childWorkflows.forEach(childWorkflow -> {
                        if (childWorkflow.getCustomProperties() == null) {
                            childWorkflow.setCustomProperties(new HashMap());
                        }
                        if (!childWorkflow.getCustomProperties().containsKey("parentTargetIds")) {
                            childWorkflow.getCustomProperties().put("parentTargetIds", new ArrayList());
                        }
                        ((ArrayList)childWorkflow.getCustomProperties().get("parentTargetIds")).add(parentNode.getProjectName() + "." + parentNode.getNodeId());
                    });
                    continue;
                }
                if (!relation.getReType().equals((Object)RelationPackage.ReType.WORKFLOW) || !workflowMap.containsKey(relation.getFrom()) || !workflowMap.containsKey(relation.getTo())) continue;
                parentWorkflows = (List)workflowMap.get(relation.getFrom());
                childWorkflows = (List)workflowMap.get(relation.getTo());
                parentWorkflows.forEach(parentWorkflow -> childWorkflows.forEach(childWorkflow -> {
                    if (childWorkflow.getCustomProperties() == null) {
                        childWorkflow.setCustomProperties(new HashMap());
                    }
                    if (!childWorkflow.getCustomProperties().containsKey("parentTargetIds")) {
                        childWorkflow.getCustomProperties().put("parentTargetIds", new ArrayList());
                    }
                    ((ArrayList)childWorkflow.getCustomProperties().get("parentTargetIds")).add(parentWorkflow.getProjectName() + "." + parentWorkflow.getWorkflowId());
                }));
            }
        }
    }

    protected void freshProjectInfoInPackage(WriterProjectMappingRuleGroup writerProjectMappingRuleGroup) {
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        for (Workflow workflow : workflowList) {
            Pair targetProjectInfo = writerProjectMappingRuleGroup.getTargetProjectId4Workflow(workflow);
            workflow.setProjectId((String)targetProjectInfo.getKey());
            workflow.setProjectName((String)targetProjectInfo.getValue());
            this.supplyFileAndFunction(workflow.getFiles(), workflow.getFunctions(), (String)targetProjectInfo.getKey());
            List workflowNodes = workflow.getWorkflowNodes();
            for (WorkflowNode node : workflowNodes) {
                targetProjectInfo = writerProjectMappingRuleGroup.getTargetProjectId4Node(node);
                node.setProjectName((String)targetProjectInfo.getValue());
                node.setProjectId((String)targetProjectInfo.getKey());
                this.supplyFileAndFunction(node.getFiles(), node.getFunctions(), (String)targetProjectInfo.getKey());
                node.setWorkflowName(workflow.getWorkflowName());
                if (Objects.isNull(this.workflowProjectPackage.getFilePath())) {
                    log.warn("not.found.project.prefix.path");
                }
                this.supplyTriggerNode(workflow.getTriggers(), node);
                node.setScriptPathPreFix(this.workflowProjectPackage.getFilePath());
                this.adaptNodeType(node);
            }
        }
    }

    private void supplyTriggerNode(List<WorkflowTrigger> triggers, WorkflowNode workflowNode) {
        if (CollectionUtils.isEmpty(triggers)) {
            return;
        }
        WorkflowTrigger workflowTrigger = triggers.get(0);
        workflowNode.setTrigger(workflowTrigger);
    }

    private void supplyFileAndFunction(List<WorkflowFileResource> fileResources, List<WorkflowFunctionResource> functionResources, String projectIdStr) {
        ((List)Optional.ofNullable(fileResources).orElse(new ArrayList())).forEach(fileResource -> {
            if (!StringUtils.equals((CharSequence)fileResource.getProjectId(), (CharSequence)projectIdStr)) {
                fileResource.setProjectId(projectIdStr);
            }
        });
        ((List)Optional.ofNullable(functionResources).orElse(new ArrayList())).forEach(functionResource -> {
            if (!StringUtils.equals((CharSequence)functionResource.getProjectId(), (CharSequence)projectIdStr)) {
                functionResource.setProjectId(projectIdStr);
            }
        });
    }

    private void adaptNodeType(WorkflowNode node) {
        if (Objects.isNull(node.getNodeType())) {
            log.warn("node type is null when adaptnodeType");
            return;
        }
        if (node.getNodeType().equals("VI")) {
            node.setNodeType(this.dataWorksNodeTypeUtils.getName(DataWorksNodeTypeUtils.CustomCodeProgramType.VIRTUAL));
        } else if (node.getNodeType().equals("SQL")) {
            node.setNodeType(this.dataWorksNodeTypeUtils.getName(DataWorksNodeTypeUtils.CustomCodeProgramType.ODPS_SQL));
        } else {
            node.setNodeType(this.dataWorksNodeTypeUtils.getName(DataWorksNodeTypeUtils.CustomCodeProgramType.getNodeType((String)node.getNodeType())));
        }
    }

    private void splitWorkflowByTargetProject() {
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        ArrayList newWorkflowList = new ArrayList();
        for (Workflow workflow : workflowList) {
            HashMap<String, Workflow> projectWorkflowMap = new HashMap<String, Workflow>();
            Workflow defaultWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
            defaultWorkflow.setWorkflowNodes(new ArrayList());
            projectWorkflowMap.put(defaultWorkflow.getProjectId(), defaultWorkflow);
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                String targetProjectId = node.getProjectId();
                if (!projectWorkflowMap.containsKey(targetProjectId)) {
                    Workflow newWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
                    newWorkflow.setProjectId(node.getProjectId());
                    newWorkflow.setProjectName(node.getProjectName());
                    newWorkflow.setWorkflowNodes(new ArrayList());
                    projectWorkflowMap.put(targetProjectId, newWorkflow);
                }
                ((Workflow)projectWorkflowMap.get(targetProjectId)).getWorkflowNodes().add(node);
            }
            newWorkflowList.addAll(projectWorkflowMap.values());
        }
        this.workflowProjectPackage.setWorkflowList(newWorkflowList);
    }

    public String write() {
        String result = this.submit();
        this.taskContext.setTargetWorkflowProjectPackage(this.workflowProjectPackage);
        return result;
    }

    public String submit() {
        WorkflowProject workflowProject = this.workflowProjectPackage.getWorkflowProject();
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        StatisticOp statisticOp = this.taskContext.getStatisticOp();
        statisticOp.addWorkflowTotal(workflowList.size());
        HashMap<String, List> existedWorkflowInProject = new HashMap<String, List>();
        Integer wfIndex = 1;
        ArrayList<String> workflowIdSortList = new ArrayList<String>();
        HashMap<String, Set<String>> downstreamDependencies = new HashMap<String, Set<String>>();
        DataWorksTopologicalUtils.sortWorkflowByDependency4OrginalId(this.workflowProjectPackage, this.dataWorksNodeTypeUtils, workflowIdSortList, downstreamDependencies);
        HashMap<String, Workflow> workflowMap = new HashMap<String, Workflow>();
        for (Workflow workflow : workflowList) {
            workflowMap.put(workflow.getWorkflowId(), workflow);
        }
        for (String workflowId : workflowIdSortList) {
            WorkflowMainSpec workflowSingleSpec;
            CycleWorkflowSingleSpec existTargetWorkflow;
            Workflow workflow = (Workflow)workflowMap.get(workflowId);
            log.info("[WRITE-WORKFLOW]({}/{})", (Object)wfIndex, (Object)workflowList.size());
            Integer n = wfIndex;
            wfIndex = wfIndex + 1;
            if (!existedWorkflowInProject.containsKey(workflow.getProjectId())) {
                log.info("\u4e3a\u5224\u65ad\u521b\u5efa/\u66f4\u65b0\uff0c\u83b7\u53d6project\u4e0b\u5df2\u7ecf\u5b58\u5728\u7684workflow");
                existedWorkflowInProject.put(workflow.getProjectId(), this.client.listWorkflowMainSpec(workflow.getProjectId(), Boolean.valueOf(false)));
            }
            WorkflowConverter workflowConverter = new WorkflowConverter(this.workflowProjectPackage, BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()), this.dataWorksNodeTypeUtils);
            if (workflow.getCustomProperties() != null && workflow.getCustomProperties().containsKey("spec")) {
                existTargetWorkflow = this.getExistTargetWorkflowSpec((List)existedWorkflowInProject.get(workflow.getProjectId()), workflow, true);
                workflowSingleSpec = workflowConverter.convertWorkflow4Mx(workflow, existTargetWorkflow);
            } else {
                existTargetWorkflow = this.getExistTargetWorkflowSpec((List)existedWorkflowInProject.get(workflow.getProjectId()), workflow, false);
                workflowSingleSpec = workflowConverter.convertWorkflow(workflow, existTargetWorkflow);
            }
            if (((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getCitable() == null) {
                ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).setCitable(Boolean.valueOf(false));
                ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getTrigger().setType("Scheduler");
            }
            for (Workflow wf : workflowList) {
                for (WorkflowNode node : wf.getWorkflowNodes()) {
                    if (!this.dataWorksNodeTypeUtils.getNodeType(node.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS) || StringUtils.isBlank((CharSequence)node.getScript()) || !node.getScript().equals(workflow.getWorkflowId()) && (workflow.getTWorkflowId() == null || !node.getScript().equals(workflow.getTWorkflowId()))) continue;
                    ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).setCitable(Boolean.valueOf(true));
                    ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getTrigger().setType("None");
                    break;
                }
                if (!((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).getCitable().booleanValue()) continue;
                break;
            }
            boolean isForeach = false;
            for (Workflow wf : workflowList) {
                for (WorkflowNode node : wf.getWorkflowNodes()) {
                    if (!this.dataWorksNodeTypeUtils.getNodeType(node.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.CONTROLLER_TRAVERSE) || StringUtils.isBlank((CharSequence)node.getScript()) || !node.getScript().equals(workflow.getWorkflowId())) continue;
                    isForeach = true;
                    break;
                }
                if (!isForeach) continue;
                break;
            }
            if (isForeach) {
                log.info("Foreach\u8282\u70b9\u5185\u90e8Workflow\uff0c\u8df3\u8fc7\u521b\u5efa");
                continue;
            }
            this.saveSpec(workflow, workflowSingleSpec);
            if (existTargetWorkflow == null) {
                this.importWorkflow(workflow, workflowSingleSpec);
            } else {
                this.importWorkflowForUpdate(workflow, workflowSingleSpec);
            }
            workflow.getCustomProperties().put("spec", WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)workflowSingleSpec).toJSONString(new JSONWriter.Feature[0]));
        }
        log.info("[WRITE-WORKFLOW] DONE");
        return workflowProject == null ? null : workflowProject.getName();
    }

    public void saveSpec(Workflow workflow, WorkflowMainSpec spec) {
        Workflow targetWf = (Workflow)WorkflowMainSpec.getWorkflowList((WorkflowMainSpec)spec).get(0);
        if (!StringUtils.equals((CharSequence)targetWf.getWorkflowId(), (CharSequence)workflow.getWorkflowId())) {
            workflow.setTWorkflowId(targetWf.getWorkflowId());
        }
        workflow.setOwner(targetWf.getOwner());
        workflow.setDescription(targetWf.getDescription());
        workflow.setTriggers(targetWf.getTriggers());
        workflow.setParamMap(targetWf.getParamMap());
        workflow.setCustomProperties(targetWf.getCustomProperties());
        if (workflow.getCustomProperties() != null && workflow.getCustomProperties().containsKey("MigrationOriginalId")) {
            workflow.getCustomProperties().remove("MigrationOriginalId");
        }
        workflow.setTriggers(targetWf.getTriggers());
        for (WorkflowNode node : workflow.getWorkflowNodes()) {
            NodeSingleSpec targetNode = WorkflowConverter.findExistedNode(node, ((CycleWorkflowSingleSpec)spec.getSpec().getWorkflows().get(0)).getNodes());
            if (targetNode == null) continue;
            WorkflowNode resultNode = NodeSingleSpec.getWorkflowNode((NodeSingleSpec)targetNode);
            if (!StringUtils.equals((CharSequence)resultNode.getNodeId(), (CharSequence)node.getNodeId())) {
                node.setTNodeId(resultNode.getNodeId());
            }
            node.setNodeName(resultNode.getNodeName());
            node.setOwner(resultNode.getOwner());
            node.setDescription(resultNode.getDescription());
            node.setTrigger(resultNode.getTrigger());
            node.setRuntimeResource(resultNode.getRuntimeResource());
            node.setState(resultNode.getState());
            node.setTimeout(resultNode.getTimeout());
            node.setInstanceMode(resultNode.getInstanceMode());
            node.setRerunMode(resultNode.getRerunMode());
            node.setCustomProperties(resultNode.getCustomProperties());
            node.setRerunTimes(resultNode.getRerunTimes());
            node.setRerunInterval(resultNode.getRerunInterval());
            node.setParamMap(resultNode.getParamMap());
            if (node.getCustomProperties() == null || !node.getCustomProperties().containsKey("MigrationOriginalId")) continue;
            node.getCustomProperties().remove("MigrationOriginalId");
        }
    }

    public CycleWorkflowSingleSpec getExistTargetWorkflowSpec(List<WorkflowMainSpec> exsitedWorkflowList, Workflow workflow, Boolean isMx) {
        Object uploadPath;
        for (WorkflowMainSpec exsitWf : exsitedWorkflowList) {
            if (!exsitWf.getSpec().getId().equals(workflow.getTWorkflowId())) continue;
            return (CycleWorkflowSingleSpec)exsitWf.getSpec().getWorkflows().get(0);
        }
        if (workflow.getCustomProperties() == null) {
            workflow.setCustomProperties(new HashMap());
        }
        if (isMx.booleanValue()) {
            uploadPath = workflow.getWorkflowName();
        } else if (workflow.getCategoryValue() != null) {
            String workflowPath = workflow.getCategoryValue();
            if (workflowPath.endsWith(workflow.getWorkflowName())) {
                workflowPath = workflowPath.substring(0, workflowPath.length() - workflow.getWorkflowName().length());
            }
            if (workflowPath.endsWith("/")) {
                workflowPath.substring(0, workflowPath.length() - 1);
            }
            uploadPath = workflowPath + "/" + WorkflowConverter.nameStandard(workflow.getWorkflowName());
            if (((String)(uploadPath = ((String)uploadPath).replaceAll("/+", "/"))).startsWith("/")) {
                uploadPath = ((String)uploadPath).substring(1);
            }
        } else {
            uploadPath = WorkflowConverter.nameStandard(workflow.getWorkflowName());
        }
        for (WorkflowMainSpec exsitWf : exsitedWorkflowList) {
            if (!((CycleWorkflowSingleSpec)exsitWf.getSpec().getWorkflows().get(0)).getScript().getPath().equals(uploadPath)) continue;
            return (CycleWorkflowSingleSpec)exsitWf.getSpec().getWorkflows().get(0);
        }
        return null;
    }

    public void importWorkflow(Workflow workflow, WorkflowMainSpec spec) {
        log.info("import workflow projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
        WorkflowMainSpec result = null;
        String targetId = null;
        try {
            this.taskContext.getStatisticOp().addWorkflowNodeTotal(workflow.getWorkflowNodes().size());
            targetId = this.client.importWorkflowDefinition(workflow.getProjectId(), WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)spec).toJSONString(new JSONWriter.Feature[0]));
            if (this.crazyMode.booleanValue()) {
                log.info("\u75af\u72c2\u6a21\u5f0f\u5f00\u542f\uff0c\u8df3\u8fc7\u5bfc\u5165\u7ed3\u679c\u7684\u68c0\u9a8c");
                workflow.setTWorkflowId(targetId);
                return;
            }
            this.client.waitingForComplete();
            result = WorkflowMainSpec.getWorkflowMainSpec((String)this.client.getWorkflowDefinition(workflow.getProjectId(), targetId, Boolean.valueOf(false)).getBody().getWorkflowDefinition().getSpec());
        }
        catch (Exception e) {
            log.error("create workflow error projectId={} workflowName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), e});
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), e.getMessage());
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "import workflow error"));
            return;
        }
        if (result == null) {
            log.error("create workflow error projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
            String errorMsg = this.client.getDwNewideAsyncJobLogByElementId(targetId).getErrorMsg();
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), errorMsg);
            workflow.getWorkflowNodes().forEach(node -> {
                if (this.dataWorksNodeTypeUtils.getNodeType(node.getNodeType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.SUB_PROCESS)) {
                    return;
                }
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "import workflow error: " + errorMsg);
            });
        } else {
            workflow.setTWorkflowId(result.getSpec().getId());
            this.taskContext.getStatisticOp().addWorkflowSuccess(workflow.getWorkflowId());
            this.saveSpec(workflow, result);
            for (WorkflowNode node2 : workflow.getWorkflowNodes()) {
                if (!StringUtils.isEmpty((CharSequence)node2.getTNodeId())) {
                    this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node2.getNodeId());
                    continue;
                }
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(node2.getNodeId(), "import workflow error: " + this.client.getDwNewideAsyncJobLogByElementId(targetId).getErrorMsg());
            }
        }
    }

    public void importWorkflowForUpdate(Workflow workflow, WorkflowMainSpec spec) {
        log.info("update workflow projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
        WorkflowMainSpec result = null;
        String targetId = null;
        try {
            this.taskContext.getStatisticOp().addWorkflowNodeTotal(workflow.getWorkflowNodes().size());
            targetId = this.client.importWorkflowDefinition(workflow.getProjectId(), WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)spec).toJSONString(new JSONWriter.Feature[0]));
            if (this.crazyMode.booleanValue()) {
                log.info("\u75af\u72c2\u6a21\u5f0f\u5f00\u542f\uff0c\u8df3\u8fc7\u5bfc\u5165\u7ed3\u679c\u7684\u68c0\u9a8c");
                workflow.setTWorkflowId(targetId);
                return;
            }
            this.client.waitingForComplete();
            result = WorkflowMainSpec.getWorkflowMainSpec((String)this.client.getWorkflowDefinition(workflow.getProjectId(), targetId, Boolean.valueOf(false)).getBody().getWorkflowDefinition().getSpec());
        }
        catch (Exception e) {
            log.error("update workflow error projectId={} workflowName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), e});
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), e.getMessage());
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "update workflow error: " + e.getMessage()));
            return;
        }
        String errorMsg = this.client.getDwNewideAsyncJobLogByElementId(targetId).getErrorMsg();
        if (errorMsg != null) {
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), "update workflow error (\u53ef\u80fd\u662f\u90e8\u5206\u66f4\u65b0\u9519\u8bef\uff0c\u9700\u8981\u4eba\u5de5\u6838\u5bf9): " + errorMsg);
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeFailure(node.getNodeId(), "update workflow error (\u53ef\u80fd\u662f\u90e8\u5206\u66f4\u65b0\u9519\u8bef\uff0c\u9700\u8981\u4eba\u5de5\u6838\u5bf9): " + errorMsg));
        } else {
            this.taskContext.getStatisticOp().addWorkflowSuccess(workflow.getWorkflowId());
            workflow.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node.getNodeId()));
        }
        if (result != null) {
            this.saveSpec(workflow, result);
        }
    }

    public void updateWorkflow(Workflow workflow, CycleWorkflowSingleSpec workflowSingleSpec, CycleWorkflowSingleSpec exsitedWorkflowSingleSpec) {
        log.info("update workflow projectId={} workflowName={}", (Object)workflow.getProjectId(), (Object)workflow.getWorkflowName());
        try {
            WorkflowMainSpec spec = new WorkflowMainSpec();
            spec.setVersion("1.1.0");
            spec.setKind(ElementKind.CYCLE_WORKFLOW);
            spec.setSpec(new CycleWorkflowBatchSpec());
            spec.getSpec().setName(workflow.getWorkflowName());
            spec.getSpec().setType(ElementKind.CYCLE_WORKFLOW);
            spec.getSpec().setWorkflows(List.of(workflowSingleSpec));
            if (this.client.updateWorkflowDefinition(workflow.getProjectId(), workflowSingleSpec.getId(), WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)spec).toJSONString(new JSONWriter.Feature[0])).booleanValue()) {
                workflow.setTWorkflowId(workflowSingleSpec.getId());
                this.taskContext.getStatisticOp().addWorkflowSuccess(workflow.getWorkflowId());
            } else {
                this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), "update workflow error");
            }
        }
        catch (Exception e) {
            log.error("update workflow error projectId={} workflowName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), e});
            this.taskContext.getStatisticOp().addWorkflowFailure(workflow.getWorkflowId(), e.getMessage());
        }
        if (workflow.getWorkflowNodes() == null || workflow.getWorkflowNodes().size() == 0) {
            return;
        }
        this.taskContext.getStatisticOp().addWorkflowNodeTotal(workflow.getWorkflowNodes().size());
        ArrayList existedNodeIdList = new ArrayList();
        exsitedWorkflowSingleSpec.getNodes().forEach(node -> existedNodeIdList.add(node.getId()));
        for (NodeSingleSpec nodeSingleSpec : workflowSingleSpec.getNodes()) {
            try {
                NodeMainSpec nodeMainSpec = new NodeMainSpec();
                nodeMainSpec.setVersion("1.1.0");
                nodeMainSpec.setKind(ElementKind.NODE);
                nodeMainSpec.setSpec(List.of(nodeSingleSpec));
                if (!existedNodeIdList.contains(nodeSingleSpec.getId())) {
                    if (nodeSingleSpec.getSubflow() != null) continue;
                    log.info("create node projectId={} workflowName={} nodeName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()});
                    String nodeId = this.client.createNode(workflow.getProjectId(), workflowSingleSpec.getId(), NodeMainSpec.getNodeMainSpecJson((NodeMainSpec)nodeMainSpec).toJSONString(new JSONWriter.Feature[0]));
                    WorkflowNode node2 = WorkflowConverter.findBwmNode(nodeSingleSpec, workflow.getWorkflowNodes());
                    if (node2 != null) {
                        node2.setTNodeId(nodeId);
                        this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node2.getNodeId() + "_" + node2.getNodeName());
                        continue;
                    }
                    this.taskContext.getStatisticOp().addWorkflowNodeFailure(nodeSingleSpec.getId(), String.format("create node error projectId=%s workflowName=%s nodeName=%s", workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()));
                    continue;
                }
                if (nodeSingleSpec.getSubflow() != null) continue;
                log.info("update node projectId={} workflowName={} nodeName={}", new Object[]{workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()});
                if (this.client.updateNode(workflow.getProjectId(), nodeSingleSpec.getId(), NodeMainSpec.getNodeMainSpecJson((NodeMainSpec)nodeMainSpec).toJSONString(new JSONWriter.Feature[0])).booleanValue()) {
                    WorkflowNode node3 = WorkflowConverter.findBwmNode(nodeSingleSpec, workflow.getWorkflowNodes());
                    node3.setTNodeId(nodeSingleSpec.getId());
                    this.taskContext.getStatisticOp().addWorkflowNodeSuccess(node3.getNodeId());
                    continue;
                }
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(nodeSingleSpec.getId(), String.format("update node error projectId=%s workflowName=%s nodeName=%s", workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()));
            }
            catch (Exception e) {
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(nodeSingleSpec.getId(), String.format("create node error projectId=%s workflowName=%s nodeName=%s", workflow.getProjectId(), workflow.getWorkflowName(), nodeSingleSpec.getName()));
            }
        }
    }

    public void UploadStringResource(WorkflowProjectPackage workflowProjectPackage) {
        HashMap projectResource = new HashMap();
        for (Workflow wf : workflowProjectPackage.getWorkflowList()) {
            for (WorkflowFileResource workflowFileResource : wf.getFiles()) {
                if (!projectResource.containsKey(wf.getProjectId())) {
                    projectResource.put(wf.getProjectId(), new ArrayList());
                }
                ((List)projectResource.get(wf.getProjectId())).add(workflowFileResource);
            }
        }
        HashMap<String, Map> existedProjectResource = new HashMap<String, Map>();
        for (String projectId : projectResource.keySet()) {
            existedProjectResource.put(projectId, this.client.listResourcePathId(projectId));
        }
        for (String projectId : projectResource.keySet()) {
            for (WorkflowFileResource workflowFileResource : (List)projectResource.get(projectId)) {
                String string;
                ResourceFileConverter resourceFileConverter;
                workflowFileResource.setProjectId(projectId);
                Object targetPath = workflowFileResource.getFolder() + "/" + workflowFileResource.getName();
                targetPath = ((String)targetPath).replaceAll("//", "/");
                if (((String)targetPath).startsWith("/")) {
                    targetPath = ((String)targetPath).substring(1);
                }
                if (!this.dataWorksNodeTypeUtils.getNodeType(workflowFileResource.getFileType()).equals((Object)DataWorksNodeTypeUtils.CustomCodeProgramType.EMR_FILE)) continue;
                if (((Map)existedProjectResource.get(projectId)).containsKey(targetPath)) {
                    resourceFileConverter = new ResourceFileConverter();
                    resourceFileConverter.setConf(BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()));
                    string = resourceFileConverter.convert(workflowFileResource, (String)((Map)existedProjectResource.get(projectId)).get(targetPath));
                    continue;
                }
                resourceFileConverter = new ResourceFileConverter();
                resourceFileConverter.setConf(BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()));
                string = resourceFileConverter.convert(workflowFileResource, null);
            }
        }
    }

    public void isSubFlow(String workflowName) {
    }

    public String writeSingleWorkflow(Workflow workflow) throws Exception {
        return null;
    }

    public void close() {
        super.close();
    }

    protected void createFolder(String folderPath, String projectId, String workflowName) {
    }

    protected Long getExistedNode(WorkflowNode workflowNode) {
        return null;
    }

    protected Long existWorkflowId(Workflow workflow) {
        return null;
    }

    protected Long existResourceFileId(WorkflowFileResource workflowFileResource, String projectId) {
        return null;
    }

    protected Long createWorkflowBaseReal(Workflow workflow) throws Exception {
        return null;
    }

    protected Object createResourceFileReal(WorkflowFileResource workflowFileResource, String projectId, String workflowName) throws Exception {
        return null;
    }

    protected void deleteResourceFile(long projectId, long fileId) throws Exception {
    }

    protected Object createFunctionReal(WorkflowFunctionResource workflowFunctionResource, String projectId, String workflowName) throws Exception {
        return null;
    }

    protected Long createNodeReal(WorkflowNode workflowNode) throws Exception {
        return null;
    }

    protected Long updateNodeReal(WorkflowNode workflowNode, String fieldId) throws Exception {
        return null;
    }

    protected void submitReal(String projectId, String fieldId) {
    }
}

