/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.newide.converter.workflow;

import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowSingleSpec;
import com.aliyun.migration.spec.domain.dataworks.WorkflowMainSpec;
import com.aliyun.migration.spec.domain.dataworks.common.DependencyNodeSpec;
import com.aliyun.migration.spec.domain.dataworks.common.DependencySingleSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ElementKind;
import com.aliyun.migration.spec.domain.dataworks.common.ScriptSpec;
import com.aliyun.migration.spec.domain.dataworks.common.StrategySpec;
import com.aliyun.migration.spec.domain.dataworks.common.TriggerSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.NodeOutputSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.OutputBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.AbstractNodeConverter;
import com.aliyun.migration.workflow.migration.dw.newide.converter.node.DwNewideConvertFactory;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowConverter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowConverter.class);
    protected BwmConfiguration taskContextConf;
    protected WorkflowProjectPackage workflowProjectPackage;
    protected DataWorksNodeTypeUtils dataWorksNodeTypeUtils;

    public WorkflowConverter(WorkflowProjectPackage workflowProjectPackage, BwmConfiguration taskContextConf, DataWorksNodeTypeUtils dataWorksNodeTypeUtils) {
        this.workflowProjectPackage = workflowProjectPackage;
        this.setConf(taskContextConf);
        this.dataWorksNodeTypeUtils = dataWorksNodeTypeUtils;
    }

    public void setConf(BwmConfiguration taskContextConf) {
        this.taskContextConf = Objects.isNull(taskContextConf) ? BwmConfiguration.newDefault() : (Objects.nonNull(taskContextConf.get("conf")) ? taskContextConf.getConfiguration("conf") : taskContextConf);
    }

    public WorkflowMainSpec convertWorkflow(Workflow workflow, CycleWorkflowSingleSpec existedWorkflow) {
        WorkflowMainSpec spec = new WorkflowMainSpec();
        CycleWorkflowSingleSpec workflowSingleSpec = this.convertSingleWorkflow(workflow, existedWorkflow);
        spec.setVersion("1.1.0");
        spec.setKind(ElementKind.CYCLE_WORKFLOW);
        spec.setSpec(new CycleWorkflowBatchSpec());
        spec.getSpec().setName(workflow.getWorkflowName());
        spec.getSpec().setType(ElementKind.CYCLE_WORKFLOW);
        spec.getSpec().setWorkflows(List.of(workflowSingleSpec));
        spec.getSpec().setFlow(new ArrayList());
        DependencyNodeSpec dependencyNodeSpec = new DependencyNodeSpec();
        dependencyNodeSpec.setNodeId(workflowSingleSpec.getId());
        dependencyNodeSpec.setDepends(new ArrayList());
        if (workflow.getCustomProperties() != null && workflow.getCustomProperties().containsKey("parentTargetIds")) {
            ((ArrayList)workflow.getCustomProperties().get("parentTargetIds")).forEach(parentTargetId -> {
                DependencySingleSpec dependencySingleSpec = new DependencySingleSpec();
                dependencySingleSpec.setType("Normal");
                dependencySingleSpec.setOutput(parentTargetId + "_out");
                dependencyNodeSpec.getDepends().add(dependencySingleSpec);
            });
        }
        spec.getSpec().getFlow().add(dependencyNodeSpec);
        return spec;
    }

    public CycleWorkflowSingleSpec convertSingleWorkflow(Workflow workflow, CycleWorkflowSingleSpec existedWorkflow) {
        CycleWorkflowSingleSpec spec = new CycleWorkflowSingleSpec();
        if (existedWorkflow != null) {
            spec = (CycleWorkflowSingleSpec)BwmJsonUtil.deepCopy((Object)existedWorkflow, CycleWorkflowSingleSpec.class);
            workflow.setTWorkflowId(existedWorkflow.getId());
        } else {
            existedWorkflow = new CycleWorkflowSingleSpec();
            workflow.setTWorkflowId(null);
        }
        if (workflow.getTWorkflowId() != null) {
            spec.setId(workflow.getTWorkflowId());
        } else {
            spec.setId(workflow.getWorkflowId());
        }
        spec.setName(WorkflowConverter.nameStandard(workflow.getWorkflowName()));
        if (workflow.getOwner() != null) {
            spec.setOwner(workflow.getOwner());
        } else if (existedWorkflow != null && existedWorkflow.getOwner() != null) {
            spec.setOwner(existedWorkflow.getOwner());
        }
        if (workflow.getDescription() != null) {
            spec.setDescription(workflow.getDescription());
        }
        if (spec.getScript() == null) {
            spec.setScript(new ScriptSpec());
        }
        if (workflow.getCategoryValue() != null) {
            String workflowPath = workflow.getCategoryValue();
            if (workflowPath.endsWith(workflow.getWorkflowName())) {
                workflowPath = workflowPath.substring(0, workflowPath.length() - workflow.getWorkflowName().length());
            }
            if (workflowPath.endsWith("/")) {
                workflowPath.substring(0, workflowPath.length() - 1);
            }
            spec.getScript().setPath(workflowPath + "/" + WorkflowConverter.nameStandard(workflow.getWorkflowName()));
            spec.getScript().setPath(spec.getScript().getPath().replaceAll("/+", "/"));
        } else {
            spec.getScript().setPath(WorkflowConverter.nameStandard(workflow.getWorkflowName()));
        }
        if (spec.getScript().getRuntime() == null) {
            spec.getScript().setRuntime(new HashMap());
        }
        spec.getScript().getRuntime().put("command", "WORKFLOW");
        if (spec.getTrigger() == null) {
            spec.setTrigger(new TriggerSpec());
        }
        spec.getTrigger().setType("Scheduler");
        if (workflow.getTriggers() != null && !workflow.getTriggers().isEmpty()) {
            spec.getTrigger().setCron(WorkflowConverter.cronSta(((WorkflowTrigger)workflow.getTriggers().get(0)).getCron()));
            Object formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if (!Objects.isNull(((WorkflowTrigger)workflow.getTriggers().get(0)).getStartTime())) {
                spec.getTrigger().setStartTime(((WorkflowTrigger)workflow.getTriggers().get(0)).getStartTime().format((DateTimeFormatter)formatter));
            } else {
                spec.getTrigger().setStartTime("1970-01-01 00:00:00");
            }
            if (!Objects.isNull(((WorkflowTrigger)workflow.getTriggers().get(0)).getEndTime())) {
                spec.getTrigger().setEndTime(((WorkflowTrigger)workflow.getTriggers().get(0)).getEndTime().format((DateTimeFormatter)formatter));
            } else {
                spec.getTrigger().setEndTime("9999-01-01 00:00:00");
            }
            if (((WorkflowTrigger)workflow.getTriggers().get(0)).getTimezone() != null) {
                spec.getTrigger().setTimezone(((WorkflowTrigger)workflow.getTriggers().get(0)).getTimezone().toString());
            } else {
                spec.getTrigger().setTimezone(ZoneId.systemDefault().toString());
            }
        }
        if (spec.getTrigger().getDelaySeconds() == null) {
            spec.getTrigger().setDelaySeconds(Integer.valueOf(0));
        }
        if (spec.getStrategy() == null) {
            spec.setStrategy(new StrategySpec());
        }
        spec.getStrategy().setTimeout(Integer.valueOf(0));
        switch ((String)this.taskContextConf.getValue("instance.mode", (Object)((String)workflow.getCustomProperties().get("instance.mode")), (Object)"instance.mode", String.class, BwmServiceErrorCode.CONFIG_ERROR)) {
            case "T_PLUS_1": {
                spec.getStrategy().setInstanceMode("T+1");
                break;
            }
            case "IMMEDIATELY": {
                spec.getStrategy().setInstanceMode("Immediately");
                break;
            }
            default: {
                spec.getStrategy().setInstanceMode("T+1");
            }
        }
        if (workflow.getCustomProperties().containsKey("rerun.mode") && workflow.getCustomProperties().get("rerun.mode") instanceof Integer) {
            switch (RerunMode.getByValue((int)((Integer)this.taskContextConf.getValue("rerun.mode", (Object)((Integer)workflow.getCustomProperties().get("rerun.mode")), (Object)BwmCommonConstant.Dataworks.RERUN_MODE_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR)))) {
                case ALL_ALLOWED: {
                    spec.getStrategy().setRerunMode("Allowed");
                    break;
                }
                case ALL_DENIED: {
                    spec.getStrategy().setRerunMode("Denied");
                    break;
                }
                case FAILURE_ALLOWED: {
                    spec.getStrategy().setRerunMode("FailureAllowed");
                    break;
                }
                case UNKNOWN: {
                    spec.getStrategy().setRerunMode("Allowed");
                }
            }
        } else if (workflow.getCustomProperties().containsKey("rerun.mode") && workflow.getCustomProperties().get("rerun.mode") instanceof String) {
            spec.getStrategy().setRerunMode((String)this.taskContextConf.getValue("rerun.mode", (Object)((String)workflow.getCustomProperties().get("rerun.mode")), (Object)RerunMode.getByValue((int)BwmCommonConstant.Dataworks.RERUN_MODE_DEFAULT).name(), String.class, BwmServiceErrorCode.CONFIG_ERROR));
        }
        spec.getStrategy().setRerunTimes((Integer)this.taskContextConf.getValue("auto.rerun.times", (Object)((Integer)workflow.getCustomProperties().get("auto.rerun.times")), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_TIMES_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        spec.getStrategy().setRerunInterval((Integer)this.taskContextConf.getValue("auto.rerun.interval.millis", (Object)((Integer)workflow.getCustomProperties().get("auto.rerun.interval.millis")), (Object)BwmCommonConstant.Dataworks.AUTO_RERUN_INTERVAL_MILLIS_DEFAULT, Integer.class, BwmServiceErrorCode.CONFIG_ERROR));
        spec.getStrategy().setFailureStrategy("Break");
        spec.getStrategy().setRecurrenceType("Normal");
        spec.setCitable(Boolean.valueOf(false));
        if (spec.getOutputs() == null) {
            spec.setOutputs(new OutputBatchSpec());
        }
        if (spec.getOutputs().getNodeOutputs() == null) {
            spec.getOutputs().setNodeOutputs(new ArrayList());
        }
        if (spec.getOutputs().getNodeOutputs().size() == 0) {
            NodeOutputSpec output = new NodeOutputSpec();
            output.setData(String.format("%s.%s_out", workflow.getProjectName(), workflow.getWorkflowId()));
            output.setArtifactType("NodeOutput");
            spec.getOutputs().getNodeOutputs().add(output);
        } else {
            Boolean flag = true;
            for (NodeOutputSpec output : spec.getOutputs().getNodeOutputs()) {
                if (!output.getData().equals(String.format("%s.%s_out", workflow.getProjectName(), workflow.getWorkflowId()))) continue;
                flag = false;
                break;
            }
            if (flag.booleanValue()) {
                NodeOutputSpec output = new NodeOutputSpec();
                output.setData(String.format("%s.%s_out", workflow.getProjectName(), workflow.getWorkflowId()));
                output.setArtifactType("NodeOutput");
                spec.getOutputs().getNodeOutputs().add(output);
            }
        }
        spec.setNodes(new ArrayList());
        for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
            NodeSingleSpec nodeSpec = this.convertSingleNode(workflowNode, existedWorkflow);
            if (nodeSpec == null) continue;
            spec.getNodes().add(nodeSpec);
        }
        spec.setDependencies(new ArrayList());
        for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
            if (workflowNode.getParentTargetIds() == null || workflowNode.getParentTargetIds().size() <= 0) continue;
            DependencyNodeSpec dependency = new DependencyNodeSpec();
            if (workflowNode.getTNodeId() != null) {
                dependency.setNodeId(workflowNode.getTNodeId());
            } else {
                dependency.setNodeId(workflowNode.getNodeId());
            }
            dependency.setDepends(new ArrayList());
            for (String parentId : workflowNode.getParentTargetIds()) {
                DependencySingleSpec parentDependency = new DependencySingleSpec();
                parentDependency.setType("Normal");
                parentDependency.setOutput(parentId + "_out");
                dependency.getDepends().add(parentDependency);
            }
            spec.getDependencies().add(dependency);
        }
        spec.getScript().setParameters(new ArrayList());
        if (workflow.getParamMap() != null && !workflow.getParamMap().isEmpty()) {
            for (String key : workflow.getParamMap().keySet()) {
                ScriptSpec.ScriptParameterSpec scriptParameterSpec = new ScriptSpec.ScriptParameterSpec();
                scriptParameterSpec.setType("Constant");
                scriptParameterSpec.setScope("Workflow");
                scriptParameterSpec.setName(key);
                if (workflow.getParamMap().get(key) != null) {
                    scriptParameterSpec.setValue(workflow.getParamMap().get(key).toString());
                } else {
                    scriptParameterSpec.setValue("");
                }
                spec.getScript().getParameters().add(scriptParameterSpec);
            }
        }
        if (workflow.getCustomProperties() == null) {
            workflow.setCustomProperties(new HashMap());
        }
        workflow.getCustomProperties().put("spec", CycleWorkflowSingleSpec.getCycleWorkflowSingleSpecJson((CycleWorkflowSingleSpec)spec).toJSONString(new JSONWriter.Feature[0]));
        return spec;
    }

    public NodeSingleSpec convertSingleNode(WorkflowNode workflowNode, CycleWorkflowSingleSpec existedWorkflow) {
        AbstractNodeConverter converter;
        try {
            converter = DwNewideConvertFactory.buildConvert(workflowNode.getNodeType(), this.workflowProjectPackage, this.taskContextConf, this.dataWorksNodeTypeUtils);
        }
        catch (Exception e) {
            log.error("Node Converter Error! {}, {}", (Object)workflowNode.getNodeType(), (Object)e);
            return null;
        }
        NodeSingleSpec existedNode = null;
        if (existedWorkflow != null) {
            existedNode = WorkflowConverter.findExistedNode(workflowNode, existedWorkflow.getNodes());
        }
        if (existedNode != null) {
            workflowNode.setTNodeId(existedNode.getId());
        } else {
            workflowNode.setTNodeId(null);
        }
        NodeSingleSpec nodeSpec = converter.convert(workflowNode, existedNode);
        if (workflowNode.getCustomProperties() == null) {
            workflowNode.setCustomProperties(new HashMap());
        }
        workflowNode.getCustomProperties().put("spec", NodeSingleSpec.getNodeSingleSpecJson((NodeSingleSpec)nodeSpec).toJSONString(new JSONWriter.Feature[0]));
        return nodeSpec;
    }

    public static NodeSingleSpec findExistedNode(WorkflowNode node, List<NodeSingleSpec> existedNodes) {
        if (existedNodes == null || existedNodes.size() == 0) {
            return null;
        }
        if (node.getNodeId() != null) {
            for (NodeSingleSpec nodeSingleSpec : existedNodes) {
                if (nodeSingleSpec.getId() == null || !nodeSingleSpec.getId().equals(node.getNodeId())) continue;
                return nodeSingleSpec;
            }
        }
        if (node.getTNodeId() != null) {
            for (NodeSingleSpec nodeSingleSpec : existedNodes) {
                if (nodeSingleSpec.getId() == null || !nodeSingleSpec.getId().equals(node.getTNodeId())) continue;
                return nodeSingleSpec;
            }
        }
        if (node.getCustomProperties() != null && node.getCustomProperties().containsKey("spec")) {
            String oneOutput = ((NodeOutputSpec)NodeSingleSpec.getNodeSingleSpec((String)((String)node.getCustomProperties().get("spec"))).getOutputs().getNodeOutputs().get(0)).getData();
            for (NodeSingleSpec existedNode : existedNodes) {
                if (existedNode.getOutputs() == null || existedNode.getOutputs().getNodeOutputs() == null || existedNode.getOutputs().getNodeOutputs().size() <= 0) continue;
                for (NodeOutputSpec output : existedNode.getOutputs().getNodeOutputs()) {
                    if (!output.getData().equals(oneOutput)) continue;
                    return existedNode;
                }
            }
        }
        for (NodeSingleSpec nodeSingleSpec : existedNodes) {
            if (nodeSingleSpec.getOutputs() == null || nodeSingleSpec.getOutputs().getNodeOutputs() == null || nodeSingleSpec.getOutputs().getNodeOutputs().size() <= 0) continue;
            for (NodeOutputSpec output : nodeSingleSpec.getOutputs().getNodeOutputs()) {
                if (!output.getData().equals(node.getProjectName() + "." + node.getNodeId() + "_out")) continue;
                return nodeSingleSpec;
            }
        }
        return null;
    }

    public static WorkflowNode findBwmNode(NodeSingleSpec existedNode, List<WorkflowNode> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        if (existedNode.getId() != null) {
            for (WorkflowNode node : nodes) {
                if (node.getTNodeId() == null || !node.getTNodeId().equals(existedNode.getId())) continue;
                return node;
            }
        }
        ArrayList outputList = new ArrayList();
        existedNode.getOutputs().getNodeOutputs().forEach(output -> outputList.add(output.getData()));
        for (WorkflowNode node : nodes) {
            if (node.getProjectName() == null || node.getNodeId() == null || !outputList.contains(node.getProjectName() + "." + node.getNodeId() + "_out")) continue;
            return node;
        }
        return null;
    }

    public WorkflowMainSpec convertWorkflow4Mx(Workflow workflow, CycleWorkflowSingleSpec existedWorkflow) {
        WorkflowMainSpec spec = new WorkflowMainSpec();
        CycleWorkflowSingleSpec workflowSingleSpec = this.convertSingleWorkflow4Mx(workflow, existedWorkflow);
        spec.setVersion("1.1.0");
        spec.setKind(ElementKind.CYCLE_WORKFLOW);
        spec.setSpec(new CycleWorkflowBatchSpec());
        spec.getSpec().setName(workflow.getWorkflowName());
        spec.getSpec().setType(ElementKind.CYCLE_WORKFLOW);
        spec.getSpec().setWorkflows(List.of(workflowSingleSpec));
        spec.getSpec().setFlow(new ArrayList());
        DependencyNodeSpec dependencyNodeSpec = new DependencyNodeSpec();
        dependencyNodeSpec.setNodeId(workflowSingleSpec.getId());
        dependencyNodeSpec.setDepends(new ArrayList());
        if (workflow.getCustomProperties() != null && workflow.getCustomProperties().containsKey("parentTargetIds")) {
            ((ArrayList)workflow.getCustomProperties().get("parentTargetIds")).forEach(parentTargetId -> {
                DependencySingleSpec dependencySingleSpec = new DependencySingleSpec();
                dependencySingleSpec.setType("Normal");
                dependencySingleSpec.setOutput(parentTargetId + "_out");
                dependencyNodeSpec.getDepends().add(dependencySingleSpec);
            });
        }
        spec.getSpec().getFlow().add(dependencyNodeSpec);
        return spec;
    }

    public CycleWorkflowSingleSpec convertSingleWorkflow4Mx(Workflow workflow, CycleWorkflowSingleSpec existedWorkflow) {
        CycleWorkflowSingleSpec spec = CycleWorkflowSingleSpec.getCycleWorkflowSingleSpec((String)((String)workflow.getCustomProperties().get("spec")));
        if (existedWorkflow == null) {
            return spec;
        }
        workflow.setTWorkflowId(existedWorkflow.getId());
        if (workflow.getDescription() != null) {
            spec.setDescription(workflow.getDescription());
        }
        spec.setId(existedWorkflow.getId());
        if (workflow.getOwner() != null) {
            spec.setOwner(workflow.getOwner());
        } else {
            spec.setOwner(existedWorkflow.getOwner());
        }
        spec.setCitable(Boolean.valueOf(false));
        spec.setNodes(new ArrayList());
        if (workflow.getWorkflowNodes() != null && workflow.getWorkflowNodes().size() > 0) {
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                if (node.getCustomProperties() == null || !node.getCustomProperties().containsKey("spec")) continue;
                NodeSingleSpec nodeSingleSpec = NodeSingleSpec.getNodeSingleSpec((String)((String)node.getCustomProperties().get("spec")));
                String nodeId = WorkflowConverter.findExistedNodeId4Mx(node, existedWorkflow.getNodes());
                if (nodeId != null) {
                    nodeSingleSpec.setId(nodeId);
                    node.setTNodeId(nodeId);
                }
                nodeSingleSpec.getScript().setContent(node.getScript());
                node.getCustomProperties().put("spec", NodeSingleSpec.getNodeSingleSpecJson((NodeSingleSpec)nodeSingleSpec).toJSONString(new JSONWriter.Feature[0]));
                spec.getNodes().add(nodeSingleSpec);
            }
        }
        workflow.getCustomProperties().put("spec", CycleWorkflowSingleSpec.getCycleWorkflowSingleSpecJson((CycleWorkflowSingleSpec)spec).toJSONString(new JSONWriter.Feature[0]));
        return spec;
    }

    public static String findExistedNodeId4Mx(WorkflowNode node, List<NodeSingleSpec> existedNodes) {
        if (existedNodes == null || existedNodes.size() == 0) {
            return null;
        }
        if (node.getNodeId() != null) {
            for (NodeSingleSpec existedNode : existedNodes) {
                if (existedNode.getId() == null || !existedNode.getId().equals(node.getNodeId())) continue;
                return existedNode.getId();
            }
        }
        if (node.getTNodeId() != null) {
            for (NodeSingleSpec existedNode : existedNodes) {
                if (existedNode.getId() == null || !existedNode.getId().equals(node.getTNodeId())) continue;
                return existedNode.getId();
            }
        }
        for (NodeSingleSpec existedNode : existedNodes) {
            if (existedNode.getOutputs() == null || existedNode.getOutputs().getNodeOutputs() == null || existedNode.getOutputs().getNodeOutputs().size() <= 0) continue;
            for (NodeOutputSpec output : existedNode.getOutputs().getNodeOutputs()) {
                if (!output.getData().endsWith("." + node.getNodeName()) || output.getData().length() != node.getWorkflowName().length() + node.getNodeName().length() + 1) continue;
                return existedNode.getId();
            }
        }
        return null;
    }

    public static String nameStandard(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return name.replaceAll("[^a-zA-Z0-9._\\u4e00-\\u9fa5]", "_");
    }

    public static String pathStandard(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return name.replaceAll("[^a-zA-Z0-9._/\\u4e00-\\u9fa5]", "_");
    }

    public static String cronSta(String orgCron) {
        if (StringUtils.isEmpty((CharSequence)orgCron)) {
            return "00 00 00 * * ?";
        }
        String cron = orgCron;
        String[] parts = (cron = cron.replaceAll("(?<!\\d)(\\d)(?!\\d)", "0$1")).split(" ", 7);
        if (parts.length > 6) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 6; ++i) {
                sb.append(parts[i]).append(" ");
            }
            cron = sb.toString().trim();
        }
        return cron;
    }
}

