/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.spec.domain.dataworks;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.spec.domain.dataworks.common.DependencyNodeSpec;
import com.aliyun.migration.spec.domain.dataworks.common.DependencySingleSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ScriptSpec;
import com.aliyun.migration.spec.domain.dataworks.common.StrategySpec;
import com.aliyun.migration.spec.domain.dataworks.common.TriggerSpec;
import com.aliyun.migration.spec.domain.dataworks.common.metadata.MetadataSpec;
import com.aliyun.migration.spec.domain.dataworks.common.output.OutputBatchSpec;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CycleWorkflowSingleSpec {
    private String id;
    private String name;
    private String owner;
    private String description;
    private ScriptSpec script;
    private TriggerSpec trigger;
    private StrategySpec strategy;
    private MetadataSpec metadata;
    private Boolean citable;
    private OutputBatchSpec inputs;
    private OutputBatchSpec outputs;
    private List<NodeSingleSpec> nodes;
    private List<DependencyNodeSpec> dependencies;

    public static CycleWorkflowSingleSpec getCycleWorkflowSingleSpec(String jsonStr) {
        CycleWorkflowSingleSpec cycleWorkflowSingleSpec = (CycleWorkflowSingleSpec)JSONObject.parseObject((String)jsonStr, CycleWorkflowSingleSpec.class);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        if (jsonObject.containsKey("nodes")) {
            cycleWorkflowSingleSpec.setNodes(new ArrayList<NodeSingleSpec>());
            ((JSONArray)jsonObject.get("nodes")).forEach(node -> cycleWorkflowSingleSpec.getNodes().add(NodeSingleSpec.getNodeSingleSpec(((JSONObject)node).toJSONString(new JSONWriter.Feature[0]))));
        }
        if (jsonObject.containsKey("inputs")) {
            cycleWorkflowSingleSpec.setInputs(OutputBatchSpec.getOutputBachSpec(((JSONObject)jsonObject.get("inputs")).toJSONString(new JSONWriter.Feature[0])));
        }
        if (jsonObject.containsKey("outputs")) {
            cycleWorkflowSingleSpec.setOutputs(OutputBatchSpec.getOutputBachSpec(((JSONObject)jsonObject.get("outputs")).toJSONString(new JSONWriter.Feature[0])));
        }
        return cycleWorkflowSingleSpec;
    }

    public static JSONObject getCycleWorkflowSingleSpecJson(CycleWorkflowSingleSpec cycleWorkflowSingleSpec) {
        List<DependencyNodeSpec> dependenciesfromInputs;
        JSONObject jsonObject = JSONObject.from((Object)cycleWorkflowSingleSpec);
        ArrayList<DependencyNodeSpec> dependenciesFromInputs = new ArrayList<DependencyNodeSpec>();
        if (!CollectionUtils.isEmpty(cycleWorkflowSingleSpec.getNodes())) {
            cycleWorkflowSingleSpec.getNodes().forEach(node -> {
                DependencyNodeSpec dependencyNodeSpec = new DependencyNodeSpec();
                dependencyNodeSpec.setNodeId(node.getId());
                dependencyNodeSpec.setDepends(new ArrayList<DependencySingleSpec>());
                if (!ObjectUtils.isEmpty((Object)node.getInputs()) && !CollectionUtils.isEmpty(node.getInputs().getNodeOutputs())) {
                    node.getInputs().getNodeOutputs().forEach(nodeOutput -> {
                        DependencySingleSpec dependencySingleSpec = new DependencySingleSpec();
                        dependencySingleSpec.setType("Normal");
                        dependencySingleSpec.setOutput(nodeOutput.getData());
                        dependencyNodeSpec.getDepends().add(dependencySingleSpec);
                    });
                }
                dependenciesFromInputs.add(dependencyNodeSpec);
                node.setInputs(null);
            });
        }
        if (!CollectionUtils.isEmpty(dependenciesfromInputs = CycleWorkflowSingleSpec.mergeDependenciesMain(dependenciesFromInputs, cycleWorkflowSingleSpec.getDependencies()))) {
            jsonObject.put((Object)"dependencies", (Object)JSONArray.from(dependenciesfromInputs));
        }
        if (!CollectionUtils.isEmpty(cycleWorkflowSingleSpec.getNodes())) {
            JSONArray nodesArray = new JSONArray();
            cycleWorkflowSingleSpec.getNodes().forEach(node -> nodesArray.add((Object)NodeSingleSpec.getNodeSingleSpecJson(node)));
            jsonObject.put((Object)"nodes", (Object)nodesArray);
        }
        if (cycleWorkflowSingleSpec.getInputs() != null) {
            jsonObject.put((Object)"inputs", (Object)OutputBatchSpec.getOutputBachSpecJson(cycleWorkflowSingleSpec.getInputs()));
        } else {
            jsonObject.put((Object)"inputs", (Object)new JSONObject());
        }
        if (cycleWorkflowSingleSpec.getOutputs() != null) {
            jsonObject.put((Object)"outputs", (Object)OutputBatchSpec.getOutputBachSpecJson(cycleWorkflowSingleSpec.getOutputs()));
        } else {
            jsonObject.put((Object)"outputs", (Object)new JSONObject());
        }
        return jsonObject;
    }

    public static List<DependencyNodeSpec> mergeDependenciesMain(List<DependencyNodeSpec> mainDependencies, List<DependencyNodeSpec> subDependencies) {
        if (CollectionUtils.isEmpty(mainDependencies)) {
            return subDependencies;
        }
        if (CollectionUtils.isEmpty(subDependencies)) {
            return mainDependencies;
        }
        for (DependencyNodeSpec subDependency : subDependencies) {
            boolean isExist = false;
            for (DependencyNodeSpec mainDependency : mainDependencies) {
                if (!subDependency.getNodeId().equals(mainDependency.getNodeId())) continue;
                isExist = true;
                mainDependency.setDepends(CycleWorkflowSingleSpec.mergeDependencies(mainDependency.getDepends(), subDependency.getDepends()));
                break;
            }
            if (isExist) continue;
            mainDependencies.add(subDependency);
        }
        return mainDependencies;
    }

    public static List<DependencySingleSpec> mergeDependencies(List<DependencySingleSpec> mainDependencies, List<DependencySingleSpec> subDependencies) {
        if (CollectionUtils.isEmpty(mainDependencies)) {
            return subDependencies;
        }
        if (CollectionUtils.isEmpty(subDependencies)) {
            return mainDependencies;
        }
        for (DependencySingleSpec subDependency : subDependencies) {
            boolean isExist = false;
            for (DependencySingleSpec mainDependency : mainDependencies) {
                if (!subDependency.getOutput().equals(mainDependency.getOutput())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            mainDependencies.add(subDependency);
        }
        return mainDependencies;
    }

    public static Workflow getWorkflow(CycleWorkflowSingleSpec cycleWorkflowSingleSpec) {
        Workflow workflow = new Workflow();
        workflow.setWorkflowId(cycleWorkflowSingleSpec.getId());
        workflow.setWorkflowName(cycleWorkflowSingleSpec.getName());
        workflow.setOwner(cycleWorkflowSingleSpec.getOwner());
        workflow.setDescription(cycleWorkflowSingleSpec.getDescription());
        workflow.setCategoryValue(cycleWorkflowSingleSpec.getScript().getPath());
        if (cycleWorkflowSingleSpec.getScript().getParameters() != null && !cycleWorkflowSingleSpec.getScript().getParameters().isEmpty()) {
            workflow.setParamMap(new HashMap());
            cycleWorkflowSingleSpec.getScript().getParameters().forEach(parameter -> workflow.getParamMap().put(parameter.getName(), parameter.getValue()));
        }
        WorkflowTrigger workflowTrigger = new WorkflowTrigger();
        if (cycleWorkflowSingleSpec.getTrigger() != null) {
            if (cycleWorkflowSingleSpec.getTrigger().getCron() != null) {
                workflowTrigger.setCron(cycleWorkflowSingleSpec.getTrigger().getCron());
            }
            if (cycleWorkflowSingleSpec.getTrigger().getStartTime() != null) {
                workflowTrigger.setStartTime(LocalDateTime.parse(cycleWorkflowSingleSpec.getTrigger().getStartTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            if (cycleWorkflowSingleSpec.getTrigger().getEndTime() != null) {
                workflowTrigger.setEndTime(LocalDateTime.parse(cycleWorkflowSingleSpec.getTrigger().getEndTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            if (cycleWorkflowSingleSpec.getTrigger().getTimezone() != null) {
                workflowTrigger.setTimezone(ZoneId.of(cycleWorkflowSingleSpec.getTrigger().getTimezone()));
            }
        }
        workflowTrigger.setWorkflowName(cycleWorkflowSingleSpec.getName());
        workflowTrigger.setWorkflowId(cycleWorkflowSingleSpec.getId());
        workflow.setTriggers(List.of(workflowTrigger));
        workflow.setCustomProperties(new HashMap());
        if (cycleWorkflowSingleSpec.getMetadata() != null) {
            workflow.getCustomProperties().put("di.resource.group.identifier", cycleWorkflowSingleSpec.getMetadata().getProject().getDefaultSchedulerResourceGroupIdentifier());
            workflow.getCustomProperties().put("resource.group.identifier", cycleWorkflowSingleSpec.getMetadata().getProject().getDefaultDiResourceGroupIdentifier());
            if (cycleWorkflowSingleSpec.getStrategy().getInstanceMode() != null) {
                switch (cycleWorkflowSingleSpec.getStrategy().getInstanceMode()) {
                    case "T+1": {
                        workflow.getCustomProperties().put("instance.mode", WorkflowNode.InstanceMode.T_PLUS_1.name());
                        break;
                    }
                    case "Immediately": {
                        workflow.getCustomProperties().put("instance.mode", WorkflowNode.InstanceMode.IMMEDIATELY.name());
                    }
                }
            }
        }
        workflow.setWorkflowNodes(new ArrayList());
        if (cycleWorkflowSingleSpec.getNodes() != null && cycleWorkflowSingleSpec.getNodes().size() > 0) {
            cycleWorkflowSingleSpec.getNodes().forEach(node -> {
                WorkflowNode workflowNode = NodeSingleSpec.getWorkflowNode(node);
                workflowNode.setWorkflowId(cycleWorkflowSingleSpec.getId());
                workflowNode.setWorkflowName(cycleWorkflowSingleSpec.getName());
                workflow.getWorkflowNodes().add(workflowNode);
            });
        }
        cycleWorkflowSingleSpec.getOutputs().getNodeOutputs().forEach(nodeOutput -> {
            if (nodeOutput.getData().endsWith("_out")) {
                workflow.getCustomProperties().put("MigrationOriginalId", nodeOutput.getData().substring(nodeOutput.getData().indexOf(".") + 1, nodeOutput.getData().length() - 4));
            }
        });
        return workflow;
    }

    public static List<Workflow> getWorkflowList(List<CycleWorkflowSingleSpec> wfSpecList) {
        ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
        HashMap mxWfOutputIdMap = new HashMap();
        HashMap mxNodeOutputIdMap = new HashMap();
        for (CycleWorkflowSingleSpec wfSpec : wfSpecList) {
            wfSpec.getOutputs().getNodeOutputs().forEach(nodeOutput -> mxWfOutputIdMap.put(nodeOutput.getData(), wfSpec.getId()));
            for (NodeSingleSpec nodeSpec : wfSpec.getNodes()) {
                if (nodeSpec.getOutputs() == null || nodeSpec.getOutputs().getNodeOutputs() == null || nodeSpec.getOutputs().getNodeOutputs().isEmpty()) continue;
                nodeSpec.getOutputs().getNodeOutputs().forEach(nodeOutput -> mxNodeOutputIdMap.put(nodeOutput.getData(), nodeSpec.getId()));
            }
        }
        for (CycleWorkflowSingleSpec wfSpec : wfSpecList) {
            Workflow wf = CycleWorkflowSingleSpec.getWorkflow(wfSpec);
            wf.setNodeRelations(new ArrayList());
            for (DependencyNodeSpec dependSpec : wfSpec.getDependencies()) {
                String targetId = dependSpec.getNodeId();
                dependSpec.getDepends().forEach(depend -> {
                    if (mxWfOutputIdMap.containsKey(depend.getOutput())) {
                        String sourceId = (String)mxWfOutputIdMap.get(depend.getOutput());
                        RelationPackage relationPackage = new RelationPackage();
                        relationPackage.setFrom(sourceId);
                        relationPackage.setTo(targetId);
                        relationPackage.setReType(RelationPackage.ReType.WORKFLOW_NODE);
                        wf.getNodeRelations().add(relationPackage);
                    } else if (mxNodeOutputIdMap.containsKey(depend.getOutput())) {
                        String sourceId = (String)mxNodeOutputIdMap.get(depend.getOutput());
                        RelationPackage relationPackage = new RelationPackage();
                        relationPackage.setFrom(sourceId);
                        relationPackage.setTo(targetId);
                        relationPackage.setReType(RelationPackage.ReType.NODE);
                        wf.getNodeRelations().add(relationPackage);
                    }
                });
            }
            workflowList.add(wf);
        }
        return workflowList;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScript(ScriptSpec script) {
        this.script = script;
    }

    public void setTrigger(TriggerSpec trigger) {
        this.trigger = trigger;
    }

    public void setStrategy(StrategySpec strategy) {
        this.strategy = strategy;
    }

    public void setMetadata(MetadataSpec metadata) {
        this.metadata = metadata;
    }

    public void setCitable(Boolean citable) {
        this.citable = citable;
    }

    public void setInputs(OutputBatchSpec inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(OutputBatchSpec outputs) {
        this.outputs = outputs;
    }

    public void setNodes(List<NodeSingleSpec> nodes) {
        this.nodes = nodes;
    }

    public void setDependencies(List<DependencyNodeSpec> dependencies) {
        this.dependencies = dependencies;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public ScriptSpec getScript() {
        return this.script;
    }

    public TriggerSpec getTrigger() {
        return this.trigger;
    }

    public StrategySpec getStrategy() {
        return this.strategy;
    }

    public MetadataSpec getMetadata() {
        return this.metadata;
    }

    public Boolean getCitable() {
        return this.citable;
    }

    public OutputBatchSpec getInputs() {
        return this.inputs;
    }

    public OutputBatchSpec getOutputs() {
        return this.outputs;
    }

    public List<NodeSingleSpec> getNodes() {
        return this.nodes;
    }

    public List<DependencyNodeSpec> getDependencies() {
        return this.dependencies;
    }
}

