/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util.crypto;

public class Base62 {
    private static final byte[] NULL = new byte[0];
    private static byte[] encTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte[] decTable = new byte[256];

    public static byte[] encode(byte[] data) {
        if (data == null || data.length == 0) {
            return NULL;
        }
        byte[] tmp = new byte[data.length * 2 + 8];
        int pos = 0;
        int val = 0;
        int off = 0;
        for (int i = 0; i < data.length; ++i) {
            val = val << 8 | data[i] & 0xFF;
            pos += 8;
            while (pos > 5) {
                byte b = encTable[val >> (pos -= 6)];
                if (b == 105) {
                    tmp[off++] = 105;
                    tmp[off++] = 97;
                } else if (b == 43) {
                    tmp[off++] = 105;
                    tmp[off++] = 98;
                } else if (b == 47) {
                    tmp[off++] = 105;
                    tmp[off++] = 99;
                } else {
                    tmp[off++] = b;
                }
                val &= (1 << pos) - 1;
            }
        }
        if (pos > 0) {
            byte b = encTable[val << 6 - pos];
            if (b == 105) {
                tmp[off++] = 105;
                tmp[off++] = 97;
            } else if (b == 43) {
                tmp[off++] = 105;
                tmp[off++] = 98;
            } else if (b == 47) {
                tmp[off++] = 105;
                tmp[off++] = 99;
            } else {
                tmp[off++] = b;
            }
            if (pos == 2) {
                tmp[off++] = 61;
                tmp[off++] = 61;
            } else if (pos == 4) {
                tmp[off++] = 61;
            }
        }
        byte[] rt = new byte[off];
        System.arraycopy(tmp, 0, rt, 0, off);
        return rt;
    }

    public static String encode(String url) {
        if (url == null) {
            return null;
        }
        return new String(Base62.encode(url.getBytes()));
    }

    public static byte[] decode(byte[] data) {
        byte b;
        if (data == null || data.length == 0) {
            return NULL;
        }
        byte[] tmp = new byte[data.length];
        int offset = 0;
        int pos = 0;
        int val = 0;
        for (int i = 0; i < data.length && (b = data[i]) != 61; ++i) {
            if (b == 105) {
                b = (byte)((b = data[++i]) == 97 ? 105 : (b == 98 ? 43 : (b == 99 ? 47 : data[--i])));
            }
            val = val << 6 | decTable[b];
            pos += 6;
            while (pos > 7) {
                tmp[offset++] = (byte)(val >> (pos -= 8));
                val &= (1 << pos) - 1;
            }
        }
        byte[] rt = new byte[offset];
        System.arraycopy(tmp, 0, rt, 0, offset);
        return rt;
    }

    public static String decode(String src) {
        if (src == null) {
            return null;
        }
        return new String(Base62.decode(src.getBytes()));
    }

    static {
        for (int i = 0; i < encTable.length; ++i) {
            Base62.decTable[Base62.encTable[i]] = (byte)i;
        }
    }
}

