/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util.asapi;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public interface Encoder {
    public String canonicalize(String var1);

    public String encodeForCSS(String var1);

    public String decodeFromCSS(String var1);

    public String encodeForHTML(String var1);

    public String decodeFromHTML(String var1);

    public String encodeForHTMLAttribute(String var1);

    public String encodeForJavaScript(String var1);

    public String encodeForJSON(String var1);

    public String decodeFromJSON(String var1);

    public String decodeFromJavaScript(String var1);

    public String encodeForXML(String var1);

    public String encodeForXMLAttribute(String var1);

    public String encodeForURL(String var1, String var2) throws UnsupportedEncodingException;

    public String decodeFromURL(String var1, String var2) throws UnsupportedEncodingException;

    public String encodeForBase64(byte[] var1);

    public byte[] decodeFromBase64(String var1);

    public String encodeForBase62(String var1);

    public String decodeFromBase62(String var1);

    public static class EncoderConstants {
        public static final char[] CHAR_PASSWORD_SPECIALS = new char[]{'!', '$', '*', '-', '.', '=', '?', '@', '_'};
        public static final Set<Character> PASSWORD_SPECIALS = EncoderConstants.arrayToSet(CHAR_PASSWORD_SPECIALS);
        public static final char[] CHAR_LOWERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        public static final Set<Character> LOWERS = EncoderConstants.arrayToSet(CHAR_PASSWORD_SPECIALS);
        public static final char[] CHAR_UPPERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        public static final Set<Character> UPPERS = EncoderConstants.arrayToSet(CHAR_UPPERS);
        public static final char[] CHAR_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        public static final Set<Character> DIGITS = EncoderConstants.arrayToSet(CHAR_DIGITS);
        public static final char[] CHAR_SPECIALS = new char[]{'!', '$', '*', '+', '-', '.', '=', '?', '@', '^', '_', '|', '~'};
        public static final Set<Character> SPECIALS = EncoderConstants.arrayToSet(CHAR_SPECIALS);
        public static final char[] CHAR_LETTERS = EncoderConstants.union(CHAR_LOWERS, CHAR_UPPERS);
        public static final Set<Character> LETTERS = EncoderConstants.arrayToSet(CHAR_LETTERS);
        public static final char[] CHAR_ALPHANUMERICS = EncoderConstants.union(CHAR_LETTERS, CHAR_DIGITS);
        public static final Set<Character> ALPHANUMERICS = EncoderConstants.arrayToSet(CHAR_ALPHANUMERICS);
        public static final char[] CHAR_PASSWORD_LOWERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        public static final Set<Character> PASSWORD_LOWERS = EncoderConstants.arrayToSet(CHAR_ALPHANUMERICS);
        public static final char[] CHAR_PASSWORD_UPPERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        public static final Set<Character> PASSWORD_UPPERS = EncoderConstants.arrayToSet(CHAR_PASSWORD_UPPERS);
        public static final char[] CHAR_PASSWORD_DIGITS = new char[]{'2', '3', '4', '5', '6', '7', '8', '9'};
        public static final Set<Character> PASSWORD_DIGITS = EncoderConstants.arrayToSet(CHAR_PASSWORD_DIGITS);
        public static final char[] CHAR_PASSWORD_LETTERS = EncoderConstants.union(CHAR_PASSWORD_LOWERS, CHAR_PASSWORD_UPPERS);
        public static final Set<Character> PASSWORD_LETTERS = EncoderConstants.arrayToSet(CHAR_PASSWORD_LETTERS);

        private static Set<Character> arrayToSet(char[] array) {
            if (array == null) {
                return new HashSet<Character>();
            }
            HashSet<Character> toReturn = new HashSet<Character>(array.length);
            for (char c : array) {
                toReturn.add(Character.valueOf(c));
            }
            return toReturn;
        }

        private static char[] union(char[] ... list) {
            byte[] quick = new byte[256];
            HashSet<Character> set = new HashSet<Character>();
            int len = 0;
            int off = 0;
            char[][] cArray = list;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                char[] characters;
                for (char c : characters = cArray[i]) {
                    if (c < '\u0100') {
                        if (quick[c] != 0) continue;
                        quick[c] = 1;
                        ++len;
                        continue;
                    }
                    if (set.contains(Character.valueOf(c))) continue;
                    set.add(Character.valueOf(c));
                    ++len;
                }
            }
            char[] tmp = new char[len];
            for (int i = 0; i < quick.length; ++i) {
                if (quick[i] != 1) continue;
                tmp[off++] = (char)i;
            }
            if (off == len) {
                return tmp;
            }
            for (Character c : set) {
                tmp[off++] = c.charValue();
            }
            Arrays.sort(tmp);
            return tmp;
        }
    }
}

