/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util;

import com.aliyun.securitysdk.util.SpringBootCompatibleTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceUtil {
    private static final Logger logger = Logger.getLogger(ResourceUtil.class.getName());
    private static final String PATH_FORMAT = "/%s";

    public static URL getClassUrl(String clazz) {
        Class<?> cls = ResourceUtil.getClass(clazz);
        return cls == null ? null : cls.getProtectionDomain().getCodeSource().getLocation();
    }

    public static InputStream getResourceInputSteam(String resoucePath, Class<?> clazz) {
        return ResourceUtil.getResourceInputSteam(resoucePath, clazz, false);
    }

    public static InputStream getResourceInputSteam(String resoucePath, Class<?> clazz, boolean readFromJar) {
        InputStream is = null;
        if (readFromJar) {
            is = ResourceUtil.getResourceInputStreamQuietly("com.aliyun.securitysdk.resource.ResourceAnchor", clazz, resoucePath);
        }
        if (!readFromJar || is == null) {
            is = clazz.getResourceAsStream(resoucePath);
        }
        return is;
    }

    public static InputStream getResourceInputStreamQuietly(String anchor, Class<?> clazz, String resourcePath) {
        try {
            return ResourceUtil.getResourceInputStream(anchor, clazz, resourcePath);
        }
        catch (Exception e) {
            Class<?> anchorClass = ResourceUtil.getClass(anchor);
            if (anchorClass != null && SpringBootCompatibleTool.isSpringBootApplicationPresentPresent()) {
                return ResourceUtil.getResourceInputStream(clazz, resourcePath);
            }
            logger.log(Level.WARNING, "Cannot get the resource input stream.", e);
            return null;
        }
    }

    public static InputStream getResourceInputStream(String anchor, Class<?> clazz, String resourcePath) throws IOException {
        File file;
        if (anchor == null || clazz == null || resourcePath == null) {
            return null;
        }
        InputStream inputStream = null;
        URL url = ResourceUtil.getClassUrl(anchor);
        if (url != null && !(file = new File(url.getFile())).isDirectory()) {
            String decode = URLDecoder.decode(url.getFile(), "utf-8");
            JarFile jarFile = new JarFile(decode);
            JarEntry jarEntry = jarFile.getJarEntry(resourcePath);
            inputStream = jarFile.getInputStream(jarEntry);
        }
        if (inputStream == null) {
            inputStream = ResourceUtil.getResourceInputStream(clazz, resourcePath);
        }
        return inputStream;
    }

    private static InputStream getResourceInputStream(Class<?> clazz, String resourcePath) {
        return clazz.getResourceAsStream(String.format(PATH_FORMAT, resourcePath));
    }

    public static InputStream getDefaultConfigInputStream() {
        return ResourceUtil.class.getClassLoader().getResourceAsStream("application.properties");
    }

    private static Class<?> getClass(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

