/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.interceptor;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.SecurityUtil;
import com.aliyun.securitysdk.url.SSRFChecker;
import com.aliyun.securitysdk.url.exception.GlobalSSRFThrowableFactory;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.InetAddress;

public class OkHttpInterceptor
implements Interceptor {
    private static final Logger logger = SecurityLogManager.getLogger(OkHttpInterceptor.class);
    private static final SSRFChecker ssrfChecker = SecurityUtil.getSSRFCheckerSingleton();
    public static final OkHttpInterceptor INSTANCE = new OkHttpInterceptor();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String url = chain.request().url().toString();
        if (!ssrfChecker.checkUrlWithoutConnection(url, true)) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(chain.request().url().getHost());
            }
            catch (Exception e) {
                logger.info("get name error", (Throwable)e);
            }
            logger.warn("ssrf attack, url: {}, address: {}", (Object)url, (Object)address);
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("unsafe url: " + url, address);
        }
        ssrfChecker.startNetHookWithExpirationCache(url);
        return chain.proceed(chain.request());
    }
}

