/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.interceptor;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.SecurityUtil;
import com.aliyun.securitysdk.url.SSRFChecker;
import com.aliyun.securitysdk.url.exception.GlobalSSRFThrowableFactory;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

public class HttpClientInterceptor
implements HttpRequestInterceptor {
    private static final Logger logger = SecurityLogManager.getLogger(HttpClientInterceptor.class);
    private final SSRFChecker ssrfChecker = SecurityUtil.getSSRFCheckerSingleton();
    public static final HttpClientInterceptor INSTANCE = new HttpClientInterceptor();

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpHost host = HttpCoreContext.adapt((HttpContext)httpContext).getTargetHost();
        String url = host.toURI();
        if (!this.ssrfChecker.checkUrlWithoutConnection(url, true)) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(host.getHostName());
            }
            catch (Exception e) {
                logger.info("get name error", (Throwable)e);
            }
            logger.warn("ssrf attack, url: {}, address: {}", (Object)url, (Object)address);
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("unsafe url: " + host.toURI(), address);
        }
        this.ssrfChecker.startNetHookWithExpirationCache(url);
    }
}

