/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.sensitive.matcher;

import com.aliyun.securitysdk.sensitive.entity.SensitiveRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexUtil {
    public static final List<String> DEFAULT_DELIMITERS = Collections.unmodifiableList(Arrays.asList(">", ":", "\uff1a", "="));
    public static final String TAILS = "[\\s]*[\\\\]*[\"']?[\\s]*";

    private static List<String> regexClosure(List<String> items) {
        ArrayList<String> closedValues = new ArrayList<String>();
        for (String value : items) {
            closedValues.add(String.format("(%s)", value));
        }
        return closedValues;
    }

    public static Pattern getRegexPattern(SensitiveRule rule) {
        List<String> keyWords = rule.getKeyword();
        List<String> values = rule.getValue();
        List<String> Delimiters = rule.getDelimiters();
        if (Delimiters == null || Delimiters.isEmpty()) {
            Delimiters = DEFAULT_DELIMITERS;
        }
        List<String> closedValues = RegexUtil.regexClosure(values);
        String regex = null;
        if (keyWords == null || keyWords.isEmpty()) {
            regex = String.format("(?<value>%s)", StringUtils.join(closedValues, (String)"|"));
        } else {
            List<String> closedKeywords = RegexUtil.regexClosure(keyWords);
            regex = String.format("(?<keyword>%s)(?<head>%s)(?<delimiter>%s)(?<tail>%s)(?<value>%s)(?=[^A-Za-z0-9]|\\b)", StringUtils.join(closedKeywords, (String)"|"), TAILS, StringUtils.join(Delimiters, (String)"|"), TAILS, StringUtils.join(closedValues, (String)"|"));
        }
        return Pattern.compile(regex, 2);
    }

    public static Pattern getKeywordPattern(SensitiveRule rule) {
        List<String> keywords = rule.getKeyword();
        if (keywords == null || keywords.isEmpty()) {
            return null;
        }
        List<String> closedKeywords = RegexUtil.regexClosure(keywords);
        return Pattern.compile(String.format("(?<keyword>%s)", StringUtils.join(closedKeywords, (String)"|")), 2);
    }

    public static Pattern getWhiteKeywordPattern(SensitiveRule rule) {
        Map<String, List<String>> whiteRegex = rule.getWhiteRegex();
        if (whiteRegex == null || whiteRegex.isEmpty()) {
            return null;
        }
        List<String> keywords = whiteRegex.get("keyword");
        if (keywords == null || keywords.isEmpty()) {
            return null;
        }
        List<String> closedKeywords = RegexUtil.regexClosure(keywords);
        return Pattern.compile(String.format("(?<keyword>%s)", StringUtils.join(closedKeywords, (String)"|")), 2);
    }

    public static Pattern getValuePattern(SensitiveRule rule) {
        List<String> values = rule.getValue();
        if (values == null || values.isEmpty()) {
            return null;
        }
        List<String> closedValues = RegexUtil.regexClosure(values);
        return Pattern.compile(String.format("(?<value>%s)", StringUtils.join(closedValues, (String)"|")), 2);
    }

    public static Pattern getWhiteValuePattern(SensitiveRule rule) {
        Map<String, List<String>> whiteRegex = rule.getWhiteRegex();
        if (whiteRegex == null || whiteRegex.isEmpty()) {
            return null;
        }
        List<String> values = whiteRegex.get("value");
        if (values == null || values.isEmpty()) {
            return null;
        }
        List<String> closedValues = RegexUtil.regexClosure(values);
        return Pattern.compile(String.format("(?<value>%s)", StringUtils.join(closedValues, (String)"|")), 2);
    }

    public static boolean isItemMatchPattern(String item, Pattern pattern) {
        if (item == null || pattern == null) {
            return false;
        }
        return pattern.matcher(item).find();
    }
}

