/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.ql;

import com.aliyun.securitysdk.ql.SLSQueryException;
import com.aliyun.securitysdk.ql.SLSQueryTokenizer;

public class BracketChecker {
    private final String query;
    private final SLSQueryTokenizer tokenizer;
    private int parenCount = 0;

    public BracketChecker(String query) {
        this.query = query;
        this.tokenizer = new SLSQueryTokenizer(query);
    }

    public void checkWhetherBracketMatches() throws SLSQueryException {
        while (this.tokenizer.hasMoreTokens()) {
            String token = this.tokenizer.nextToken();
            if ("(".equals(token)) {
                ++this.parenCount;
                continue;
            }
            if (")".equals(token)) {
                --this.parenCount;
                if (this.parenCount >= 0) continue;
                throw new SLSQueryException("parentheses not match");
            }
            if (!"|".equals(token)) continue;
            throw new SLSQueryException("| not supported here");
        }
        if (this.parenCount != 0) {
            throw new SLSQueryException("parentheses not match");
        }
    }
}

