/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask.model.guest;

import com.aliyun.securitysdk.mask.DataType;
import com.aliyun.securitysdk.mask.model.guest.AbstractGuestMaskModel;
import com.aliyun.securitysdk.util.CharUtil;
import com.aliyun.securitysdk.util.SensitiveDataUtil;

public class NameGuestMaskModel
extends AbstractGuestMaskModel {
    @Override
    public DataType getDataType() {
        return DataType.Name;
    }

    @Override
    public String doMask(String input) {
        if (CharUtil.hasChineseCharacter(input)) {
            return this.maskChinese(input);
        }
        if (CharUtil.isEnglishString(input)) {
            return this.maskEnglish(input);
        }
        return SensitiveDataUtil.customizeIntraMark(input, 3);
    }

    protected String maskChinese(String name) {
        if (name.length() == 1) {
            return "*";
        }
        if (name.length() >= 5) {
            return "****" + name.charAt(name.length() - 1);
        }
        return SensitiveDataUtil.customizeIntraMark(name, 0, 1, ' ');
    }

    protected String maskEnglish(String name) {
        int lastSpace = name.lastIndexOf(32);
        if (lastSpace == -1) {
            return SensitiveDataUtil.customizeIntraMark(name);
        }
        if (lastSpace == name.length() - 1) {
            return this.maskEnglish(name.trim());
        }
        String lastName = name.substring(lastSpace + 1);
        if (this.isSuffix(lastName)) {
            name = name.substring(0, lastSpace);
            return this.maskEnglishWithoutSuffix(name) + " " + lastName;
        }
        return this.maskEnglishWithoutSuffix(name);
    }

    private String maskEnglishWithoutSuffix(String name) {
        int lastSpace = name.lastIndexOf(32);
        if (lastSpace == -1) {
            return SensitiveDataUtil.customizeIntraMark(name);
        }
        if (lastSpace == name.length() - 1) {
            return this.maskEnglishWithoutSuffix(name.trim());
        }
        StringBuilder sb = new StringBuilder(name.length());
        int i = 0;
        int nameCount = 0;
        while (i < lastSpace) {
            sb.append(name.charAt(i)).append('.').append(' ');
            ++i;
            if (++nameCount >= 3) break;
            while (i < lastSpace && name.charAt(i) != ' ') {
                ++i;
            }
            ++i;
            while (i < lastSpace && name.charAt(i) == ' ') {
                ++i;
            }
        }
        sb.append(name.substring(lastSpace + 1));
        return sb.toString();
    }

    private boolean isSuffix(String name) {
        if (name.length() > 4) {
            return false;
        }
        if (name.equals("Jr.") || name.equals("Sr.") || name.equals("Jnr") || name.equals("Snr")) {
            return true;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == 'I' || c == 'V' || c == 'X') continue;
            return false;
        }
        return true;
    }
}

