/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask.division;

import com.aliyun.securitysdk.division.CainiaoAreaNormalizer;
import com.aliyun.securitysdk.mask.division.AreaNormalizer;
import com.aliyun.securitysdk.util.IOUtils;
import com.aliyun.securitysdk.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CainiaoAreaNormalizerFactory {
    private static final Logger logger = Logger.getLogger(CainiaoAreaNormalizerFactory.class.getName());
    private static boolean production = false;

    static void setupProduction(InputStream is) {
        try {
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
                production = "true".equalsIgnoreCase(props.getProperty("security.mask.cainiao.division.production.enable", "false").trim());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load the cainiao division service production property.");
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static AreaNormalizer createAreaNormalizer() {
        return new CainiaoAreaNormalizer(production);
    }

    static {
        CainiaoAreaNormalizerFactory.setupProduction(ResourceUtil.getDefaultConfigInputStream());
    }
}

