/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.mask.DataType;
import com.aliyun.securitysdk.mask.Scenario;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MaskLogger {
    private static final Logger logger = SecurityLogManager.getLogger(MaskLogger.class);
    private static final ConcurrentHashMap<Integer, AtomicInteger> maskStatics = new ConcurrentHashMap();
    private static Timer timer;
    private static volatile boolean initialized;
    private static String appName;

    private static void initialize() {
        appName = System.getProperty("project.name");
        if (appName == null || appName.isEmpty()) {
            appName = "noName";
        }
        timer = new Timer("rass-sdk-MaskLogger", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MaskLogger.flush();
            }
        }, 3600000L, 3600000L);
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void logUsage(DataType dataType, Scenario scenario) {
        if (!initialized) {
            Class<MaskLogger> clazz = MaskLogger.class;
            // MONITORENTER : com.aliyun.securitysdk.mask.MaskLogger.class
            if (!initialized) {
                MaskLogger.initialize();
            }
            // MONITOREXIT : clazz
        }
        int index = dataType.getIndex() * 10 + scenario.getIndex();
        maskStatics.putIfAbsent(index, new AtomicInteger(0));
        AtomicInteger v = maskStatics.get(index);
        v.incrementAndGet();
    }

    public static void flush() {
        StringBuilder logContent = new StringBuilder();
        logContent.append("maskData usage ").append(appName).append(",");
        boolean hasData = false;
        for (Map.Entry<Integer, AtomicInteger> entry : maskStatics.entrySet()) {
            int index = entry.getKey();
            AtomicInteger v = entry.getValue();
            int count = v.get();
            v.set(0);
            if (count <= 0) continue;
            hasData = true;
            int dataTypeIndex = index / 10;
            int scenarioIndex = index % 10;
            DataType dataType = DataType.getByIndex((int)dataTypeIndex);
            Scenario scenario = Scenario.getByIndex((int)scenarioIndex);
            logContent.append(dataType.getName()).append('-').append(scenario.getName()).append(':').append(count).append(';');
        }
        if (hasData) {
            logger.info((CharSequence)logContent);
        }
    }

    static {
        initialized = false;
        appName = null;
    }
}

