/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask;

import com.aliyun.securitysdk.mask.DataMaskConfiguration;
import com.aliyun.securitysdk.mask.DataMaskingTool;
import com.aliyun.securitysdk.mask.DataType;
import com.aliyun.securitysdk.mask.MaskLogger;
import com.aliyun.securitysdk.mask.MaskModel;
import com.aliyun.securitysdk.mask.Scenario;
import com.aliyun.securitysdk.mask.exception.CompleteTextNotAllowedException;
import com.aliyun.securitysdk.mask.exception.ValidationNotSupportedException;
import com.aliyun.securitysdk.mask.model.auth.AddressAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.CnMobilePhoneSMSAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.CnMobilePhoneWebAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.CompanyNameAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.DebitCardAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.DefaultAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.DefaultSMSAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.EmailAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.EmailSMSAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.EmailWebAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.EngineNumberAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.IDCardNoAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.IDCardOverseaAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.IMEIAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.IPMACAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.NameAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.NickNameAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.NickNameSMSAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.NumberPlateAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.OverseaMobilePhoneSMSAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.OverseaMobilePhoneWebAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.PhoneAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.PostcodeAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.QuanxiEmailAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.QuanxiSubjectAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.USCCAuthMaskModel;
import com.aliyun.securitysdk.mask.model.auth.VINAuthMaskModel;
import com.aliyun.securitysdk.mask.model.guest.AddressGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.CnMobilePhoneSMSGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.CnMobilePhoneWebGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.CompanyNameGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.DebitCardGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.DefaultGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.DefaultSMSGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.EmailGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.EmailSMSGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.EmailWebGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.EngineNumberGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.IDCardNoGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.IDCardOverseaGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.IMEIGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.IPMACGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.NameGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.NickNameGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.NickNameSMSGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.NumberPlateGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.OverseaMobilePhoneSMSGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.OverseaMobilePhoneWebGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.PhoneGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.PostcodeGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.QuanxiEmailGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.QuanxiSubjectGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.USCCGuestMaskModel;
import com.aliyun.securitysdk.mask.model.guest.VINGuestMaskModel;
import com.aliyun.securitysdk.mask.model.login.AddressLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.CnMobilePhoneSMSLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.CnMobilePhoneWebLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.CompanyNameLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.DebitCardLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.DefaultLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.DefaultSMSLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.EmailLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.EmailSMSLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.EmailWebLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.EngineNumberLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.IDCardNoLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.IDCardOverseaLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.IMEILoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.IPMACLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.NameLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.NickNameLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.NickNameSMSLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.NumberPlateLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.OverseaMobilePhoneSMSLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.OverseaMobilePhoneWebLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.PhoneLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.PostcodeLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.QuanxiEmailLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.QuanxiSubjectLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.USCCLoginMaskModel;
import com.aliyun.securitysdk.mask.model.login.VINLoginMaskModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataMaskingToolImpl
implements DataMaskingTool {
    private static final Map<Integer, MaskModel> modelMap;
    private static Map<Integer, MaskModel> theModelMap;

    private static void registerModel(MaskModel maskModel) {
        int index = DataMaskingToolImpl.getIndex(maskModel.getDataType(), maskModel.getScenario());
        theModelMap.put(index, maskModel);
        if (maskModel.getScenario() == Scenario.Guest) {
            index = DataMaskingToolImpl.getIndex(maskModel.getDataType(), Scenario.Log);
            theModelMap.put(index, maskModel);
        }
    }

    private static int getIndex(DataType dataType, Scenario scenario) {
        return dataType.getIndex() * 10 + scenario.getIndex();
    }

    private static boolean isValid(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    private MaskModel getModel(DataType dataType, Scenario scenario) {
        return modelMap.get(DataMaskingToolImpl.getIndex(dataType, scenario));
    }

    public String mask(DataType dataType, Scenario scenario, String data) {
        if (!DataMaskingToolImpl.isValid(dataType, scenario, data)) {
            return null;
        }
        MaskLogger.logUsage(dataType, scenario);
        MaskModel model = this.getModel(dataType, scenario);
        if (model != null) {
            return model.mask(data);
        }
        return null;
    }

    public String mask(DataType dataType, Scenario scenario, String data, boolean full) throws CompleteTextNotAllowedException {
        if (!DataMaskingToolImpl.isValid(dataType, scenario, data)) {
            return null;
        }
        MaskLogger.logUsage(dataType, scenario);
        MaskModel model = this.getModel(dataType, scenario);
        if (model != null) {
            return model.mask(data, full);
        }
        return null;
    }

    public String mask(String data, DataMaskConfiguration configuration) throws CompleteTextNotAllowedException, ValidationNotSupportedException {
        if (!DataMaskingToolImpl.isValid(configuration, data)) {
            return null;
        }
        if (!DataMaskingToolImpl.isValid(configuration.getDataType(), configuration.getScenario())) {
            return null;
        }
        MaskLogger.logUsage(configuration.getDataType(), configuration.getScenario());
        MaskModel model = this.getModel(configuration.getDataType(), configuration.getScenario());
        if (model != null) {
            return model.mask(data, configuration.canFull());
        }
        return null;
    }

    static {
        theModelMap = new HashMap<Integer, MaskModel>();
        DataMaskingToolImpl.registerModel(new NickNameGuestMaskModel());
        DataMaskingToolImpl.registerModel(new NickNameLoginMaskModel());
        DataMaskingToolImpl.registerModel(new NickNameAuthMaskModel());
        DataMaskingToolImpl.registerModel(new NickNameSMSGuestMaskModel());
        DataMaskingToolImpl.registerModel(new NickNameSMSLoginMaskModel());
        DataMaskingToolImpl.registerModel(new NickNameSMSAuthMaskModel());
        DataMaskingToolImpl.registerModel(new CompanyNameGuestMaskModel());
        DataMaskingToolImpl.registerModel(new CompanyNameLoginMaskModel());
        DataMaskingToolImpl.registerModel(new CompanyNameAuthMaskModel());
        DataMaskingToolImpl.registerModel(new NameGuestMaskModel());
        DataMaskingToolImpl.registerModel(new NameLoginMaskModel());
        DataMaskingToolImpl.registerModel(new NameAuthMaskModel());
        DataMaskingToolImpl.registerModel(new PhoneGuestMaskModel());
        DataMaskingToolImpl.registerModel(new PhoneLoginMaskModel());
        DataMaskingToolImpl.registerModel(new PhoneAuthMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneWebGuestMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneWebLoginMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneWebAuthMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneSMSGuestMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneSMSLoginMaskModel());
        DataMaskingToolImpl.registerModel(new CnMobilePhoneSMSAuthMaskModel());
        DataMaskingToolImpl.registerModel(new OverseaMobilePhoneWebGuestMaskModel());
        DataMaskingToolImpl.registerModel(new OverseaMobilePhoneWebLoginMaskModel());
        DataMaskingToolImpl.registerModel(new OverseaMobilePhoneWebAuthMaskModel());
        DataMaskingToolImpl.registerModel(new OverseaMobilePhoneSMSGuestMaskModel());
        DataMaskingToolImpl.registerModel(new OverseaMobilePhoneSMSLoginMaskModel());
        DataMaskingToolImpl.registerModel(new OverseaMobilePhoneSMSAuthMaskModel());
        DataMaskingToolImpl.registerModel(new AddressGuestMaskModel());
        DataMaskingToolImpl.registerModel(new AddressLoginMaskModel());
        DataMaskingToolImpl.registerModel(new AddressAuthMaskModel());
        DataMaskingToolImpl.registerModel(new EmailSMSGuestMaskModel());
        DataMaskingToolImpl.registerModel(new EmailSMSLoginMaskModel());
        DataMaskingToolImpl.registerModel(new EmailSMSAuthMaskModel());
        DataMaskingToolImpl.registerModel(new DebitCardGuestMaskModel());
        DataMaskingToolImpl.registerModel(new DebitCardLoginMaskModel());
        DataMaskingToolImpl.registerModel(new DebitCardAuthMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardNoGuestMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardNoLoginMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardNoAuthMaskModel());
        DataMaskingToolImpl.registerModel(new EmailWebGuestMaskModel());
        DataMaskingToolImpl.registerModel(new EmailWebLoginMaskModel());
        DataMaskingToolImpl.registerModel(new EmailWebAuthMaskModel());
        DataMaskingToolImpl.registerModel(new PostcodeGuestMaskModel());
        DataMaskingToolImpl.registerModel(new PostcodeLoginMaskModel());
        DataMaskingToolImpl.registerModel(new PostcodeAuthMaskModel());
        DataMaskingToolImpl.registerModel(new EmailGuestMaskModel());
        DataMaskingToolImpl.registerModel(new EmailLoginMaskModel());
        DataMaskingToolImpl.registerModel(new EmailAuthMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardOverseaGuestMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardOverseaAuthMaskModel());
        DataMaskingToolImpl.registerModel(new IDCardOverseaLoginMaskModel());
        DataMaskingToolImpl.registerModel(new DefaultGuestMaskModel());
        DataMaskingToolImpl.registerModel(new DefaultAuthMaskModel());
        DataMaskingToolImpl.registerModel(new DefaultLoginMaskModel());
        DataMaskingToolImpl.registerModel(new DefaultSMSGuestMaskModel());
        DataMaskingToolImpl.registerModel(new DefaultSMSAuthMaskModel());
        DataMaskingToolImpl.registerModel(new DefaultSMSLoginMaskModel());
        DataMaskingToolImpl.registerModel(new EngineNumberGuestMaskModel());
        DataMaskingToolImpl.registerModel(new EngineNumberAuthMaskModel());
        DataMaskingToolImpl.registerModel(new EngineNumberLoginMaskModel());
        DataMaskingToolImpl.registerModel(new VINGuestMaskModel());
        DataMaskingToolImpl.registerModel(new VINAuthMaskModel());
        DataMaskingToolImpl.registerModel(new VINLoginMaskModel());
        DataMaskingToolImpl.registerModel(new NumberPlateGuestMaskModel());
        DataMaskingToolImpl.registerModel(new NumberPlateAuthMaskModel());
        DataMaskingToolImpl.registerModel(new NumberPlateLoginMaskModel());
        DataMaskingToolImpl.registerModel(new IPMACGuestMaskModel());
        DataMaskingToolImpl.registerModel(new IPMACAuthMaskModel());
        DataMaskingToolImpl.registerModel(new IPMACLoginMaskModel());
        DataMaskingToolImpl.registerModel(new IMEIGuestMaskModel());
        DataMaskingToolImpl.registerModel(new IMEIAuthMaskModel());
        DataMaskingToolImpl.registerModel(new IMEILoginMaskModel());
        DataMaskingToolImpl.registerModel(new USCCGuestMaskModel());
        DataMaskingToolImpl.registerModel(new USCCAuthMaskModel());
        DataMaskingToolImpl.registerModel(new USCCLoginMaskModel());
        DataMaskingToolImpl.registerModel(new QuanxiSubjectGuestMaskModel());
        DataMaskingToolImpl.registerModel(new QuanxiSubjectAuthMaskModel());
        DataMaskingToolImpl.registerModel(new QuanxiSubjectLoginMaskModel());
        DataMaskingToolImpl.registerModel(new QuanxiEmailGuestMaskModel());
        DataMaskingToolImpl.registerModel(new QuanxiEmailAuthMaskModel());
        DataMaskingToolImpl.registerModel(new QuanxiEmailLoginMaskModel());
        modelMap = Collections.unmodifiableMap(theModelMap);
        theModelMap = null;
    }
}

