/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;

public class SybaseUrlParser
extends DefaultUrlParser {
    @Override
    public void parse(String url) throws JdbcURLException {
        if (!url.startsWith("jdbc:sybase:Tds:")) {
            throw new JdbcURLUnsafeException("unsafe sybase url: " + url);
        }
        this.initialUrl = url;
        this.scheme = "jdbc:sybase:Tds:";
        this.parseUrlWithoutScheme(url.substring("jdbc:sybase:Tds:".length()));
    }

    @Override
    public String toString() {
        StringBuilder url = new StringBuilder();
        url.append(this.scheme);
        url.append(this.host);
        if (this.port > -1) {
            url.append(":").append(this.port);
        }
        if (this.database != null) {
            url.append("/").append(this.database);
        }
        if (!this.properties.isEmpty()) {
            url.append(this.getParamMarker());
            url.append(this.propertiesToString());
        }
        return url.toString();
    }
}

