/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.SemicolonSeparatedUrlParser;

public class SQLServerUrlParser
extends SemicolonSeparatedUrlParser {
    protected String instanceName;

    @Override
    protected void parseUrlWithoutScheme(String urlSecondPart) throws JdbcURLException {
        String property;
        String tmpUrl = urlSecondPart;
        StringBuilder result = new StringBuilder();
        String name = "";
        String value = "";
        boolean inStart = false;
        boolean inServerName = true;
        int inPort = 2;
        int inInstanceName = 3;
        int inEscapedValueStart = 4;
        int inEscapedValueEnd = 5;
        int inValue = 6;
        int inName = 7;
        int state = 0;
        block22: for (int i = 0; i < tmpUrl.length(); ++i) {
            char ch = tmpUrl.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == ';') {
                        state = 7;
                        continue block22;
                    }
                    result.append(ch);
                    state = 1;
                    continue block22;
                }
                case 1: {
                    if (ch == ';' || ch == ':' || ch == '\\') {
                        property = result.toString().trim();
                        if (property.contains("=")) {
                            throw new JdbcURLUnsafeException("invalid url: " + urlSecondPart);
                        }
                        if (property.length() > 0) {
                            this.host = property;
                        }
                        result.setLength(0);
                        if (ch == ';') {
                            state = 7;
                            continue block22;
                        }
                        if (ch == ':') {
                            state = 2;
                            continue block22;
                        }
                        state = 3;
                        continue block22;
                    }
                    result.append(ch);
                    continue block22;
                }
                case 2: {
                    if (ch == ';') {
                        property = result.toString().trim();
                        try {
                            this.port = Integer.parseInt(property);
                        }
                        catch (NumberFormatException e) {
                            throw new JdbcURLUnsafeException("invalid host in url: " + urlSecondPart);
                        }
                        result.setLength(0);
                        state = 7;
                        continue block22;
                    }
                    result.append(ch);
                    continue block22;
                }
                case 3: {
                    if (ch == ';' || ch == ':') {
                        this.instanceName = property = result.toString().trim();
                        result.setLength(0);
                        if (ch == ';') {
                            state = 7;
                            continue block22;
                        }
                        state = 2;
                        continue block22;
                    }
                    result.append(ch);
                    continue block22;
                }
                case 7: {
                    if (ch == '=') {
                        if ((name = name.trim()).length() <= 0) {
                            throw new JdbcURLUnsafeException("error connection string: " + urlSecondPart);
                        }
                        state = 6;
                        continue block22;
                    }
                    if (ch == ';') {
                        if ((name = name.trim()).length() <= 0) continue block22;
                        throw new JdbcURLUnsafeException("error connection string: " + urlSecondPart);
                    }
                    StringBuilder builder = new StringBuilder();
                    builder.append(name);
                    builder.append(ch);
                    name = builder.toString();
                    continue block22;
                }
                case 6: {
                    StringBuilder builder;
                    if (ch == ';') {
                        value = value.trim();
                        this.properties.put(name, value);
                        name = "";
                        value = "";
                        state = 7;
                        continue block22;
                    }
                    if (ch == '{') {
                        state = 4;
                        if ((value = value.trim()).length() > 0) {
                            throw new JdbcURLUnsafeException("error connection string: " + urlSecondPart);
                        }
                        builder = new StringBuilder();
                        builder.append(value);
                        builder.append(ch);
                        value = builder.toString();
                        continue block22;
                    }
                    builder = new StringBuilder();
                    builder.append(value);
                    builder.append(ch);
                    value = builder.toString();
                    continue block22;
                }
                case 4: {
                    StringBuilder builder;
                    if (ch == '}' && i + 1 < tmpUrl.length() && tmpUrl.charAt(i + 1) == '}') {
                        builder = new StringBuilder();
                        builder.append(value);
                        builder.append(ch);
                        builder.append(ch);
                        value = builder.toString();
                        ++i;
                        continue block22;
                    }
                    if (ch == '}') {
                        builder = new StringBuilder();
                        builder.append(value);
                        builder.append(ch);
                        value = builder.toString();
                        this.properties.put(name, value);
                        name = "";
                        value = "";
                        state = 5;
                        continue block22;
                    }
                    builder = new StringBuilder();
                    builder.append(value);
                    builder.append(ch);
                    value = builder.toString();
                    continue block22;
                }
                case 5: {
                    if (ch == ';') {
                        state = 7;
                        continue block22;
                    }
                    if (ch == ' ') continue block22;
                    throw new JdbcURLUnsafeException("error connection string: " + urlSecondPart);
                }
                default: {
                    assert (false) : "parseURL: Invalid state " + state;
                    continue block22;
                }
            }
        }
        switch (state) {
            case 1: {
                property = result.toString().trim();
                if (property.length() <= 0) break;
                this.host = property;
                break;
            }
            case 2: {
                property = result.toString().trim();
                try {
                    this.port = Integer.parseInt(property);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new JdbcURLUnsafeException("invalid host in url: " + urlSecondPart);
                }
            }
            case 3: {
                this.instanceName = property = result.toString().trim();
                break;
            }
            case 6: {
                value = value.trim();
                this.properties.put(name, value);
                break;
            }
            case 0: 
            case 5: {
                break;
            }
            case 7: {
                name = name.trim();
                if (name.length() <= 0) break;
                throw new JdbcURLUnsafeException("error connection string: " + urlSecondPart);
            }
            default: {
                throw new JdbcURLUnsafeException("error connection string: " + urlSecondPart);
            }
        }
        if (!this.getHostPattern().matcher(this.host).matches()) {
            throw new JdbcURLUnsafeException("invalid host '" + this.host + "' in url: " + urlSecondPart);
        }
        if (this.instanceName != null && !this.instanceName.isEmpty() && !this.getHostPattern().matcher(this.instanceName).matches()) {
            throw new JdbcURLUnsafeException("invalid host '" + this.host + "' in url: " + urlSecondPart);
        }
        if (this.port < 0 || this.port > 65535) {
            throw new JdbcURLUnsafeException("invalid port " + this.port + " in url: " + urlSecondPart);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.scheme).append("//").append(this.host);
        if (this.instanceName != null && !this.instanceName.isEmpty()) {
            builder.append('\\').append(this.instanceName);
        }
        if (this.port > 0) {
            builder.append(':').append(this.port);
        }
        if (!this.properties.isEmpty()) {
            builder.append(this.getParamMarker()).append(this.propertiesToString());
        }
        return builder.toString();
    }
}

