/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Hive2Parser
extends DefaultUrlParser {
    private static final String URL_PREFIX = "jdbc:hive2://";
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.:\\[\\],]+$");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("([^;]*)=([^;]*)[;]?");
    private String authority;
    private Map<String, String> sessionVars = new HashMap<String, String>();
    private Map<String, String> hiveConfs = new HashMap<String, String>();
    private Map<String, String> hiveVars = new HashMap<String, String>();

    @Override
    public void parse(String url) throws JdbcURLException {
        String varStr;
        String confStr;
        this.initialUrl = url;
        if (!url.startsWith(URL_PREFIX)) {
            throw new JdbcURLUnsafeException("url not starts with jdbc:hive2://");
        }
        this.parseAuthority();
        URI jdbcURI = URI.create(url.substring("jdbc:".length()));
        String sessVars = jdbcURI.getPath();
        if (sessVars != null && !sessVars.isEmpty()) {
            this.parseSessVars(sessVars);
        }
        if ((confStr = jdbcURI.getQuery()) != null) {
            this.parseConfStr(confStr);
        }
        if ((varStr = jdbcURI.getFragment()) != null) {
            this.parseHiveVars(varStr);
        }
    }

    private void parseAuthority() throws JdbcURLException {
        String toIndexChar;
        int fromIndex = URL_PREFIX.length();
        int toIndex = -1;
        ArrayList<String> toIndexChars = new ArrayList<String>(Arrays.asList("/", "?", "#"));
        Iterator<String> iterator = toIndexChars.iterator();
        while (iterator.hasNext() && (toIndex = this.initialUrl.indexOf(toIndexChar = iterator.next(), fromIndex)) <= 0) {
        }
        this.authority = toIndex < 0 ? this.initialUrl.substring(fromIndex) : this.initialUrl.substring(fromIndex, toIndex);
        if (this.authority.isEmpty() || !AUTHORITY_PATTERN.matcher(this.authority).matches()) {
            throw new JdbcURLUnsafeException();
        }
    }

    private void parseSessVars(String sessVars) throws JdbcURLException {
        String dbName = "";
        if (!(sessVars = sessVars.substring(1)).contains(";")) {
            dbName = sessVars;
        } else {
            dbName = sessVars.substring(0, sessVars.indexOf(59));
            if ((sessVars = sessVars.substring(sessVars.indexOf(59) + 1)) != null) {
                Matcher sessMatcher = KEY_VALUE_PATTERN.matcher(sessVars);
                while (sessMatcher.find()) {
                    if (this.sessionVars.put(sessMatcher.group(1), sessMatcher.group(2)) == null) continue;
                    throw new JdbcURLUnsafeException("Bad URL format: Multiple values for property " + sessMatcher.group(1));
                }
            }
        }
        if (!dbName.isEmpty()) {
            this.database = dbName;
            if (!this.getDatabasePattern().matcher(this.database).matches()) {
                throw new JdbcURLUnsafeException();
            }
        }
    }

    private void parseConfStr(String confStr) {
        Matcher confMatcher = KEY_VALUE_PATTERN.matcher(confStr);
        while (confMatcher.find()) {
            this.hiveConfs.put(confMatcher.group(1), confMatcher.group(2));
        }
    }

    private void parseHiveVars(String varStr) {
        Matcher varMatcher = KEY_VALUE_PATTERN.matcher(varStr);
        while (varMatcher.find()) {
            this.hiveVars.put(varMatcher.group(1), varMatcher.group(2));
        }
    }

    private String joinMap(Map<String, String> map, String delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!isFirst) {
                sb.append(delimiter);
            }
            isFirst = false;
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(URL_PREFIX).append(this.authority).append("/");
        if (this.database != null && !this.database.isEmpty()) {
            urlBuilder.append(this.database);
        }
        if (!this.sessionVars.isEmpty()) {
            urlBuilder.append(";").append(this.joinMap(this.sessionVars, ";"));
        }
        if (!this.hiveConfs.isEmpty()) {
            if (this.sessionVars.isEmpty()) {
                urlBuilder.append(";");
            }
            urlBuilder.append("?").append(this.joinMap(this.hiveConfs, ";"));
        }
        if (!this.hiveVars.isEmpty()) {
            urlBuilder.append("#").append(this.joinMap(this.hiveVars, ";"));
        }
        return urlBuilder.toString();
    }

    public String getAuthority() {
        return this.authority;
    }

    public Map<String, String> getSessionVars() {
        return this.sessionVars;
    }

    public Map<String, String> getHiveConfs() {
        return this.hiveConfs;
    }

    public Map<String, String> getHiveVars() {
        return this.hiveVars;
    }
}

