/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.Filter;
import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.util.Map;

public class DMUrlParser
extends DefaultUrlParser {
    private final Filter filter;
    private static final String SERVICE_NAME_KEY = "servicename";

    public DMUrlParser() {
        this.filter = null;
    }

    public DMUrlParser(Filter filter) {
        this.filter = filter;
    }

    @Override
    protected void parseHost(String hostAddressesString) throws JdbcURLException {
        super.parseHost(hostAddressesString);
        if (this.filter != null && this.host.equals(SERVICE_NAME_KEY)) {
            this.filter.addAcceptedPropertyKey(new String[]{SERVICE_NAME_KEY});
        }
    }

    @Override
    protected String propertiesToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.host.equals(SERVICE_NAME_KEY) && this.properties.containsKey(SERVICE_NAME_KEY)) {
            sb.append(SERVICE_NAME_KEY);
            sb.append("=");
            sb.append((String)this.properties.get(SERVICE_NAME_KEY));
            first = false;
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            if (((String)entry.getKey()).equals(SERVICE_NAME_KEY)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append((String)entry.getValue());
        }
        return sb.toString();
    }
}

