/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ColonSeparatedUrlParser
extends DefaultUrlParser {
    private static final Pattern URL_PARAMETER = Pattern.compile("(\\/([^:]*))?(:(.+))*", 32);
    private final Set<String> acceptedSchemes = new HashSet<String>();

    @Override
    protected String getParamMarker() {
        return ":";
    }

    @Override
    protected String getParamSeparator() {
        return ";";
    }

    @Override
    protected Pattern getUrlParameterPattern() {
        return URL_PARAMETER;
    }

    @Override
    protected void parseUrlWithoutScheme(String urlSecondPart) throws JdbcURLException {
        int dbIndex = urlSecondPart.indexOf("/");
        if (dbIndex == -1) {
            throw new JdbcURLUnsafeException("Invalid URL: " + urlSecondPart + " no database provided");
        }
        String hostAddressesString = urlSecondPart.substring(0, dbIndex);
        String additionalParameters = urlSecondPart.substring(dbIndex);
        this.parseHost(hostAddressesString);
        this.parseAdditionalParameter(additionalParameters);
    }

    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }
}

