/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VerticaFilter
extends DefaultFilter {
    private Set<String> acceptedSchemes = new HashSet<String>(Collections.singletonList("jdbc:vertica:"));
    private Set<String> acceptedPropertyKeys = new HashSet<String>(Arrays.asList("User", "Password", "SSL", "TLSmode", "LoginTimeout", "LoginNodeTimeout", "LoginNetworkTimeout", "NetworkTimeout", "AutoCommit", "MultipleActiveResultSets", "ReadOnly"));
    private boolean ignoreCase = true;

    @Override
    public void filterProperties(UrlParser parser) {
        super.filterProperties(parser);
        Map properties = parser.getProperties();
        properties.put("DisableCopyLocal", "true");
    }

    @Override
    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    public void setAcceptedSchemes(Set<String> acceptedSchemes) {
        this.acceptedSchemes = acceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    @Override
    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

