/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import com.aliyun.securitysdk.jdbc.parser.SQLServerUrlParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SQLServerFilter
extends DefaultFilter {
    private Set<String> acceptedSchemes = new HashSet<String>(Collections.singletonList("jdbc:sqlserver:"));
    private Set<String> acceptedPropertyKeys = new HashSet<String>(Arrays.asList("trustServerCertificate", "user", "database", "ApplicationIntent", "schemaName", "instanceName", "databaseName", "encrypt", "password", "loginTimeout", "socketTimeout", "queryTimeout", "language", "hostNameInCertificate", "sendStringParametersAsUnicode", "failoverPartner"));
    private boolean ignoreCase = true;
    private static final Map<String, Pattern> propertyPatterns = new HashMap<String, Pattern>();

    @Override
    public UrlParser getUrlParser() {
        return new SQLServerUrlParser();
    }

    @Override
    public Map<String, Pattern> getPropertyPatterns() {
        return propertyPatterns;
    }

    @Override
    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    public void setAcceptedSchemes(Set<String> acceptedSchemes) {
        this.acceptedSchemes = acceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    @Override
    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    static {
        Pattern wordsPattern = Pattern.compile("^[a-zA-Z0-9_\\-\\.\\p{script=Han}$@\\[\\]{}() +]+$");
        propertyPatterns.put("database".toLowerCase(), wordsPattern);
        propertyPatterns.put("databaseName".toLowerCase(), wordsPattern);
        propertyPatterns.put("schemaName".toLowerCase(), wordsPattern);
    }
}

