/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import com.aliyun.securitysdk.jdbc.parser.OracleUrlParser;
import com.aliyun.securitysdk.jdbc.parser.oracle.NVPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OracleFilter
extends DefaultFilter {
    private static final Logger logger = SecurityLogManager.getLogger(OracleFilter.class);
    private Set<String> acceptedSchemes = new HashSet<String>();
    private Set<String> acceptedPropertyKeys = new HashSet<String>(Arrays.asList("oracle.net.CONNECT_TIMEOUT", "oracle.jdbc.ReadTimeout", "oracle.net.networkCompression", "oracle.net.networkCompressionThreshold"));
    private Set<String> acceptedPairNames = new HashSet<String>(Arrays.asList("DESCRIPTION", "DESCRIPTION_LIST", "ADDRESS", "ADDRESS_LIST", "ALIAS", "PROTOCOL", "HOST", "PORT", "SOURCE_ROUTE", "LOAD_BALANCE", "FAILOVER", "CONNECT_DATA", "SID", "SERVER", "SERVICE_NAME", "INSTANCE_NAME", "INSTANCE_ROLE", "CONNECTION_ID_PREFIX"));

    @Override
    public UrlParser getUrlParser() {
        return new OracleUrlParser();
    }

    @Override
    public boolean acceptURL(String url) {
        return url != null && url.regionMatches(true, 0, "jdbc:oracle:thin:@", 0, 18);
    }

    @Override
    public void filterProperties(UrlParser parser) {
        this.checkAndFilterProperties(parser);
    }

    @Override
    public boolean checkAndFilterProperties(UrlParser parser) {
        boolean result = true;
        if (!(parser instanceof OracleUrlParser)) {
            return false;
        }
        result = super.checkAndFilterProperties(parser);
        OracleUrlParser oracleParser = (OracleUrlParser)parser;
        NVPair pair = oracleParser.getNvPair();
        if (pair == null) {
            return result;
        }
        if (this.acceptedPairNames.contains(pair.getName())) {
            oracleParser.setNvPair(null);
            logger.info("invalid property {} are removed by jdbc url filter, original url: {}, after filter: {}", (Object)pair.toString(), (Object)parser.getInitialUrl(), (Object)parser.toString());
            result = false;
        }
        if (this.filterNVPairRecursive(pair)) {
            logger.info("invalid property are removed by jdbc url filter, original url: {}, after filter: {}", (Object)parser.getInitialUrl(), (Object)parser.toString());
            result = false;
        }
        return result;
    }

    public boolean filterNVPairRecursive(NVPair pair) {
        int i;
        boolean hasRemovedNvPair = false;
        int size = pair.getListSize();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        for (i = 0; i < size; ++i) {
            NVPair subPair = pair.getListElement(i);
            if (subPair == null) continue;
            hasRemovedNvPair = this.filterNVPairRecursive(subPair);
            if (!this.acceptedPairNames.contains(subPair.getName().toUpperCase())) {
                removeIndex.add(i);
            }
            if (!subPair.getName().equalsIgnoreCase("PROTOCOL")) continue;
            if (subPair.getRHSType() != NVPair.RHS_ATOM) {
                removeIndex.add(i);
            }
            if (subPair.getAtom().equalsIgnoreCase("TCP") || subPair.getAtom().equalsIgnoreCase("TCPS")) continue;
            removeIndex.add(i);
        }
        Collections.sort(removeIndex);
        for (i = 0; i < removeIndex.size(); ++i) {
            removeIndex.set(i, (Integer)removeIndex.get(i) - i);
        }
        for (Integer i2 : removeIndex) {
            hasRemovedNvPair = true;
            pair.removeListElement(i2);
        }
        return hasRemovedNvPair;
    }

    @Override
    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    public void setAcceptedSchemes(Set<String> acceptedSchemes) {
        this.acceptedSchemes = acceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    @Override
    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    public Set<String> getAcceptedPairNames() {
        return this.acceptedPairNames;
    }

    public void setAcceptedPairNames(Set<String> acceptedPairNames) {
        this.acceptedPairNames = acceptedPairNames;
    }
}

