/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.jdbc.Filter;
import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DefaultFilter
implements Filter {
    private static final Logger logger = SecurityLogManager.getLogger(DefaultFilter.class);
    private final Set<String> acceptedSchemes = new HashSet<String>(Arrays.asList("jdbc:not-exists:"));
    private Set<String> acceptedPropertyKeys = new HashSet<String>();
    private Set<String> propertyKeyWhiteList = new HashSet<String>(Arrays.asList("user", "username", "pass", "password", "CustomProperties"));
    private boolean ignoreCase = false;
    private static final Map<String, Pattern> propertyPatterns = new HashMap<String, Pattern>();
    private static final Pattern PROPERTY_VALUE_PATTERN;

    protected Map<String, Pattern> getPropertyPatterns() {
        return propertyPatterns;
    }

    protected Pattern getPropertyValuePattern() {
        return PROPERTY_VALUE_PATTERN;
    }

    public UrlParser getUrlParser() {
        return new DefaultUrlParser();
    }

    public void addAcceptedPropertyKey(String ... keys) {
        if (this.getAcceptedPropertyKeys() == null) {
            this.setAcceptedPropertyKeys(new HashSet<String>());
        }
        this.getAcceptedPropertyKeys().addAll(Arrays.asList(keys));
    }

    public void addPropertyKeyWhiteList(String ... keys) {
        if (this.getPropertyKeyWhiteList() == null) {
            this.setPropertyKeyWhiteList(new HashSet<String>());
        }
        this.getPropertyKeyWhiteList().addAll(Arrays.asList(keys));
    }

    public boolean acceptURL(String scheme) {
        return false;
    }

    public void filterProperties(UrlParser parser) {
        this.checkAndFilterProperties(parser);
    }

    public boolean checkAndFilterProperties(UrlParser parser) {
        Map properties = parser.getProperties();
        HashMap removedProperties = new HashMap();
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!this.keyIn(key, this.getAcceptedPropertyKeys()) && !this.keyIn(key, this.getPropertyKeyWhiteList())) {
                iterator.remove();
                removedProperties.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() == null || ((String)entry.getValue()).isEmpty() || this.keyIn(key, this.getPropertyKeyWhiteList())) continue;
            Pattern pattern = this.getPropertyPatterns().get(key.toLowerCase());
            if (pattern == null) {
                pattern = this.getPropertyValuePattern();
            }
            if (pattern.matcher((CharSequence)entry.getValue()).matches()) continue;
            iterator.remove();
            removedProperties.put(key, entry.getValue());
        }
        if (!removedProperties.isEmpty()) {
            logger.info("some invalid property are removed by jdbc url filter: {}, original url: {}, after filter: {}", removedProperties, (Object)parser.getInitialUrl(), (Object)parser.toString());
            return false;
        }
        return true;
    }

    protected boolean keyIn(String key, Collection<String> keyList) {
        if (keyList == null || key == null) {
            return false;
        }
        if (!this.isIgnoreCase()) {
            return keyList.contains(key);
        }
        for (String k : keyList) {
            if (!key.equalsIgnoreCase(k)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    public Set<String> getPropertyKeyWhiteList() {
        return this.propertyKeyWhiteList;
    }

    public void setPropertyKeyWhiteList(Set<String> propertyKeyWhiteList) {
        this.propertyKeyWhiteList = propertyKeyWhiteList;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    static {
        propertyPatterns.put("servertimezone", Pattern.compile("^[a-zA-Z0-9_\\-\\.:\\[\\]/+]+$"));
        PROPERTY_VALUE_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.:\\[\\]]+$");
    }
}

