/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.decorator.xxe;

import com.aliyun.securitysdk.decorator.AbstractDecorator;
import java.lang.reflect.Method;

public class XMLInputFactoryDecorator
extends AbstractDecorator {
    private static final Class<?> xifClass = XMLInputFactoryDecorator.classForNameQuietly("javax.xml.stream.XMLInputFactory");
    private static Method setPropertyMethod;

    public boolean accept(Object clientOrBuilder) {
        return xifClass != null && xifClass.isInstance(clientOrBuilder);
    }

    public <T> T decorate(T clientOrBuilder) {
        if (xifClass == null) {
            throw new RuntimeException("expected exception");
        }
        try {
            if (setPropertyMethod == null) {
                setPropertyMethod = xifClass.getMethod("setProperty", String.class, Object.class);
                setPropertyMethod.setAccessible(true);
            }
            setPropertyMethod.invoke(clientOrBuilder, "javax.xml.stream.supportDTD", false);
            setPropertyMethod.invoke(clientOrBuilder, "javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (Exception e) {
            throw new RuntimeException("can not decorate xif", e);
        }
        return clientOrBuilder;
    }
}

