/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils.resource;

import com.aliyun.migration.teleport.common.element.meta.dataset.QualifiedName;
import com.aliyun.migration.teleport.common.utils.resource.mapping.DbMapping;
import com.aliyun.migration.teleport.common.utils.resource.mapping.PartitionMapping;
import com.aliyun.migration.teleport.common.utils.resource.mapping.TableMapping;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QualifiedNameMapping {
    protected List<Config> mappingConfig = new ArrayList<Config>();

    public QualifiedNameMapping(List<String> nameMapping) {
        for (String s : nameMapping) {
            this.mappingConfig.add(new Config(s));
        }
    }

    public List<Config> getMappingConfig() {
        return this.mappingConfig;
    }

    public QualifiedName map(QualifiedName qualifiedName) {
        QualifiedName result = new QualifiedName();
        if (this.mappingConfig.isEmpty()) {
            result.setSchemaName(qualifiedName.getSchemaName());
            result.setTableName(qualifiedName.getTableName());
            result.setPartitionName(qualifiedName.getPartitionName());
            return result;
        }
        for (Config conf : this.mappingConfig) {
            result.setSchemaName(conf.getDbMapping().map(qualifiedName.getSchemaName()));
            result.setTableName(conf.getTableMapping().map(qualifiedName.getTableName()));
            result.setPartitionName(conf.getPartitionMapping().map(qualifiedName.getPartitionName()));
        }
        return result;
    }

    public QualifiedName map(String schemaName, String tableName, String partitionName) {
        QualifiedName result = new QualifiedName();
        if (this.mappingConfig.isEmpty()) {
            result.setSchemaName(schemaName);
            result.setTableName(tableName);
            result.setPartitionName(partitionName);
            return result;
        }
        for (Config conf : this.mappingConfig) {
            result.setSchemaName(conf.getDbMapping().map(schemaName));
            result.setTableName(conf.getTableMapping().map(tableName));
            result.setPartitionName(conf.getPartitionMapping().map(partitionName));
        }
        return result;
    }

    public class Config {
        private static final int MAPPING_PARTS = 3;
        private DbMapping dbMapping;
        private TableMapping tableMapping;
        private PartitionMapping partitionMapping;

        public Config(String config) {
            if (StringUtils.isBlank((CharSequence)config)) {
                this.dbMapping = new DbMapping(null);
                this.tableMapping = new TableMapping(null);
                this.partitionMapping = new PartitionMapping(null);
            } else {
                String[] parts = config.split("\\|", -1);
                if (parts.length != 3) {
                    return;
                }
                this.dbMapping = new DbMapping(parts[0]);
                this.tableMapping = new TableMapping(parts[1]);
                this.partitionMapping = new PartitionMapping(parts[2]);
            }
        }

        public DbMapping getDbMapping() {
            return this.dbMapping;
        }

        public TableMapping getTableMapping() {
            return this.tableMapping;
        }

        public PartitionMapping getPartitionMapping() {
            return this.partitionMapping;
        }

        public void setDbMapping(DbMapping dbMapping) {
            this.dbMapping = dbMapping;
        }

        public void setTableMapping(TableMapping tableMapping) {
            this.tableMapping = tableMapping;
        }

        public void setPartitionMapping(PartitionMapping partitionMapping) {
            this.partitionMapping = partitionMapping;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DbMapping this$dbMapping = this.getDbMapping();
            DbMapping other$dbMapping = other.getDbMapping();
            if (this$dbMapping == null ? other$dbMapping != null : !this$dbMapping.equals(other$dbMapping)) {
                return false;
            }
            TableMapping this$tableMapping = this.getTableMapping();
            TableMapping other$tableMapping = other.getTableMapping();
            if (this$tableMapping == null ? other$tableMapping != null : !this$tableMapping.equals(other$tableMapping)) {
                return false;
            }
            PartitionMapping this$partitionMapping = this.getPartitionMapping();
            PartitionMapping other$partitionMapping = other.getPartitionMapping();
            return !(this$partitionMapping == null ? other$partitionMapping != null : !this$partitionMapping.equals(other$partitionMapping));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DbMapping $dbMapping = this.getDbMapping();
            result = result * 59 + ($dbMapping == null ? 43 : $dbMapping.hashCode());
            TableMapping $tableMapping = this.getTableMapping();
            result = result * 59 + ($tableMapping == null ? 43 : $tableMapping.hashCode());
            PartitionMapping $partitionMapping = this.getPartitionMapping();
            result = result * 59 + ($partitionMapping == null ? 43 : $partitionMapping.hashCode());
            return result;
        }

        public String toString() {
            return "QualifiedNameMapping.Config(dbMapping=" + String.valueOf(this.getDbMapping()) + ", tableMapping=" + String.valueOf(this.getTableMapping()) + ", partitionMapping=" + String.valueOf(this.getPartitionMapping()) + ")";
        }
    }
}

