/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TimeUtil {
    public static final int MILLS = 1000;
    public static final int SECOND = 60;
    public static final int MINUTE = 60;

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        return instant.atZone(ZoneId.of("Asia/Shanghai")).toLocalDateTime();
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.toInstant(ZoneOffset.ofHours(8)));
    }

    public static Long between(LocalDateTime start, LocalDateTime end) {
        if (start == null || end == null) {
            return null;
        }
        return Duration.between(start, end).toMillis();
    }

    public static Long between(String start, String end) {
        LocalDateTime startTime = TimeUtil.parseLocalDateTime(start);
        LocalDateTime endTime = TimeUtil.parseLocalDateTime(end);
        return TimeUtil.between(startTime, endTime);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static LocalDateTime parseLocalDateTime(String localDateTime) {
        if (localDateTime == null || localDateTime.isEmpty()) {
            return null;
        }
        return LocalDateTime.parse(localDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static boolean isBefore(LocalDateTime thisTime, LocalDateTime otherTime) {
        if (thisTime != null && otherTime != null) {
            return thisTime.isBefore(otherTime);
        }
        return false;
    }

    public static boolean isAfter(LocalDateTime thisTime, LocalDateTime otherTime) {
        if (thisTime != null && otherTime != null) {
            return thisTime.isAfter(otherTime);
        }
        return false;
    }

    public static String durationFormat(Long millTime) {
        if (millTime == null || millTime <= 0L) {
            return "-";
        }
        List<Integer> units = Arrays.asList(1000, 60, 60);
        Long[] values = new Long[]{0L, 0L, 0L, 0L};
        String[] labels = new String[]{"ms", "s", "m", "h"};
        for (int i = 0; i < units.size() && millTime > 0L; ++i) {
            values[i] = millTime % (long)units.get(i).intValue();
            millTime = millTime / (long)units.get(i).intValue();
        }
        if (millTime > 0L) {
            values[values.length - 1] = millTime;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = values.length - 1; i >= 0; --i) {
            if (values[i] == null || values[i] <= 0L) continue;
            sb.append(values[i]).append(labels[i]);
        }
        return sb.toString();
    }
}

