/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils;

import com.aliyun.migration.teleport.common.constants.TeleportMetaStatusCode;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PasswordUtil {
    static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String PASSWORD_PLACEHOLDER = "******";
    public static final String ENCRYPT_KEY = "WEJGcWdibm1WL0xrZUdIZw==";
    public static final List<String> PASSWORD_KEYS = Arrays.asList("password", "accessKey", "secret", "token");
    public static final List<String> EXACT_MATCH_PASSWORD_KEYS = Arrays.asList("sk");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPasswordKey(String key) {
        if (key == null) return false;
        if (key.isEmpty()) {
            return false;
        }
        if (PASSWORD_KEYS.stream().anyMatch(i -> key.toLowerCase().contains(i.toLowerCase()))) return true;
        if (!EXACT_MATCH_PASSWORD_KEYS.stream().anyMatch(key::equalsIgnoreCase)) return false;
        return true;
    }

    private static byte[] encrypt(byte[] content, byte[] keyByte, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)new SecretKeySpec(keyByte, "AES"), new IvParameterSpec(iv));
        return cipher.doFinal(content);
    }

    private static byte[] decrypt(byte[] encryptedContent, byte[] keyByte, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)new SecretKeySpec(keyByte, "AES"), new IvParameterSpec(iv));
        return cipher.doFinal(encryptedContent);
    }

    @Deprecated
    public static EncryptEntity simpleEncrypt(String content) throws Exception {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = Base64.getDecoder().decode(ENCRYPT_KEY);
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        String ivBase64 = Base64.getEncoder().encodeToString(ivBytes);
        byte[] encryptedContent = PasswordUtil.encrypt(contentBytes, keyBytes, ivBytes);
        String encryptedContentBase64 = Base64.getEncoder().encodeToString(encryptedContent);
        return new EncryptEntity(encryptedContentBase64, ivBase64);
    }

    @Deprecated
    public static EncryptEntity simpleEncrypt(String content, String ivBase64) throws Exception {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = Base64.getDecoder().decode(ENCRYPT_KEY);
        byte[] ivBytes = Base64.getDecoder().decode(ivBase64);
        byte[] encryptedContent = PasswordUtil.encrypt(contentBytes, keyBytes, ivBytes);
        String encryptedContentBase64 = Base64.getEncoder().encodeToString(encryptedContent);
        return new EncryptEntity(encryptedContentBase64, ivBase64);
    }

    @Deprecated
    public static String getIvBase64() {
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        return Base64.getEncoder().encodeToString(ivBytes);
    }

    @Deprecated
    public static String simpleDecrypt(String encryptContent, String iv) {
        if (encryptContent == null || encryptContent.isEmpty()) {
            return "";
        }
        if (PASSWORD_PLACEHOLDER.equals(encryptContent)) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PASSWORD_INVALID, encryptContent);
        }
        try {
            byte[] key = Base64.getDecoder().decode(ENCRYPT_KEY);
            byte[] ivBytes = Base64.getDecoder().decode(iv);
            byte[] encryptContentBytes = Base64.getDecoder().decode(encryptContent);
            byte[] decrypt = PasswordUtil.decrypt(encryptContentBytes, key, ivBytes);
            return new String(decrypt, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PASSWORD_DECRYPT_ERROR, e.getMessage());
        }
    }

    public static EncryptEntity encryptWithAes256(String content) {
        String keyBase64 = PasswordUtil.getSecretKeyBase64();
        return PasswordUtil.encryptWithAes256(content, keyBase64);
    }

    public static EncryptEntity encryptWithAes256(String content, String keyBase64) {
        try {
            byte[] salt = ENCRYPT_KEY.getBytes();
            byte[] keyBytes = Base64.getDecoder().decode(keyBase64);
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = cipher.doFinal(contentBytes);
            byte[] combined = new byte[iv.length + salt.length + encrypted.length];
            System.arraycopy(iv, 0, combined, 0, iv.length);
            System.arraycopy(salt, 0, combined, iv.length, salt.length);
            System.arraycopy(encrypted, 0, combined, iv.length + salt.length, encrypted.length);
            String encryptedContentBase64 = Base64.getEncoder().encodeToString(combined);
            return new EncryptEntity(encryptedContentBase64, keyBase64);
        }
        catch (Exception e) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PASSWORD_DECRYPT_ERROR, e.getMessage());
        }
    }

    public static String decryptWithAes256(String encryptContent, String keyBase64) {
        if (encryptContent == null || encryptContent.isEmpty()) {
            return "";
        }
        if (PASSWORD_PLACEHOLDER.equals(encryptContent)) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PASSWORD_INVALID, encryptContent);
        }
        try {
            byte[] salt = ENCRYPT_KEY.getBytes();
            byte[] keyBytes = Base64.getDecoder().decode(keyBase64);
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            byte[] combined = Base64.getDecoder().decode(encryptContent);
            byte[] ivBytes = new byte[16];
            byte[] encrypted = new byte[combined.length - 16 - salt.length];
            System.arraycopy(combined, 0, ivBytes, 0, ivBytes.length);
            System.arraycopy(combined, ivBytes.length + salt.length, encrypted, 0, encrypted.length);
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] decrypted = cipher.doFinal(encrypted);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PASSWORD_DECRYPT_ERROR, e.getMessage());
        }
    }

    public static String getSecretKeyBase64() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(256);
            SecretKey secretKey = kg.generateKey();
            byte[] keyBytes = secretKey.getEncoded();
            return Base64.getEncoder().encodeToString(keyBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.DATASOURCE_PASSWORD_DECRYPT_ERROR, e.getMessage());
        }
    }

    public static class EncryptEntity {
        private String encryptContent;
        private String encryptIv;

        public EncryptEntity(String encryptContent, String encryptIv) {
            this.encryptContent = encryptContent;
            this.encryptIv = encryptIv;
        }

        public String getEncryptContent() {
            return this.encryptContent;
        }

        public String getEncryptIv() {
            return this.encryptIv;
        }

        public void setEncryptContent(String encryptContent) {
            this.encryptContent = encryptContent;
        }

        public void setEncryptIv(String encryptIv) {
            this.encryptIv = encryptIv;
        }
    }
}

