/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element.meta.workflow;

import java.io.Serializable;
import java.util.Objects;

public class RelationPackage
implements Serializable {
    private String from;
    private String to;
    private ReType reType;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationPackage other = (RelationPackage)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && this.reType == other.reType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.to, this.reType});
    }

    public static RelationPackageBuilder builder() {
        return new RelationPackageBuilder();
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public ReType getReType() {
        return this.reType;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setReType(ReType reType) {
        this.reType = reType;
    }

    public String toString() {
        return "RelationPackage(from=" + this.getFrom() + ", to=" + this.getTo() + ", reType=" + String.valueOf((Object)this.getReType()) + ")";
    }

    public RelationPackage() {
    }

    public RelationPackage(String from, String to, ReType reType) {
        this.from = from;
        this.to = to;
        this.reType = reType;
    }

    public static enum ReType {
        NODE,
        FILE,
        FUNCTION,
        WORKFLOW,
        NODE_WORKFLOW,
        WORKFLOW_NODE;

    }

    public static class RelationPackageBuilder {
        private String from;
        private String to;
        private ReType reType;

        RelationPackageBuilder() {
        }

        public RelationPackageBuilder from(String from) {
            this.from = from;
            return this;
        }

        public RelationPackageBuilder to(String to) {
            this.to = to;
            return this;
        }

        public RelationPackageBuilder reType(ReType reType) {
            this.reType = reType;
            return this;
        }

        public RelationPackage build() {
            return new RelationPackage(this.from, this.to, this.reType);
        }

        public String toString() {
            return "RelationPackage.RelationPackageBuilder(from=" + this.from + ", to=" + this.to + ", reType=" + String.valueOf((Object)this.reType) + ")";
        }
    }
}

