/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.migration;

import com.aliyun.migration.teleport.common.dto.migration.DataSyncTaskVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DataSyncJobVO
implements Serializable {
    private String jobName;
    private Long migrateId;
    private Long pipelineId;
    private Long operatorId;
    private Long dataSyncJobId;
    private Long srcDatasourceId;
    private String metaVersion;
    private String migrationType;
    private String errorMessage;
    private String gmtCreate;
    private String startTime;
    private String endTime;
    private String description;
    private String migrationStatus;
    private String migrationStatusPretty;
    private List<DataSyncTaskVO> taskList;

    public void populate() {
        ArrayList<String> statusBuffer = new ArrayList<String>();
        if (this.taskList != null && !this.taskList.isEmpty()) {
            int completed = 0;
            int running = 0;
            for (DataSyncTaskVO taskVO : this.taskList) {
                taskVO.populate();
                statusBuffer.add(String.format("%s%s(%d/%d)", taskVO.getTaskTypePretty(), taskVO.getTaskStatusPretty(), Optional.ofNullable(taskVO.getSuccessTasks()).orElse(0L), Optional.ofNullable(taskVO.getTotalTasks()).orElse(0L)));
                if (taskVO.getTaskProgress() > 0.0 && taskVO.getTaskProgress() < 1.0) {
                    ++running;
                    continue;
                }
                if (taskVO.getTaskProgress() != 1.0) continue;
                ++completed;
            }
            this.migrationStatus = completed == this.taskList.size() ? DataSyncJobStatus.FINISHED.name() : (running > 0 ? DataSyncJobStatus.RUNNING.name() : DataSyncJobStatus.INIT.name());
            this.migrationStatusPretty = String.join((CharSequence)"\n", statusBuffer);
            this.startTime = Optional.ofNullable(this.taskList.get(0).getStartTime()).orElse("-");
            this.endTime = Optional.ofNullable(this.taskList.get(this.taskList.size() - 1).getEndTime()).orElse("-");
        } else {
            this.migrationStatus = DataSyncJobStatus.INIT.name();
            this.migrationStatusPretty = DataSyncJobStatus.INIT.desc;
            this.startTime = "-";
            this.endTime = "-";
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public Long getMigrateId() {
        return this.migrateId;
    }

    public Long getPipelineId() {
        return this.pipelineId;
    }

    public Long getOperatorId() {
        return this.operatorId;
    }

    public Long getDataSyncJobId() {
        return this.dataSyncJobId;
    }

    public Long getSrcDatasourceId() {
        return this.srcDatasourceId;
    }

    public String getMetaVersion() {
        return this.metaVersion;
    }

    public String getMigrationType() {
        return this.migrationType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getGmtCreate() {
        return this.gmtCreate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMigrationStatus() {
        return this.migrationStatus;
    }

    public String getMigrationStatusPretty() {
        return this.migrationStatusPretty;
    }

    public List<DataSyncTaskVO> getTaskList() {
        return this.taskList;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setMigrateId(Long migrateId) {
        this.migrateId = migrateId;
    }

    public void setPipelineId(Long pipelineId) {
        this.pipelineId = pipelineId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public void setDataSyncJobId(Long dataSyncJobId) {
        this.dataSyncJobId = dataSyncJobId;
    }

    public void setSrcDatasourceId(Long srcDatasourceId) {
        this.srcDatasourceId = srcDatasourceId;
    }

    public void setMetaVersion(String metaVersion) {
        this.metaVersion = metaVersion;
    }

    public void setMigrationType(String migrationType) {
        this.migrationType = migrationType;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMigrationStatus(String migrationStatus) {
        this.migrationStatus = migrationStatus;
    }

    public void setMigrationStatusPretty(String migrationStatusPretty) {
        this.migrationStatusPretty = migrationStatusPretty;
    }

    public void setTaskList(List<DataSyncTaskVO> taskList) {
        this.taskList = taskList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSyncJobVO)) {
            return false;
        }
        DataSyncJobVO other = (DataSyncJobVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$migrateId = this.getMigrateId();
        Long other$migrateId = other.getMigrateId();
        if (this$migrateId == null ? other$migrateId != null : !((Object)this$migrateId).equals(other$migrateId)) {
            return false;
        }
        Long this$pipelineId = this.getPipelineId();
        Long other$pipelineId = other.getPipelineId();
        if (this$pipelineId == null ? other$pipelineId != null : !((Object)this$pipelineId).equals(other$pipelineId)) {
            return false;
        }
        Long this$operatorId = this.getOperatorId();
        Long other$operatorId = other.getOperatorId();
        if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
            return false;
        }
        Long this$dataSyncJobId = this.getDataSyncJobId();
        Long other$dataSyncJobId = other.getDataSyncJobId();
        if (this$dataSyncJobId == null ? other$dataSyncJobId != null : !((Object)this$dataSyncJobId).equals(other$dataSyncJobId)) {
            return false;
        }
        Long this$srcDatasourceId = this.getSrcDatasourceId();
        Long other$srcDatasourceId = other.getSrcDatasourceId();
        if (this$srcDatasourceId == null ? other$srcDatasourceId != null : !((Object)this$srcDatasourceId).equals(other$srcDatasourceId)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$metaVersion = this.getMetaVersion();
        String other$metaVersion = other.getMetaVersion();
        if (this$metaVersion == null ? other$metaVersion != null : !this$metaVersion.equals(other$metaVersion)) {
            return false;
        }
        String this$migrationType = this.getMigrationType();
        String other$migrationType = other.getMigrationType();
        if (this$migrationType == null ? other$migrationType != null : !this$migrationType.equals(other$migrationType)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$gmtCreate = this.getGmtCreate();
        String other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !this$gmtCreate.equals(other$gmtCreate)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$migrationStatus = this.getMigrationStatus();
        String other$migrationStatus = other.getMigrationStatus();
        if (this$migrationStatus == null ? other$migrationStatus != null : !this$migrationStatus.equals(other$migrationStatus)) {
            return false;
        }
        String this$migrationStatusPretty = this.getMigrationStatusPretty();
        String other$migrationStatusPretty = other.getMigrationStatusPretty();
        if (this$migrationStatusPretty == null ? other$migrationStatusPretty != null : !this$migrationStatusPretty.equals(other$migrationStatusPretty)) {
            return false;
        }
        List<DataSyncTaskVO> this$taskList = this.getTaskList();
        List<DataSyncTaskVO> other$taskList = other.getTaskList();
        return !(this$taskList == null ? other$taskList != null : !((Object)this$taskList).equals(other$taskList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSyncJobVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $migrateId = this.getMigrateId();
        result = result * 59 + ($migrateId == null ? 43 : ((Object)$migrateId).hashCode());
        Long $pipelineId = this.getPipelineId();
        result = result * 59 + ($pipelineId == null ? 43 : ((Object)$pipelineId).hashCode());
        Long $operatorId = this.getOperatorId();
        result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
        Long $dataSyncJobId = this.getDataSyncJobId();
        result = result * 59 + ($dataSyncJobId == null ? 43 : ((Object)$dataSyncJobId).hashCode());
        Long $srcDatasourceId = this.getSrcDatasourceId();
        result = result * 59 + ($srcDatasourceId == null ? 43 : ((Object)$srcDatasourceId).hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $metaVersion = this.getMetaVersion();
        result = result * 59 + ($metaVersion == null ? 43 : $metaVersion.hashCode());
        String $migrationType = this.getMigrationType();
        result = result * 59 + ($migrationType == null ? 43 : $migrationType.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : $gmtCreate.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $migrationStatus = this.getMigrationStatus();
        result = result * 59 + ($migrationStatus == null ? 43 : $migrationStatus.hashCode());
        String $migrationStatusPretty = this.getMigrationStatusPretty();
        result = result * 59 + ($migrationStatusPretty == null ? 43 : $migrationStatusPretty.hashCode());
        List<DataSyncTaskVO> $taskList = this.getTaskList();
        result = result * 59 + ($taskList == null ? 43 : ((Object)$taskList).hashCode());
        return result;
    }

    public String toString() {
        return "DataSyncJobVO(jobName=" + this.getJobName() + ", migrateId=" + this.getMigrateId() + ", pipelineId=" + this.getPipelineId() + ", operatorId=" + this.getOperatorId() + ", dataSyncJobId=" + this.getDataSyncJobId() + ", srcDatasourceId=" + this.getSrcDatasourceId() + ", metaVersion=" + this.getMetaVersion() + ", migrationType=" + this.getMigrationType() + ", errorMessage=" + this.getErrorMessage() + ", gmtCreate=" + this.getGmtCreate() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", description=" + this.getDescription() + ", migrationStatus=" + this.getMigrationStatus() + ", migrationStatusPretty=" + this.getMigrationStatusPretty() + ", taskList=" + String.valueOf(this.getTaskList()) + ")";
    }

    public static enum DataSyncJobStatus {
        FINISHED("\u5df2\u5b8c\u6210"),
        RUNNING("\u8fd0\u884c\u4e2d"),
        INIT("\u5f85\u6267\u884c");

        public String desc;

        private DataSyncJobStatus(String desc) {
            this.desc = desc;
        }
    }
}

