/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.hive;

import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.plugin.datasource.api.client.CommonDataSourceClient;
import org.apache.dolphinscheduler.plugin.datasource.api.provider.JdbcDataSourceProvider;
import org.apache.dolphinscheduler.plugin.datasource.utils.CommonUtil;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.PropertyUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.krb5.Config;

public class HiveDataSourceClient
extends CommonDataSourceClient {
    private static final Logger logger = LoggerFactory.getLogger(HiveDataSourceClient.class);
    private ScheduledExecutorService kerberosRenewalService;
    private Configuration hadoopConf;
    protected HikariDataSource oneSessionDataSource;
    private UserGroupInformation ugi;

    public HiveDataSourceClient(BaseConnectionParam baseConnectionParam, DbType dbType) {
        super(baseConnectionParam, dbType);
    }

    protected void preInit() {
        logger.info("PreInit in {}", (Object)((Object)((Object)this)).getClass().getName());
        this.kerberosRenewalService = Executors.newSingleThreadScheduledExecutor();
    }

    protected void initClient(BaseConnectionParam baseConnectionParam, DbType dbType) {
        logger.info("Create Configuration for hive configuration.");
        this.hadoopConf = this.createHadoopConf();
        logger.info("Create Configuration success.");
        logger.info("Create UserGroupInformation.");
        this.ugi = this.createUserGroupInformation(baseConnectionParam.getUser());
        logger.info("Create ugi success.");
        super.initClient(baseConnectionParam, dbType);
        this.oneSessionDataSource = JdbcDataSourceProvider.createOneSessionJdbcDataSource((BaseConnectionParam)baseConnectionParam, (DbType)dbType);
        logger.info("Init {} success.", (Object)((Object)((Object)this)).getClass().getName());
    }

    protected void checkEnv(BaseConnectionParam baseConnectionParam) {
        super.checkEnv(baseConnectionParam);
        this.checkKerberosEnv();
    }

    private void checkKerberosEnv() {
        String krb5File = PropertyUtils.getString((String)"java.security.krb5.conf.path");
        Boolean kerberosStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (boolean)false);
        if (kerberosStartupState.booleanValue() && StringUtils.isNotBlank((CharSequence)krb5File)) {
            System.setProperty("java.security.krb5.conf", krb5File);
            try {
                Config.refresh();
                Class<?> kerberosName = Class.forName("org.apache.hadoop.security.authentication.util.KerberosName");
                Field field = kerberosName.getDeclaredField("defaultRealm");
                field.setAccessible(true);
                field.set(null, Config.getInstance().getDefaultRealm());
            }
            catch (Exception e) {
                throw new RuntimeException("Update Kerberos environment failed.", e);
            }
        }
    }

    private UserGroupInformation createUserGroupInformation(String username) {
        String krb5File = PropertyUtils.getString((String)"java.security.krb5.conf.path");
        String keytab = PropertyUtils.getString((String)"login.user.keytab.path");
        String principal = PropertyUtils.getString((String)"login.user.keytab.username");
        try {
            UserGroupInformation ugi = CommonUtil.createUGI(this.getHadoopConf(), principal, keytab, krb5File, username);
            try {
                Field isKeytabField = ugi.getClass().getDeclaredField("isKeytab");
                isKeytabField.setAccessible(true);
                isKeytabField.set(ugi, true);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.warn(e.getMessage());
            }
            this.kerberosRenewalService.scheduleWithFixedDelay(() -> {
                try {
                    ugi.checkTGTAndReloginFromKeytab();
                }
                catch (IOException e) {
                    logger.error("Check TGT and Renewal from Keytab error", (Throwable)e);
                }
            }, 5L, 5L, TimeUnit.MINUTES);
            return ugi;
        }
        catch (IOException e) {
            throw new RuntimeException("createUserGroupInformation fail. ", e);
        }
    }

    protected Configuration createHadoopConf() {
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean("ipc.client.fallback-to-simple-auth-allowed", true);
        return hadoopConf;
    }

    protected Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public Connection getConnection() {
        try {
            return this.oneSessionDataSource.getConnection();
        }
        catch (SQLException e) {
            logger.error("get oneSessionDataSource Connection fail SQLException: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public void close() {
        super.close();
        logger.info("close HiveDataSourceClient.");
        this.kerberosRenewalService.shutdown();
        this.ugi = null;
        this.oneSessionDataSource.close();
        this.oneSessionDataSource = null;
    }
}

