/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.shell.converter;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.shell.ShellParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.utils.ScriptArgsReplace;
import com.aliyun.migration.workflow.migration.common.transform.di.sqoop.SqoopScriptConverter;
import com.aliyun.migration.workflow.migration.common.transform.shell.module.AbstractShellConverter;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell2DiConverter
extends AbstractShellConverter {
    private static final Logger log = LoggerFactory.getLogger(Shell2DiConverter.class);

    public Shell2DiConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
        this.workflow = workflow;
    }

    @Override
    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        Boolean isJson;
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(CodeProgramType.DI.name());
        try {
            JSONObject.parseObject((String)workflowNode.getScript());
            isJson = true;
        }
        catch (Exception e) {
            isJson = false;
        }
        if (isJson.booleanValue()) {
            ShellParameters parameter = (ShellParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(ShellParameters.class).getType());
            if (tgtworkflowNode.getParamMap() == null) {
                tgtworkflowNode.setParamMap(new HashMap());
            }
            ListUtils.emptyIfNull((List)parameter.getLocalParams()).forEach(x -> {
                String prop = x.getProp();
                String value = x.getValue();
                tgtworkflowNode.getParamMap().put(prop, value);
            });
            if (this.isShellScriptParamReplaceEnabled(workflowNode).booleanValue()) {
                parameter.setRawScript(ScriptArgsReplace.replace((String)parameter.getRawScript(), (Map)tgtworkflowNode.getParamMap(), (Map)this.workflow.getCustomProperties(), null));
            }
            tgtworkflowNode.setScript(this.convertScript(parameter.getRawScript()));
        } else {
            if (this.isShellScriptParamReplaceEnabled(workflowNode).booleanValue()) {
                workflowNode.setScript(ScriptArgsReplace.replace((String)workflowNode.getScript(), (Map)workflowNode.getParamMap(), (Map)this.workflow.getCustomProperties(), null));
            }
            tgtworkflowNode.setScript(this.convertScript(workflowNode.getScript()));
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private String convertScript(String rawScript) {
        if (rawScript.contains("sqoop") || rawScript.contains("Sqoop") || rawScript.contains("SQOOP")) {
            SqoopScriptConverter sqoopScriptConverter = new SqoopScriptConverter();
            String diDsMap = BwmJsonUtil.toJsonString(this.bwmConfiguration.getMap("self").get("di.datasource.map"));
            return sqoopScriptConverter.convert(rawScript, diDsMap);
        }
        return rawScript;
    }
}

