/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.merge.diff;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffConflictPair;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffElement;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffConstant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageDiffFileOperator {
    private static final Logger log = LoggerFactory.getLogger(PackageDiffFileOperator.class);

    public static void writeDiffConfictXls(List<DiffElement> srcDiffElementList, List<DiffElement> cvtDiffElementList, List<DiffElement> tgtDiffElementList, List<DiffConflictPair> diffConflictPair, File targetFile) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        diffElements.addAll(CollectionUtils.isEmpty(srcDiffElementList) ? new ArrayList<DiffElement>() : srcDiffElementList);
        diffElements.addAll(CollectionUtils.isEmpty(cvtDiffElementList) ? new ArrayList<DiffElement>() : cvtDiffElementList);
        diffElements.addAll(CollectionUtils.isEmpty(tgtDiffElementList) ? new ArrayList<DiffElement>() : tgtDiffElementList);
        PackageDiffFileOperator.exportDiffOverviewTable(workbook, diffElements, diffConflictPair);
        PackageDiffFileOperator.exportDiffConfictTable(workbook, diffConflictPair);
        PackageDiffFileOperator.exportDiffWholeTable(workbook, srcDiffElementList, "\u4fee\u6539\u660e\u7ec6\uff08\u8fc1\u79fb\u6e90\u7aef\uff09");
        PackageDiffFileOperator.exportDiffWholeTable(workbook, cvtDiffElementList, "\u4fee\u6539\u660e\u7ec6\uff08\u8fc1\u79fb\u8f6c\u6362\u7ed3\u679c\uff09");
        PackageDiffFileOperator.exportDiffWholeTable(workbook, tgtDiffElementList, "\u4fee\u6539\u660e\u7ec6\uff08\u8fc1\u79fb\u76ee\u6807\u7aef\uff09");
        File overviewFile = targetFile;
        if (!targetFile.getName().endsWith(".xls")) {
            overviewFile = new File(targetFile, "LHMPackageOverview.xls");
        }
        if (!overviewFile.getParentFile().exists()) {
            FileUtils.forceMkdir((File)overviewFile.getParentFile());
        }
        if (!overviewFile.exists()) {
            overviewFile.createNewFile();
        }
        FileOutputStream fileOut = new FileOutputStream(overviewFile);
        workbook.write((OutputStream)fileOut);
        workbook.close();
        fileOut.close();
    }

    public static void exportDiffWholeTable(HSSFWorkbook workbook, List<DiffElement> diffElements, String sheetName) {
        Object lineIndex;
        if (diffElements == null) {
            return;
        }
        HSSFSheet sheet = workbook.createSheet(sheetName);
        PackageDiffConstant.DiffType[] diffTypeArray = lineIndex = Integer.valueOf(0);
        lineIndex = lineIndex.intValue() + 1;
        PackageDiffFileOperator.fillNewRow(sheet.createRow(diffTypeArray.intValue()), List.of("\u4fee\u6539\u884c\u4e3aID", "\u4fee\u6539\u7c7b\u578b", "\u5de5\u4f5c\u6d41ID", "\u5de5\u4f5c\u6d41\u540d\u79f0", "\u8282\u70b9ID", "\u8282\u70b9\u540d\u79f0", "\u8840\u7f18\u5173\u7cfb", "\u5c5e\u6027\u540d\u79f0", "\u5c5e\u6027\u503c", "\u63cf\u8ff0", "\u5b50\u4fee\u6539"));
        for (PackageDiffConstant.DiffType diffType : PackageDiffConstant.DiffType.values()) {
            for (DiffElement diffElement : diffElements) {
                if (!diffElement.getDiffType().equals((Object)diffType)) continue;
                PackageDiffConstant.DiffType[] diffTypeArray2 = lineIndex;
                lineIndex = lineIndex.intValue() + 1;
                Object[] objectArray = new Object[11];
                objectArray[0] = diffElement.getDiffId();
                objectArray[1] = diffElement.getDiffType().getDescription();
                Object object = diffElement.getWorkflow() != null ? diffElement.getWorkflow().getWorkflowId() : (objectArray[2] = diffElement.getWorkflowNode() == null ? "" : diffElement.getWorkflowNode().getWorkflowId());
                objectArray[3] = diffElement.getWorkflow() != null ? diffElement.getWorkflow().getWorkflowName() : (diffElement.getWorkflowNode() == null ? "" : diffElement.getWorkflowNode().getWorkflowName());
                objectArray[4] = diffElement.getWorkflowNode() != null ? diffElement.getWorkflowNode().getNodeId() : "";
                objectArray[5] = diffElement.getWorkflowNode() != null ? diffElement.getWorkflowNode().getNodeName() : "";
                objectArray[6] = diffElement.getRelation() != null ? diffElement.getRelation().getFrom() + "->" + diffElement.getRelation().getTo() + "(" + diffElement.getRelation().getReType() + ")" : "";
                objectArray[7] = diffElement.getPropertyPath() != null ? diffElement.getPropertyPath() : "";
                objectArray[8] = diffElement.getPropertyValue() != null ? diffElement.getPropertyValue() : "";
                objectArray[9] = diffElement.getComment() != null ? diffElement.getComment() : "";
                objectArray[10] = diffElement.getChildDiffId() != null ? diffElement.getChildDiffId().toString() : "";
                PackageDiffFileOperator.fillNewRow(sheet.createRow(diffTypeArray2.intValue()), List.of(objectArray));
            }
        }
    }

    public static JSONArray exportDiffWholeTable(List<DiffElement> diffElements) {
        JSONArray jsonArray = new JSONArray();
        if (CollectionUtils.isEmpty(diffElements)) {
            return jsonArray;
        }
        for (DiffElement diffElement : diffElements) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"uuid", (Object)diffElement.getDiffId());
            jsonObject.put((Object)"diff_type", (Object)diffElement.getDiffType().getDescription());
            jsonObject.put((Object)"project_id", diffElement.getProject() != null ? diffElement.getProject().getProjectId() : null);
            jsonObject.put((Object)"project_name", diffElement.getProject() != null ? diffElement.getProject().getName() : null);
            jsonObject.put((Object)"workflow_id", diffElement.getWorkflow() != null ? diffElement.getWorkflow().getWorkflowId() : (diffElement.getWorkflowNode() == null ? null : diffElement.getWorkflowNode().getWorkflowId()));
            jsonObject.put((Object)"workflow_name", diffElement.getWorkflow() != null ? diffElement.getWorkflow().getWorkflowName() : (diffElement.getWorkflowNode() == null ? null : diffElement.getWorkflowNode().getWorkflowName()));
            jsonObject.put((Object)"node_id", diffElement.getWorkflowNode() != null ? diffElement.getWorkflowNode().getNodeId() : null);
            jsonObject.put((Object)"node_name", diffElement.getWorkflowNode() != null ? diffElement.getWorkflowNode().getNodeName() : null);
            jsonObject.put((Object)"relation", diffElement.getRelation() != null ? diffElement.getRelation().getFrom() + "->" + diffElement.getRelation().getTo() + "(" + diffElement.getRelation().getReType() + ")" : null);
            jsonObject.put((Object)"property_name", (Object)(diffElement.getPropertyPath() != null ? diffElement.getPropertyPath() : null));
            jsonObject.put((Object)"property_value", (Object)(diffElement.getPropertyValue() != null ? diffElement.getPropertyValue() : null));
            jsonObject.put((Object)"description", (Object)(diffElement.getComment() != null ? diffElement.getComment() : null));
            jsonObject.put((Object)"child_diff", diffElement.getChildDiffId() != null ? diffElement.getChildDiffId().toString() : null);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public static void exportDiffTable(HSSFWorkbook workbook, List<DiffElement> diffElements, PackageDiffConstant.DiffType diffType) {
        HSSFSheet sheet = workbook.createSheet(diffType.name());
        Integer lineIndex = 0;
        Integer n = lineIndex;
        lineIndex = lineIndex + 1;
        PackageDiffFileOperator.fillNewRow(sheet.createRow(n.intValue()), List.of("\u4fee\u6539\u884c\u4e3aID", "\u5de5\u4f5c\u6d41ID", "\u5de5\u4f5c\u6d41\u540d\u79f0", "\u8282\u70b9ID", "\u8282\u70b9\u540d\u79f0", "\u8840\u7f18\u5173\u7cfb", "\u5c5e\u6027\u540d\u79f0", "\u5c5e\u6027\u503c", "\u63cf\u8ff0", "\u5b50\u4fee\u6539"));
        for (DiffElement diffElement : diffElements) {
            if (!diffElement.getDiffType().equals((Object)diffType)) continue;
            Integer n2 = lineIndex;
            lineIndex = lineIndex + 1;
            PackageDiffFileOperator.fillNewRow(sheet.createRow(n2.intValue()), List.of(diffElement.getDiffId(), diffElement.getWorkflow() != null ? diffElement.getWorkflow().getWorkflowId() : (diffElement.getWorkflowNode() == null ? "" : diffElement.getWorkflowNode().getWorkflowId()), diffElement.getWorkflow() != null ? diffElement.getWorkflow().getWorkflowName() : (diffElement.getWorkflowNode() == null ? "" : diffElement.getWorkflowNode().getWorkflowName()), diffElement.getWorkflowNode() != null ? diffElement.getWorkflowNode().getNodeId() : "", diffElement.getWorkflowNode() != null ? diffElement.getWorkflowNode().getNodeName() : "", diffElement.getRelation() != null ? diffElement.getRelation().getFrom() + "->" + diffElement.getRelation().getTo() + "(" + diffElement.getRelation().getReType() + ")" : "", diffElement.getPropertyPath() != null ? diffElement.getPropertyPath() : "", diffElement.getPropertyValue() != null ? diffElement.getPropertyValue() : "", diffElement.getComment() != null ? diffElement.getComment() : "", diffElement.getChildDiffId() != null ? diffElement.getChildDiffId().toString() : ""));
        }
    }

    public static void exportDiffConfictTable(HSSFWorkbook workbook, List<DiffConflictPair> diffConflictPairs) {
        if (diffConflictPairs == null) {
            return;
        }
        HSSFSheet sheet = workbook.createSheet("\u51b2\u7a81\u5904\u7406");
        Integer lineIndex = 0;
        Integer n = lineIndex;
        lineIndex = lineIndex + 1;
        PackageDiffFileOperator.fillNewRow(sheet.createRow(n.intValue()), List.of("\u6e90\u7aef\u4fee\u6539\u884c\u4e3aID", "\u76ee\u6807\u7aef\u4fee\u6539\u884c\u4e3aID", "\u51b2\u7a81\u7c7b\u578b", "\u6e90\u7aef\u4fee\u6539\u7c7b\u578b", "\u76ee\u6807\u7aef\u4fee\u6539\u7c7b\u578b", "\u6e90\u7aef\u4fee\u6539\u8be6\u60c5", "\u76ee\u6807\u7aef\u4fee\u6539\u8be6\u60c5", "\u91c7\u7eb3\u6e90\u7aef/\u76ee\u6807\u7aef\uff08S/T\uff0c\u9ed8\u8ba4S\uff09"));
        for (DiffConflictPair diffConflictPair : diffConflictPairs) {
            List<String> subHead = List.of("\u5de5\u4f5c\u6d41ID", "\u5de5\u4f5c\u6d41\u540d\u79f0", "\u8282\u70b9ID", "\u8282\u70b9\u540d\u79f0", "\u8840\u7f18\u5173\u7cfb", "\u5c5e\u6027\u540d\u79f0", "\u5c5e\u6027\u503c", "\u63cf\u8ff0", "\u5b50\u4fee\u6539");
            DiffElement srcDiffElement = diffConflictPair.getSrcDiffElement();
            DiffElement tgtDiffElement = diffConflictPair.getTargetDiffElement();
            List<String> srcInfoDetail = List.of(srcDiffElement.getWorkflow() != null ? srcDiffElement.getWorkflow().getWorkflowId() : (srcDiffElement.getWorkflowNode() == null ? "" : srcDiffElement.getWorkflowNode().getWorkflowId()), srcDiffElement.getWorkflow() != null ? srcDiffElement.getWorkflow().getWorkflowName() : (srcDiffElement.getWorkflowNode() == null ? "" : srcDiffElement.getWorkflowNode().getWorkflowName()), srcDiffElement.getWorkflowNode() != null ? srcDiffElement.getWorkflowNode().getNodeId() : "", srcDiffElement.getWorkflowNode() != null ? srcDiffElement.getWorkflowNode().getNodeName() : "", srcDiffElement.getRelation() != null ? srcDiffElement.getRelation().getFrom() + "->" + srcDiffElement.getRelation().getTo() + "(" + srcDiffElement.getRelation().getReType() + ")" : "", srcDiffElement.getPropertyPath() != null ? srcDiffElement.getPropertyPath() : "", srcDiffElement.getPropertyValue() != null ? srcDiffElement.getPropertyValue() : "", srcDiffElement.getComment() != null ? srcDiffElement.getComment() : "", srcDiffElement.getChildDiffId() != null ? srcDiffElement.getChildDiffId().toString() : "");
            List<String> tgtInfoDetail = List.of(tgtDiffElement.getWorkflow() != null ? tgtDiffElement.getWorkflow().getWorkflowId() : (tgtDiffElement.getWorkflowNode() == null ? "" : tgtDiffElement.getWorkflowNode().getWorkflowId()), tgtDiffElement.getWorkflow() != null ? tgtDiffElement.getWorkflow().getWorkflowName() : (tgtDiffElement.getWorkflowNode() == null ? "" : tgtDiffElement.getWorkflowNode().getWorkflowName()), tgtDiffElement.getWorkflowNode() != null ? tgtDiffElement.getWorkflowNode().getNodeId() : "", tgtDiffElement.getWorkflowNode() != null ? tgtDiffElement.getWorkflowNode().getNodeName() : "", tgtDiffElement.getRelation() != null ? tgtDiffElement.getRelation().getFrom() + "->" + tgtDiffElement.getRelation().getTo() + "(" + tgtDiffElement.getRelation().getReType() + ")" : "", tgtDiffElement.getPropertyPath() != null ? tgtDiffElement.getPropertyPath() : "", tgtDiffElement.getPropertyValue() != null ? tgtDiffElement.getPropertyValue() : "", tgtDiffElement.getComment() != null ? tgtDiffElement.getComment() : "", tgtDiffElement.getChildDiffId() != null ? tgtDiffElement.getChildDiffId().toString() : "");
            String srcDiffInfo = PackageDiffFileOperator.joinDict(subHead, srcInfoDetail);
            String tgtDiffInfo = PackageDiffFileOperator.joinDict(subHead, tgtInfoDetail);
            Integer n2 = lineIndex;
            lineIndex = lineIndex + 1;
            PackageDiffFileOperator.fillNewRow(sheet.createRow(n2.intValue()), List.of(diffConflictPair.getSrcDiffElement().getDiffId(), diffConflictPair.getTargetDiffElement().getDiffId(), diffConflictPair.getDiffConflictType().getDescription(), diffConflictPair.getSrcDiffElement().getDiffType().getDescription(), diffConflictPair.getTargetDiffElement().getDiffType().getDescription(), srcDiffInfo, tgtDiffInfo, diffConflictPair.getChoseSrc() == null || Boolean.TRUE.equals(diffConflictPair.getChoseSrc()) ? "S" : "T"));
        }
    }

    public static JSONArray exportDiffConfictTable(List<DiffConflictPair> diffConflictPairs) {
        JSONArray jsonArray = new JSONArray();
        if (CollectionUtils.isEmpty(diffConflictPairs)) {
            return jsonArray;
        }
        for (DiffConflictPair diffConflictPair : diffConflictPairs) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"src_diff_id", (Object)diffConflictPair.getSrcDiffElement().getDiffId());
            jsonObject.put((Object)"tgt_diff_id", (Object)diffConflictPair.getTargetDiffElement().getDiffId());
            jsonObject.put((Object)"conflict_type", (Object)diffConflictPair.getDiffConflictType().getDescription());
            jsonObject.put((Object)"decision", (Object)(diffConflictPair.getChoseSrc() == null || Boolean.TRUE.equals(diffConflictPair.getChoseSrc()) ? "S" : "T"));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public static void exportDiffOverviewTable(HSSFWorkbook workbook, List<DiffElement> diffElements, List<DiffConflictPair> diffConflictPair) {
        Integer n;
        Integer lineIndex;
        HSSFSheet sheet = workbook.createSheet("\u6982\u89c8");
        Integer object2 = lineIndex = Integer.valueOf(0);
        lineIndex = lineIndex + 1;
        PackageDiffFileOperator.fillNewRow(sheet.createRow(object2.intValue()), List.of("\u6e90\u7aefDiff\u603b\u6570", Long.valueOf(diffElements.stream().filter(diffElement -> diffElement.getDiffType().getSourceOrTarget().equals((Object)PackageDiffConstant.SourceOrTarget.SOURCE)).count())));
        Integer n2 = lineIndex;
        lineIndex = lineIndex + 1;
        PackageDiffFileOperator.fillNewRow(sheet.createRow(n2.intValue()), List.of("\u8f6c\u6362\u7ed3\u679cDiff\u603b\u6570", Long.valueOf(diffElements.stream().filter(diffElement -> diffElement.getDiffType().getSourceOrTarget().equals((Object)PackageDiffConstant.SourceOrTarget.CONVERT)).count())));
        Integer n3 = lineIndex;
        lineIndex = lineIndex + 1;
        PackageDiffFileOperator.fillNewRow(sheet.createRow(n3.intValue()), List.of("\u76ee\u6807\u7aefDiff\u603b\u6570", Long.valueOf(diffElements.stream().filter(diffElement -> diffElement.getDiffType().getSourceOrTarget().equals((Object)PackageDiffConstant.SourceOrTarget.TARGET)).count())));
        Integer n4 = lineIndex;
        lineIndex = lineIndex + 1;
        PackageDiffFileOperator.fillNewRow(sheet.createRow(n4.intValue()), List.of("\u5f85\u89e3\u51b3Diff\u51b2\u7a81\u603b\u6570", Integer.valueOf(diffConflictPair.size())));
        Integer n5 = lineIndex;
        lineIndex = lineIndex + 1;
        for (PackageDiffConstant.DiffType diffType : PackageDiffConstant.DiffType.values()) {
            if (!diffType.getSourceOrTarget().equals((Object)PackageDiffConstant.SourceOrTarget.SOURCE)) continue;
            n = lineIndex;
            lineIndex = lineIndex + 1;
            PackageDiffFileOperator.fillNewRow(sheet.createRow(n.intValue()), List.of(diffType.name(), diffType.getDescription(), Long.valueOf(diffElements.stream().filter(diffElement -> diffElement.getDiffType().equals((Object)diffType)).count()), "\u4e2a"));
        }
        Integer n6 = lineIndex;
        lineIndex = lineIndex + 1;
        for (PackageDiffConstant.DiffType diffType : PackageDiffConstant.DiffType.values()) {
            if (!diffType.getSourceOrTarget().equals((Object)PackageDiffConstant.SourceOrTarget.CONVERT)) continue;
            n = lineIndex;
            lineIndex = lineIndex + 1;
            PackageDiffFileOperator.fillNewRow(sheet.createRow(n.intValue()), List.of(diffType.name(), diffType.getDescription(), Long.valueOf(diffElements.stream().filter(diffElement -> diffElement.getDiffType().equals((Object)diffType)).count()), "\u4e2a"));
        }
        Integer n7 = lineIndex;
        lineIndex = lineIndex + 1;
        for (PackageDiffConstant.DiffType diffType : PackageDiffConstant.DiffType.values()) {
            if (!diffType.getSourceOrTarget().equals((Object)PackageDiffConstant.SourceOrTarget.TARGET)) continue;
            n = lineIndex;
            lineIndex = lineIndex + 1;
            PackageDiffFileOperator.fillNewRow(sheet.createRow(n.intValue()), List.of(diffType.name(), diffType.getDescription(), Long.valueOf(diffElements.stream().filter(diffElement -> diffElement.getDiffType().equals((Object)diffType)).count()), "\u4e2a"));
        }
        CellRangeAddress cellRangeAddress = new CellRangeAddress(1, 24, 4, 15);
        sheet.addMergedRegion(cellRangeAddress);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        HSSFFont font = workbook.createFont();
        font.setColor(IndexedColors.valueOf((String)StatisticsReportConstant.CAN_MODIFY_COLOR).getIndex());
        style.setFont((Font)font);
        HSSFCell cell = sheet.getRow(1).createCell(4);
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue("\u4f7f\u7528\u8bf4\u660e\uff1a\n\n\u672c\u8868\u683c\u4e3aLHM\u8c03\u5ea6\u8fc1\u79fb\u6e90\u7aef\u4e0e\u76ee\u6807\u7aef\u96c6\u7fa4Diff&Merge\u8be6\u8868\u3002\n\n\u7531\u4e8e\u5927\u6570\u636e\u96c6\u7fa4\u8fc1\u79fb\u662f\u4e00\u4e2a\u6301\u7eed\u6027\u8fc7\u7a0b\uff0c\u65f6\u95f4\u5468\u671f\u6839\u636e\u89c4\u6a21\u4e0e\u590d\u6742\u5ea6\u53ef\u80fd\u4ece\u6570\u5468\u81f3\u6570\u6708\u4e0d\u7b49\uff0c\u56e0\u6b64\u4e00\u8fb9\u8fdb\u884c\u8fc1\u79fb\u4e00\u8fb9\u6e90\u7aef\u6301\u7eed\u6027\u5f00\u53d1\u3001\u4e00\u8fb9\u8fc1\u79fb\u4e00\u8fb9\u76ee\u6807\u7aef\u8fdb\u884c\u96c6\u7fa4\u9002\u914d\u6027\u6539\u9020\u662f\u6bd4\u8f83\u5e38\u89c1\u7684\u3002\u901a\u5e38\u9700\u8981\u591a\u8f6e\u8fc1\u79fb\u6765\u540c\u6b65\u6e90\u7aef\u7684\u53d8\u66f4\uff08\u542b\u589e\u91cf\uff09\uff0c\u540c\u65f6\u5c06\u6709\u9009\u62e9\u7684\u4fdd\u7559\u5728\u76ee\u6807\u7aef\u7684\u4e00\u4e9b\u6539\u9020\u8c03\u6574\uff0c\u57fa\u4e8e\u4ee5\u4e0a\u60c5\u51b5\uff0cLHM\u8c03\u5ea6\u8fc1\u79fb\u5de5\u5177\u63d0\u4f9b\u4e86\u6e90\u4e0e\u76ee\u6807\u540c\u6b65\u53d8\u66f4\u65f6\u7684\u6709\u9009\u62e9\u6027Merge\u80fd\u529b\u2014\u2014\u8bc6\u522b\u53cc\u7aef\u7684\u53d8\u66f4\uff0c\u5e76\u63d0\u793a\u51b2\u7a81\u90e8\u5206\uff0c\u8ba9\u7528\u6237\u6709\u9009\u62e9\u6027\u7684\u8fdb\u884c\u5411\u76ee\u6807\u7aef\u7684\u8986\u5199\u3002\u5e38\u89c1\u7684\u53cc\u7aef\u53d8\u66f4\u51b2\u7a81\u573a\u666f\uff1a\u6e90\u7aef\u3001\u76ee\u6807\u7aef\u5747\u4fee\u6539\u4e86\u540c\u4e00\u8282\u70b9\u7684\u811a\u672c\u4ee3\u7801\u3002\n\n\u9700\u8981\u6ce8\u610f\u7684\u662f\uff0c\u53cc\u7aef\u7684\u5f02\u6784\u6027\u5bfc\u81f4\u6e90\u7aef\u7684\u53d8\u66f4\u4e0e\u76ee\u6807\u7aef\u7684\u53d8\u66f4\u96be\u4ee5\u5bf9\u7167\u3001\u96be\u4ee5\u5408\u5e76\u3002\u8003\u8651\u5230\u6e90\u7aef\u53d8\u66f4\u4f1a\u53cd\u6620\u5230\u8f6c\u6362\u7ed3\u679c\u7684\u53d8\u5316\u4e0a\uff0c\u800c\u8f6c\u6362\u7ed3\u679c\u4e0e\u76ee\u6807\u7aef\u7684\u6570\u636e\u7ed3\u6784\u4e00\u81f4\uff0c\u56e0\u6b64\u672c\u8868\u683c\u4e2d\u4e5f\u4f1a\u5c06\u8f6c\u6362\u7ed3\u679c\u7684\u53d8\u5316\u5c55\u793a\u51fa\u6765\uff0c\u540c\u6837\u89c6\u4f5c\u6e90\u7aef\u7684\u53d8\u66f4\uff0c\u57fa\u4e8e\u8f6c\u6362\u7ed3\u679c\u7684\u53d8\u66f4\u4e0e\u76ee\u6807\u7aef\u7684\u53d8\u66f4\u76f8Merge\u3002Merge\u884c\u4e3a\u5c06\u53d1\u751f\u4e8e\u8c03\u5ea6\u8f6c\u6362\u4e0e\u8c03\u5ea6\u63d0\u4ea4\u4e4b\u95f4\u3002\n\n\u5de5\u5177\u5c06\u9ed8\u8ba4\u91c7\u7eb3\u65e0\u51b2\u7a81\u7684\u4fee\u6539\u3002\n\n\u4e3a\u964d\u4f4e\u5b9e\u65bd\u98ce\u9669\uff0c\u5de5\u5177\u5c06\u4fdd\u5b88\u5904\u7406\u7528\u6237\u5728\u6e90\u7aef\u4e0e\u76ee\u6807\u7aef\u7684\u5220\u9664\u52a8\u4f5c\uff1a\n1. \u6e90\u7aef\u5220\u9664\uff1a\u4e0d\u5728\u76ee\u6807\u7aef\u4e0a\u6267\u884c\u76f8\u5e94\u5220\u9664\uff1b\n2. \u76ee\u6807\u7aef\u5220\u9664\uff1a\u6062\u590d\u4e3a\u6e90\u7aef\u7684\u6700\u65b0\u7248\u672c\u3002\n\u82e5\u4ecd\u9700\u5220\u9664\uff0c\u8bf7\u5728\u5de5\u5177\u5bfc\u5165DataWorks\u540e\u624b\u52a8\u5220\u9664\u3002\u53ef\u5c06\u672c\u8868\u683c\u4e2d\u8bb0\u5f55\u7684\u5220\u9664Diff\u4f5c\u4e3a\u8f85\u52a9\u3002");
    }

    private static void fillNewRow(HSSFRow row, List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            HSSFCell cell = row.createCell(i, CellType.BLANK);
            cell.setCellValue((String)(String.valueOf(values.get(i)).length() > 32000 ? "(\u8d85\u957f\u5f02\u5e38)" + String.valueOf(values.get(i)).substring(0, 32000) + " ..." : String.valueOf(values.get(i))));
        }
    }

    public static String joinDict(List<String> keys, List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            sb.append(keys.get(i)).append(":").append(values.get(i)).append("\n");
        }
        return sb.toString();
    }

    public static void getUserMergeChoose(File file, List<DiffElement> srcDiffElementList, List<DiffElement> cvtDiffElementList, List<DiffElement> tgtDiffElementList, List<DiffConflictPair> diffConflictPair) {
        if (!(file != null && file.exists() && file.isFile() && file.getName().endsWith(".xls"))) {
            log.error("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684Merge\u8868\uff01");
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fis);
            HashMap<String, DiffElement> srcDiffElementMap = new HashMap<String, DiffElement>();
            PackageDiffFileOperator.getDiffFromTable((Workbook)workbook, "\u4fee\u6539\u660e\u7ec6\uff08\u8fc1\u79fb\u6e90\u7aef\uff09", srcDiffElementMap);
            srcDiffElementList.addAll(srcDiffElementMap.values());
            HashMap<String, DiffElement> cvtDiffElementMap = new HashMap<String, DiffElement>();
            PackageDiffFileOperator.getDiffFromTable((Workbook)workbook, "\u4fee\u6539\u660e\u7ec6\uff08\u8fc1\u79fb\u8f6c\u6362\u7ed3\u679c\uff09", cvtDiffElementMap);
            cvtDiffElementList.addAll(cvtDiffElementMap.values());
            HashMap<String, DiffElement> tgtDiffElementMap = new HashMap<String, DiffElement>();
            PackageDiffFileOperator.getDiffFromTable((Workbook)workbook, "\u4fee\u6539\u660e\u7ec6\uff08\u8fc1\u79fb\u76ee\u6807\u7aef\uff09", tgtDiffElementMap);
            tgtDiffElementList.addAll(tgtDiffElementMap.values());
            Sheet sheet = workbook.getSheet("\u51b2\u7a81\u5904\u7406");
            for (int line_index = 1; line_index < sheet.getPhysicalNumberOfRows(); ++line_index) {
                Row row = sheet.getRow(line_index);
                String srcDiffId = row.getCell(0).getStringCellValue();
                String tgtDiffId = row.getCell(1).getStringCellValue();
                String choose = row.getCell(7).getStringCellValue();
                diffConflictPair.add(DiffConflictPair.builder().srcDiffElement((DiffElement)cvtDiffElementMap.get(srcDiffId)).targetDiffElement((DiffElement)tgtDiffElementMap.get(tgtDiffId)).choseSrc(StringUtils.equals((CharSequence)choose, (CharSequence)"S")).build());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u9009\u62e9\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static void getDiffFromTable(Workbook workbook, String tableName, Map<String, DiffElement> diffElements) {
        Sheet sheet = workbook.getSheet(tableName);
        if (sheet == null) {
            return;
        }
        for (int line_index = 1; line_index < sheet.getPhysicalNumberOfRows(); ++line_index) {
            Row row = sheet.getRow(line_index);
            DiffElement diffElement = DiffElement.builder().diffId(row.getCell(0).getStringCellValue()).diffType(PackageDiffConstant.DiffType.getDiffType(row.getCell(1).getStringCellValue())).propertyPath(StringUtils.isEmpty((CharSequence)row.getCell(7).getStringCellValue()) ? null : row.getCell(7).getStringCellValue()).propertyValue(StringUtils.isEmpty((CharSequence)row.getCell(8).getStringCellValue()) ? null : row.getCell(8).getStringCellValue()).comment(StringUtils.isEmpty((CharSequence)row.getCell(9).getStringCellValue()) ? null : row.getCell(9).getStringCellValue()).childDiffId((List<String>)(StringUtils.isEmpty((CharSequence)row.getCell(10).getStringCellValue()) ? null : new ArrayList<String>(List.of(row.getCell(10).getStringCellValue().replaceAll("[\\[\\]]", "").split(", "))))).build();
            String workflowId = row.getCell(2).getStringCellValue();
            String workflowName = row.getCell(3).getStringCellValue();
            String workflowNodeId = row.getCell(4).getStringCellValue();
            String workflowNodeName = row.getCell(5).getStringCellValue();
            String relation = row.getCell(6).getStringCellValue();
            switch (diffElement.getDiffType().getElementType()) {
                case WORKFLOW: {
                    Workflow wf = new Workflow();
                    wf.setWorkflowId(workflowId);
                    wf.setWorkflowName(workflowName);
                    diffElement.setWorkflow(wf);
                    break;
                }
                case NODE: {
                    WorkflowNode wn = new WorkflowNode();
                    wn.setWorkflowId(workflowId);
                    wn.setWorkflowName(workflowName);
                    wn.setNodeId(workflowNodeId);
                    wn.setNodeName(workflowNodeName);
                    diffElement.setWorkflowNode(wn);
                    break;
                }
                case RELATION: {
                    RelationPackage rp = new RelationPackage();
                    Pattern pattern = Pattern.compile("(\\d+)->(\\d+)\\((\\w+)\\)");
                    Matcher matcher = pattern.matcher(relation);
                    if (matcher.find()) {
                        rp.setFrom(matcher.group(1));
                        rp.setTo(matcher.group(2));
                        rp.setReType(RelationPackage.ReType.valueOf((String)matcher.group(3)));
                    }
                    diffElement.setRelation(rp);
                }
            }
            diffElements.put(diffElement.getDiffId(), diffElement);
        }
    }
}

